/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.infra;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.security.api.AuthorizationMapper;
import fr.enedis.chutney.security.api.AuthorizationsDto;
import fr.enedis.chutney.security.domain.Authorizations;
import fr.enedis.chutney.server.core.domain.security.UserRoles;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class JsonFileAuthorizations
implements Authorizations {
    private static final String AUTHORIZATION_FILE_NAME = "authorization.json";
    private static final Path ROOT_DIRECTORY_NAME = Paths.get("roles", new String[0]);
    private final Path authorizationFilePath;
    private final ObjectMapper om = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.ALWAYS);

    JsonFileAuthorizations(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String configFolderPath) throws UncheckedIOException {
        Path storeFolderPath = Paths.get(configFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        this.authorizationFilePath = storeFolderPath.resolve(AUTHORIZATION_FILE_NAME);
        FileUtils.initFolder((Path)storeFolderPath);
        this.initAuthorizationFile();
    }

    @Override
    public UserRoles read() {
        try {
            byte[] bytes = Files.readAllBytes(this.authorizationFilePath);
            try {
                return AuthorizationMapper.fromDto((AuthorizationsDto)this.om.readValue(bytes, AuthorizationsDto.class));
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize authorization file : " + String.valueOf(this.authorizationFilePath), e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read authorization file : " + String.valueOf(this.authorizationFilePath), e);
        }
    }

    @Override
    public void save(UserRoles userRoles) {
        try {
            byte[] bytes = this.om.writeValueAsBytes((Object)AuthorizationMapper.toDto(userRoles));
            try {
                Files.write(this.authorizationFilePath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write authorization file : " + String.valueOf(this.authorizationFilePath), e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize authorizations", e);
        }
    }

    private void initAuthorizationFile() {
        if (Files.notExists(this.authorizationFilePath, new LinkOption[0])) {
            this.save(UserRoles.builder().build());
        }
    }
}

