/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.infra.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import fr.enedis.chutney.security.infra.jwt.ChutneyJwtProperties;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

public class JwtUtil {
    private final ChutneyJwtProperties chutneyJwtProperties;
    private final RSAKey signinKey;
    private final JWSAlgorithm algorithm;

    public JwtUtil(ChutneyJwtProperties chutneyJwtProperties) throws JOSEException {
        this.chutneyJwtProperties = chutneyJwtProperties;
        this.signinKey = (RSAKey)new RSAKeyGenerator(2048).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).generate();
        this.algorithm = JWSAlgorithm.RS256;
    }

    public NimbusJwtDecoder nimbusJwtDecoder() throws JOSEException {
        return NimbusJwtDecoder.withPublicKey((RSAPublicKey)this.signinKey.toRSAPublicKey()).build();
    }

    public String generateToken(String username, Map<String, Object> claims) {
        String issuer = this.chutneyJwtProperties.issuer();
        Instant issuedAt = Instant.now();
        Instant expirationTime = issuedAt.plus(Duration.ofMillis(this.chutneyJwtProperties.expiresIn().toMillis()));
        JWSHeader header = new JWSHeader(this.algorithm);
        JWTClaimsSet.Builder claimsSetBuilder = new JWTClaimsSet.Builder().subject(username).issuer(issuer).issueTime(Date.from(issuedAt)).expirationTime(Date.from(expirationTime));
        claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)claimsSetBuilder).claim(arg_0, arg_1));
        JWTClaimsSet claimsSet = claimsSetBuilder.build();
        SignedJWT jwt = new SignedJWT(header, claimsSet);
        try {
            RSASSASigner signer = new RSASSASigner(this.signinKey);
            jwt.sign((JWSSigner)signer);
            return jwt.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException("Unable to generate JWT", e);
        }
    }
}

