/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.infra.memory;

import fr.enedis.chutney.security.domain.AuthenticationService;
import fr.enedis.chutney.security.infra.memory.InMemoryUserDetailsService;
import fr.enedis.chutney.security.infra.memory.InMemoryUsersProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@Profile(value={"mem-auth"})
public class InMemorySecurityConfiguration {
    @Bean
    @ConfigurationProperties(value="chutney.security")
    public InMemoryUsersProperties users() {
        return new InMemoryUsersProperties();
    }

    @Bean
    public InMemoryUserDetailsService inMemoryUserDetailsService(InMemoryUsersProperties users, AuthenticationService authenticationService) {
        return new InMemoryUserDetailsService(users, authenticationService);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Configuration
    @Profile(value={"mem-auth"})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Autowired
        protected void configure(AuthenticationManagerBuilder auth, InMemoryUserDetailsService userDetailsService) throws Exception {
            auth.userDetailsService((UserDetailsService)userDetailsService);
        }
    }
}

