/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.infra.memory;

import fr.enedis.chutney.security.api.UserDto;
import fr.enedis.chutney.security.domain.AuthenticationService;
import fr.enedis.chutney.security.infra.UserDetailsServiceHelper;
import fr.enedis.chutney.security.infra.memory.InMemoryUsersProperties;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class InMemoryUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryUserDetailsService.class);
    private final Map<String, UserDto> users;
    private final AuthenticationService authenticationService;

    public InMemoryUserDetailsService(InMemoryUsersProperties inMemoryUsersProperties, AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.users = inMemoryUsersProperties.getUsers().stream().collect(Collectors.toUnmodifiableMap(UserDto::getUsername, Function.identity()));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional<UserDto> user = Optional.ofNullable(this.users.get(username));
        return user.map(u -> UserDetailsServiceHelper.grantAuthoritiesFromUserRole(u, this.authenticationService)).orElseThrow(() -> new UsernameNotFoundException("Username not found."));
    }
}

