
package fr.enedis.chutney.design.api.editionlock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TestCaseEditionDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTestCaseEditionDto.builder()}.
 */
@Generated(from = "TestCaseEditionDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTestCaseEditionDto
    implements TestCaseEditionDto {
  private final String testCaseId;
  private final Integer testCaseVersion;
  private final Instant editionStartDate;
  private final String editionUser;

  private ImmutableTestCaseEditionDto(
      String testCaseId,
      Integer testCaseVersion,
      Instant editionStartDate,
      String editionUser) {
    this.testCaseId = testCaseId;
    this.testCaseVersion = testCaseVersion;
    this.editionStartDate = editionStartDate;
    this.editionUser = editionUser;
  }

  /**
   * @return The value of the {@code testCaseId} attribute
   */
  @JsonProperty(value = "testCaseId", required = true)
  @Override
  public String testCaseId() {
    return testCaseId;
  }

  /**
   * @return The value of the {@code testCaseVersion} attribute
   */
  @JsonProperty(value = "testCaseVersion", required = true)
  @Override
  public Integer testCaseVersion() {
    return testCaseVersion;
  }

  /**
   * @return The value of the {@code editionStartDate} attribute
   */
  @JsonProperty(value = "editionStartDate", required = true)
  @Override
  public Instant editionStartDate() {
    return editionStartDate;
  }

  /**
   * @return The value of the {@code editionUser} attribute
   */
  @JsonProperty(value = "editionUser", required = true)
  @Override
  public String editionUser() {
    return editionUser;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TestCaseEditionDto#testCaseId() testCaseId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for testCaseId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTestCaseEditionDto withTestCaseId(String value) {
    String newValue = Objects.requireNonNull(value, "testCaseId");
    if (this.testCaseId.equals(newValue)) return this;
    return new ImmutableTestCaseEditionDto(newValue, this.testCaseVersion, this.editionStartDate, this.editionUser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TestCaseEditionDto#testCaseVersion() testCaseVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for testCaseVersion
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTestCaseEditionDto withTestCaseVersion(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "testCaseVersion");
    if (this.testCaseVersion.equals(newValue)) return this;
    return new ImmutableTestCaseEditionDto(this.testCaseId, newValue, this.editionStartDate, this.editionUser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TestCaseEditionDto#editionStartDate() editionStartDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for editionStartDate
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTestCaseEditionDto withEditionStartDate(Instant value) {
    if (this.editionStartDate == value) return this;
    Instant newValue = Objects.requireNonNull(value, "editionStartDate");
    return new ImmutableTestCaseEditionDto(this.testCaseId, this.testCaseVersion, newValue, this.editionUser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TestCaseEditionDto#editionUser() editionUser} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for editionUser
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableTestCaseEditionDto withEditionUser(String value) {
    String newValue = Objects.requireNonNull(value, "editionUser");
    if (this.editionUser.equals(newValue)) return this;
    return new ImmutableTestCaseEditionDto(this.testCaseId, this.testCaseVersion, this.editionStartDate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTestCaseEditionDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTestCaseEditionDto
        && equalsByValue((ImmutableTestCaseEditionDto) another);
  }

  private boolean equalsByValue(ImmutableTestCaseEditionDto another) {
    return testCaseId.equals(another.testCaseId)
        && testCaseVersion.equals(another.testCaseVersion)
        && editionStartDate.equals(another.editionStartDate)
        && editionUser.equals(another.editionUser);
  }

  /**
   * Computes a hash code from attributes: {@code testCaseId}, {@code testCaseVersion}, {@code editionStartDate}, {@code editionUser}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + testCaseId.hashCode();
    h += (h << 5) + testCaseVersion.hashCode();
    h += (h << 5) + editionStartDate.hashCode();
    h += (h << 5) + editionUser.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TestCaseEditionDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TestCaseEditionDto{"
        + "testCaseId=" + testCaseId
        + ", testCaseVersion=" + testCaseVersion
        + ", editionStartDate=" + editionStartDate
        + ", editionUser=" + editionUser
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TestCaseEditionDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements TestCaseEditionDto {
    @JsonIgnore @Nullable String testCaseId;
    @JsonIgnore @Nullable Integer testCaseVersion;
    @JsonIgnore @Nullable Instant editionStartDate;
    @JsonIgnore @Nullable String editionUser;

    @JsonProperty(value = "testCaseId", required = true)
    public void setTestCaseId(String testCaseId) {
      this.testCaseId = testCaseId;
    }

    @JsonProperty(value = "testCaseVersion", required = true)
    public void setTestCaseVersion(Integer testCaseVersion) {
      this.testCaseVersion = testCaseVersion;
    }

    @JsonProperty(value = "editionStartDate", required = true)
    public void setEditionStartDate(Instant editionStartDate) {
      this.editionStartDate = editionStartDate;
    }

    @JsonProperty(value = "editionUser", required = true)
    public void setEditionUser(String editionUser) {
      this.editionUser = editionUser;
    }

    @Override
    public String testCaseId() { throw new UnsupportedOperationException(); }

    @Override
    public Integer testCaseVersion() { throw new UnsupportedOperationException(); }

    @Override
    public Instant editionStartDate() { throw new UnsupportedOperationException(); }

    @Override
    public String editionUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableTestCaseEditionDto fromJson(Json json) {
    ImmutableTestCaseEditionDto.Builder builder = ImmutableTestCaseEditionDto.builder();
    if (json.testCaseId != null) {
      builder.testCaseId(json.testCaseId);
    }
    if (json.testCaseVersion != null) {
      builder.testCaseVersion(json.testCaseVersion);
    }
    if (json.editionStartDate != null) {
      builder.editionStartDate(json.editionStartDate);
    }
    if (json.editionUser != null) {
      builder.editionUser(json.editionUser);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TestCaseEditionDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TestCaseEditionDto instance
   */
  public static ImmutableTestCaseEditionDto copyOf(TestCaseEditionDto instance) {
    if (instance instanceof ImmutableTestCaseEditionDto) {
      return (ImmutableTestCaseEditionDto) instance;
    }
    return ImmutableTestCaseEditionDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTestCaseEditionDto ImmutableTestCaseEditionDto}.
   * <pre>
   * ImmutableTestCaseEditionDto.builder()
   *    .testCaseId(String) // required {@link TestCaseEditionDto#testCaseId() testCaseId}
   *    .testCaseVersion(Integer) // required {@link TestCaseEditionDto#testCaseVersion() testCaseVersion}
   *    .editionStartDate(java.time.Instant) // required {@link TestCaseEditionDto#editionStartDate() editionStartDate}
   *    .editionUser(String) // required {@link TestCaseEditionDto#editionUser() editionUser}
   *    .build();
   * </pre>
   * @return A new ImmutableTestCaseEditionDto builder
   */
  public static ImmutableTestCaseEditionDto.Builder builder() {
    return new ImmutableTestCaseEditionDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTestCaseEditionDto ImmutableTestCaseEditionDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TestCaseEditionDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEST_CASE_ID = 0x1L;
    private static final long INIT_BIT_TEST_CASE_VERSION = 0x2L;
    private static final long INIT_BIT_EDITION_START_DATE = 0x4L;
    private static final long INIT_BIT_EDITION_USER = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String testCaseId;
    private @Nullable Integer testCaseVersion;
    private @Nullable Instant editionStartDate;
    private @Nullable String editionUser;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TestCaseEditionDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TestCaseEditionDto instance) {
      Objects.requireNonNull(instance, "instance");
      this.testCaseId(instance.testCaseId());
      this.testCaseVersion(instance.testCaseVersion());
      this.editionStartDate(instance.editionStartDate());
      this.editionUser(instance.editionUser());
      return this;
    }

    /**
     * Initializes the value for the {@link TestCaseEditionDto#testCaseId() testCaseId} attribute.
     * @param testCaseId The value for testCaseId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "testCaseId", required = true)
    public final Builder testCaseId(String testCaseId) {
      this.testCaseId = Objects.requireNonNull(testCaseId, "testCaseId");
      initBits &= ~INIT_BIT_TEST_CASE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TestCaseEditionDto#testCaseVersion() testCaseVersion} attribute.
     * @param testCaseVersion The value for testCaseVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "testCaseVersion", required = true)
    public final Builder testCaseVersion(Integer testCaseVersion) {
      this.testCaseVersion = Objects.requireNonNull(testCaseVersion, "testCaseVersion");
      initBits &= ~INIT_BIT_TEST_CASE_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link TestCaseEditionDto#editionStartDate() editionStartDate} attribute.
     * @param editionStartDate The value for editionStartDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "editionStartDate", required = true)
    public final Builder editionStartDate(Instant editionStartDate) {
      this.editionStartDate = Objects.requireNonNull(editionStartDate, "editionStartDate");
      initBits &= ~INIT_BIT_EDITION_START_DATE;
      return this;
    }

    /**
     * Initializes the value for the {@link TestCaseEditionDto#editionUser() editionUser} attribute.
     * @param editionUser The value for editionUser 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "editionUser", required = true)
    public final Builder editionUser(String editionUser) {
      this.editionUser = Objects.requireNonNull(editionUser, "editionUser");
      initBits &= ~INIT_BIT_EDITION_USER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTestCaseEditionDto ImmutableTestCaseEditionDto}.
     * @return An immutable instance of TestCaseEditionDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTestCaseEditionDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTestCaseEditionDto(testCaseId, testCaseVersion, editionStartDate, editionUser);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEST_CASE_ID) != 0) attributes.add("testCaseId");
      if ((initBits & INIT_BIT_TEST_CASE_VERSION) != 0) attributes.add("testCaseVersion");
      if ((initBits & INIT_BIT_EDITION_START_DATE) != 0) attributes.add("editionStartDate");
      if ((initBits & INIT_BIT_EDITION_USER) != 0) attributes.add("editionUser");
      return "Cannot build TestCaseEditionDto, some of required attributes are not set " + attributes;
    }
  }
}
