
package fr.enedis.chutney.agent.domain.network;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import fr.enedis.chutney.agent.domain.configure.NetworkConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NetworkDescription}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNetworkDescription.builder()}.
 */
@Generated(from = "NetworkDescription", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNetworkDescription
    implements NetworkDescription {
  private final NetworkConfiguration configuration;
  private final AgentGraph agentGraph;
  private final @Nullable Agent localAgent;

  private ImmutableNetworkDescription(
      NetworkConfiguration configuration,
      AgentGraph agentGraph,
      @Nullable Agent localAgent) {
    this.configuration = configuration;
    this.agentGraph = agentGraph;
    this.localAgent = localAgent;
  }

  /**
   * @return The value of the {@code configuration} attribute
   */
  @Override
  public NetworkConfiguration configuration() {
    return configuration;
  }

  /**
   * @return The value of the {@code agentGraph} attribute
   */
  @Override
  public AgentGraph agentGraph() {
    return agentGraph;
  }

  /**
   * @return The value of the {@code localAgent} attribute
   */
  @Override
  public Optional<Agent> localAgent() {
    return Optional.ofNullable(localAgent);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkDescription#configuration() configuration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for configuration
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableNetworkDescription withConfiguration(NetworkConfiguration value) {
    if (this.configuration == value) return this;
    NetworkConfiguration newValue = Objects.requireNonNull(value, "configuration");
    return new ImmutableNetworkDescription(newValue, this.agentGraph, this.localAgent);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkDescription#agentGraph() agentGraph} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for agentGraph
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableNetworkDescription withAgentGraph(AgentGraph value) {
    if (this.agentGraph == value) return this;
    AgentGraph newValue = Objects.requireNonNull(value, "agentGraph");
    return new ImmutableNetworkDescription(this.configuration, newValue, this.localAgent);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link NetworkDescription#localAgent() localAgent} attribute.
   * @param value The value for localAgent
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableNetworkDescription withLocalAgent(Agent value) {
    Agent newValue = Objects.requireNonNull(value, "localAgent");
    if (Objects.equals(this.localAgent, newValue)) return this;
    return new ImmutableNetworkDescription(this.configuration, this.agentGraph, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkDescription#localAgent() localAgent} attribute.
   * A shallow reference equality check on the inner value is used to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for localAgent
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableNetworkDescription withLocalAgent(Optional<? extends Agent> optional) {
    @Nullable Agent value = optional.orElse(null);
    if (Objects.equals(this.localAgent, value)) return this;
    return new ImmutableNetworkDescription(this.configuration, this.agentGraph, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNetworkDescription} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNetworkDescription
        && equalsByValue((ImmutableNetworkDescription) another);
  }

  private boolean equalsByValue(ImmutableNetworkDescription another) {
    return configuration.equals(another.configuration)
        && agentGraph.equals(another.agentGraph)
        && Objects.equals(localAgent, another.localAgent);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}, {@code agentGraph}, {@code localAgent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + configuration.hashCode();
    h += (h << 5) + agentGraph.hashCode();
    h += (h << 5) + Objects.hashCode(localAgent);
    return h;
  }

  /**
   * Prints the immutable value {@code NetworkDescription} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NetworkDescription")
        .omitNullValues()
        .add("configuration", configuration)
        .add("agentGraph", agentGraph)
        .add("localAgent", localAgent)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NetworkDescription} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NetworkDescription instance
   */
  public static ImmutableNetworkDescription copyOf(NetworkDescription instance) {
    if (instance instanceof ImmutableNetworkDescription) {
      return (ImmutableNetworkDescription) instance;
    }
    return ImmutableNetworkDescription.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNetworkDescription ImmutableNetworkDescription}.
   * <pre>
   * ImmutableNetworkDescription.builder()
   *    .configuration(fr.enedis.chutney.agent.domain.configure.NetworkConfiguration) // required {@link NetworkDescription#configuration() configuration}
   *    .agentGraph(fr.enedis.chutney.agent.domain.network.AgentGraph) // required {@link NetworkDescription#agentGraph() agentGraph}
   *    .localAgent(Optional&lt;fr.enedis.chutney.agent.domain.network.Agent&gt;) // optional {@link NetworkDescription#localAgent() localAgent}
   *    .build();
   * </pre>
   * @return A new ImmutableNetworkDescription builder
   */
  public static ImmutableNetworkDescription.Builder builder() {
    return new ImmutableNetworkDescription.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNetworkDescription ImmutableNetworkDescription}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NetworkDescription", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_AGENT_GRAPH = 0x2L;
    private long initBits = 0x3L;

    private @Nullable NetworkConfiguration configuration;
    private @Nullable AgentGraph agentGraph;
    private @Nullable Agent localAgent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NetworkDescription} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NetworkDescription instance) {
      Objects.requireNonNull(instance, "instance");
      this.configuration(instance.configuration());
      this.agentGraph(instance.agentGraph());
      Optional<Agent> localAgentOptional = instance.localAgent();
      if (localAgentOptional.isPresent()) {
        localAgent(localAgentOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkDescription#configuration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder configuration(NetworkConfiguration configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkDescription#agentGraph() agentGraph} attribute.
     * @param agentGraph The value for agentGraph 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder agentGraph(AgentGraph agentGraph) {
      this.agentGraph = Objects.requireNonNull(agentGraph, "agentGraph");
      initBits &= ~INIT_BIT_AGENT_GRAPH;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkDescription#localAgent() localAgent} to localAgent.
     * @param localAgent The value for localAgent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder localAgent(Agent localAgent) {
      this.localAgent = Objects.requireNonNull(localAgent, "localAgent");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkDescription#localAgent() localAgent} to localAgent.
     * @param localAgent The value for localAgent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder localAgent(Optional<? extends Agent> localAgent) {
      this.localAgent = localAgent.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNetworkDescription ImmutableNetworkDescription}.
     * @return An immutable instance of NetworkDescription
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNetworkDescription build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNetworkDescription(configuration, agentGraph, localAgent);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      if ((initBits & INIT_BIT_AGENT_GRAPH) != 0) attributes.add("agentGraph");
      return "Cannot build NetworkDescription, some of required attributes are not set " + attributes;
    }
  }
}
