/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.tools;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TakeWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private final boolean inclusive;
    private boolean conditionHeldSoFar = true;

    static <T> TakeWhileSpliterator<T> over(Spliterator<T> source, Predicate<T> condition) {
        return new TakeWhileSpliterator<T>(source, condition, false);
    }

    static <T> TakeWhileSpliterator<T> overInclusive(Spliterator<T> source, Predicate<T> condition) {
        return new TakeWhileSpliterator<T>(source, condition, true);
    }

    private TakeWhileSpliterator(Spliterator<T> source, Predicate<T> condition, boolean inclusive) {
        this.source = source;
        this.condition = condition;
        this.inclusive = inclusive;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.conditionHeldSoFar && this.source.tryAdvance(e -> {
            if (this.condition.test(e)) {
                action.accept(e);
            } else {
                if (this.inclusive && this.conditionHeldSoFar) {
                    action.accept(e);
                }
                this.conditionHeldSoFar = false;
            }
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.conditionHeldSoFar ? this.source.estimateSize() : 0L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

