/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.tools;

import fr.enedis.chutney.tools.UncheckedException;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R, E extends Exception> Function<T, R> toUnchecked(ThrowingFunction<T, R, E> throwingFunction) throws UncheckedException {
        return ThrowingFunction.silence(throwingFunction, e -> {
            throw UncheckedException.throwUncheckedException(e);
        });
    }

    public static <T, R, E extends Exception> Function<T, R> silence(ThrowingFunction<T, R, E> throwingFunction, Function<Exception, R> exceptionHandler) {
        return t -> {
            try {
                return throwingFunction.apply(t);
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }
}

