/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.tools.loader;

import com.google.common.io.CharStreams;
import fr.enedis.chutney.tools.ThrowingFunction;
import fr.enedis.chutney.tools.loader.ExtensionLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ExtensionLoaders {
    private ExtensionLoaders() {
    }

    public static ExtensionLoader<Class<?>> classpathToClass(String path) {
        return ExtensionLoader.Builder.withSource(Sources.classpath(path)).withMapper(Mappers.splitByLine().andThen(Mappers.instantiate()));
    }

    public static abstract class Sources {
        private Sources() {
        }

        public static ExtensionLoader.ExtensionLoaderSource<String> classpath(String path) {
            return () -> {
                try {
                    HashSet<String> sources = new HashSet<String>();
                    for (URL url : Collections.list(ExtensionLoaders.class.getClassLoader().getResources(path))) {
                        InputStream is = url.openStream();
                        try {
                            sources.add(CharStreams.toString((Readable)new InputStreamReader(is)));
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    return sources;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }
    }

    public static abstract class Mappers {
        private Mappers() {
        }

        public static Function<String, Set<String>> splitByLine() {
            return Mappers.splitByLineIgnoring("#");
        }

        public static Function<String, Set<String>> splitByLineIgnoring(String commentMarker) {
            return document -> Arrays.stream(document.split("\\r?\\n")).filter(line -> !line.trim().startsWith(commentMarker) && !line.trim().isEmpty()).collect(Collectors.toSet());
        }

        public static Function<Set<String>, Set<Class<?>>> instantiate() {
            return classnames -> classnames.stream().map(ThrowingFunction.toUnchecked(Class::forName)).collect(Collectors.toSet());
        }
    }
}

