/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.tools;

import fr.enedis.chutney.tools.SkipUntilSpliterator;
import fr.enedis.chutney.tools.TakeWhileSpliterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class Streams {
    private Streams() {
    }

    public static <T> Function<T, T> identity(Consumer<T> action) {
        return t -> {
            action.accept(t);
            return t;
        };
    }

    public static <T> Collector<T, Object, Optional<T>> collectUniqueResult() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                throw new IllegalArgumentException("Found " + list.size() + " result");
            }
            if (list.size() == 1) {
                return Optional.of(list.getFirst());
            }
            return Optional.empty();
        });
    }

    public static <T> Stream<T> toStream(final Enumeration<T> enumeration) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }
        }, 16), false);
    }

    public static <T> Optional<T> findLast(Stream<T> source, Predicate<T> condition) {
        return source.filter(condition).reduce((first, second) -> second);
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(TakeWhileSpliterator.over(source.spliterator(), condition), false).onClose(source::close);
    }

    public static <T> Stream<T> takeUntil(Stream<T> source, Predicate<T> condition) {
        return Streams.takeWhile(source, condition.negate());
    }

    public static <T> Stream<T> skipUntil(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition), false).onClose(source::close);
    }
}

