/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.tools.loader;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface ExtensionLoader<EXTENSION> {
    public Set<EXTENSION> load();

    public static class Builder<SOURCE, EXTENSION> {
        private final ExtensionLoaderSource<SOURCE> source;
        private Function<SOURCE, Set<EXTENSION>> mappingFunction;

        private Builder(ExtensionLoaderSource<SOURCE> source) {
            this.source = source;
        }

        public static <SOURCE, EXTENSION> Builder<SOURCE, EXTENSION> withSource(ExtensionLoaderSource<SOURCE> source) {
            return new Builder<SOURCE, EXTENSION>(source);
        }

        public ExtensionLoader<EXTENSION> withMapper(Function<SOURCE, Set<EXTENSION>> mappingFunction) {
            this.mappingFunction = mappingFunction;
            return this.build();
        }

        private ExtensionLoader<EXTENSION> build() {
            return () -> this.source.load().stream().flatMap(this.mappingFunction.andThen(Collection::stream)).collect(Collectors.toSet());
        }
    }

    public static interface ExtensionLoaderSource<SOURCE> {
        public Set<SOURCE> load();
    }
}

