ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(b,M,W){"use strict";var $=b("./lib/dom"),x=b("./lib/oop"),y=b("./lib/event_emitter").EventEmitter,g=b("./lib/lang"),m=b("./range").Range,v=b("./range_list").RangeList,T=b("./keyboard/hash_handler").HashHandler,k=b("./tokenizer").Tokenizer,_=b("./clipboard"),I={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,n,i){var t=e.session.getTextRange();return i?t.replace(/\n\r?([ \t]*\S)/g,"\n"+i+"$1"):t},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return _.getText&&_.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var n=e.session.$mode||{};return n.blockComment&&n.blockComment.start||""},BLOCK_COMMENT_END:function(e){var n=e.session.$mode||{};return n.blockComment&&n.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:R.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:R.bind(null,{year:"2-digit"}),CURRENT_MONTH:R.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:R.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:R.bind(null,{month:"short"}),CURRENT_DATE:R.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:R.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:R.bind(null,{weekday:"short"}),CURRENT_HOUR:R.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:R.bind(null,{minute:"2-digit"}),CURRENT_SECOND:R.bind(null,{second:"2-digit"})};function R(e){var n=(new Date).toLocaleString("en-us",e);return 1==n.length?"0"+n:n}I.SELECTED_TEXT=I.SELECTION;var N=function(){function e(){this.snippetMap={},this.snippetNameMap={},this.variables=I}return e.prototype.getTokenizer=function(){return e.$tokenizer||this.createTokenizer()},e.prototype.createTokenizer=function(){function n(o){return o=o.substr(1),/^\d+$/.test(o)?[{tabstopId:parseInt(o,10)}]:[{text:o}]}function i(o){return"(?:[^\\\\"+o+"]|\\\\.)"}var t={regex:"/("+i("/")+"+)/",onMatch:function(o,p,l){var a=l[0];return a.fmtString=!0,a.guard=o.slice(1,-1),a.flag="",""},next:"formatString"};return e.$tokenizer=new k({start:[{regex:/\\./,onMatch:function(o,p,l){var a=o[1];return("}"==a&&l.length||-1!="`$\\".indexOf(a))&&(o=a),[o]}},{regex:/}/,onMatch:function(o,p,l){return[l.length?l.shift():o]}},{regex:/\$(?:\d+|\w+)/,onMatch:n},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(o,p,l){var a=n(o.substr(1));return l.unshift(a[0]),a},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+i("\\|")+"*\\|",onMatch:function(o,p,l){var a=o.slice(1,-1).replace(/\\[,|\\]|,/g,function(c){return 2==c.length?c[1]:"\0"}).split("\0").map(function(c){return{value:c}});return l[0].choices=a,[a[0]]},next:"start"},t,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(o,p,l){return l.length&&l[0].expectElse?(l[0].expectElse=!1,l[0].ifEnd={elseEnd:l[0]},[l[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(o,p,l){var a=o[1];return"}"==a&&l.length||-1!="`$\\".indexOf(a)?o=a:"n"==a?o="\n":"t"==a?o="\t":-1!="ulULE".indexOf(a)&&(o={changeCase:a,local:a>"a"}),[o]}},{regex:"/\\w*}",onMatch:function(o,p,l){var a=l.shift();return a&&(a.flag=o.slice(1,-1)),this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(o,p,l){return[{text:o.slice(1)}]}},{regex:/\${\w+/,onMatch:function(o,p,l){var a={text:o.slice(2)};return l.unshift(a),[a]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(o,p,l){var a=l.shift();return this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(o,p,l){return l[0].formatFunction=o.slice(2,-1),[l.shift()]},next:"formatString"},t,{regex:/:[\?\-+]?/,onMatch:function(o,p,l){"+"==o[1]&&(l[0].ifEnd=l[0]),"?"==o[1]&&(l[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},e.prototype.tokenizeTmSnippet=function(n,i){return this.getTokenizer().getLineTokens(n,i).tokens.map(function(t){return t.value||t})},e.prototype.getVariableValue=function(n,i,t){if(/^\d+$/.test(i))return(this.variables.__||{})[i]||"";if(/^[A-Z]\d+$/.test(i))return(this.variables[i[0]+"__"]||{})[i.substr(1)]||"";if(i=i.replace(/^TM_/,""),!this.variables.hasOwnProperty(i))return"";var o=this.variables[i];return"function"==typeof o&&(o=this.variables[i](n,i,t)),o??""},e.prototype.tmStrFormat=function(n,i,t){if(!i.fmt)return n;var p=i.guard;p=new RegExp(p,(i.flag||"").replace(/[^gim]/g,""));var l="string"==typeof i.fmt?this.tokenizeTmSnippet(i.fmt,"formatString"):i.fmt,a=this,c=n.replace(p,function(){var s=a.variables.__;a.variables.__=[].slice.call(arguments);for(var f=a.resolveVariables(l,t),d="E",h=0;h<f.length;h++){var w=f[h];if("object"==typeof w)if(f[h]="",w.changeCase&&w.local){var S=f[h+1];S&&"string"==typeof S&&(f[h]="u"==w.changeCase?S[0].toUpperCase():S[0].toLowerCase(),f[h+1]=S.substr(1))}else w.changeCase&&(d=w.changeCase);else"U"==d?f[h]=w.toUpperCase():"L"==d&&(f[h]=w.toLowerCase())}return a.variables.__=s,f.join("")});return c},e.prototype.tmFormatFunction=function(n,i,t){return"upcase"==i.formatFunction?n.toUpperCase():"downcase"==i.formatFunction?n.toLowerCase():n},e.prototype.resolveVariables=function(n,i){for(var t=[],o="",p=!0,l=0;l<n.length;l++){var a=n[l];if("string"!=typeof a){if(a){if(p=!1,a.fmtString){var c=n.indexOf(a,l+1);-1==c&&(c=n.length),a.fmt=n.slice(l+1,c),l=c}if(a.text){var s=this.getVariableValue(i,a.text,o)+"";a.fmtString&&(s=this.tmStrFormat(s,a,i)),a.formatFunction&&(s=this.tmFormatFunction(s,a,i)),s&&!a.ifEnd?(t.push(s),f(a)):!s&&a.ifEnd&&f(a.ifEnd)}else a.elseEnd?f(a.elseEnd):(null!=a.tabstopId||null!=a.changeCase)&&t.push(a)}}else t.push(a),"\n"==a?(p=!0,o=""):p&&(o=/^\t*/.exec(a)[0],p=/\S/.test(a))}function f(d){var h=n.indexOf(d,l+1);-1!=h&&(l=h)}return t},e.prototype.getDisplayTextForSnippet=function(n,i){return E.call(this,n,i).text},e.prototype.insertSnippetForSelection=function(n,i,t){void 0===t&&(t={});var o=E.call(this,n,i,t),p=n.getSelectionRange(),l=n.session.replace(p,o.text);new P(n).addTabstops(o.tabstops,p.start,l,n.inVirtualSelectionMode&&n.selection.index)},e.prototype.insertSnippet=function(n,i,t){void 0===t&&(t={});var o=this;if(n.inVirtualSelectionMode)return o.insertSnippetForSelection(n,i,t);n.forEachSelection(function(){o.insertSnippetForSelection(n,i,t)},null,{keepOrder:!0}),n.tabstopManager&&n.tabstopManager.tabNext()},e.prototype.$getScope=function(n){var i=n.session.$mode.$id||"";if("html"===(i=i.split("/").pop())||"php"===i){"php"===i&&!n.session.$mode.inlinePhp&&(i="html");var t=n.getCursorPosition(),o=n.session.getState(t.row);"object"==typeof o&&(o=o[0]),o.substring&&("js-"==o.substring(0,3)?i="javascript":"css-"==o.substring(0,4)?i="css":"php-"==o.substring(0,4)&&(i="php"))}return i},e.prototype.getActiveScopes=function(n){var i=this.$getScope(n),t=[i],o=this.snippetMap;return o[i]&&o[i].includeScopes&&t.push.apply(t,o[i].includeScopes),t.push("_"),t},e.prototype.expandWithTab=function(n,i){var t=this,o=n.forEachSelection(function(){return t.expandSnippetForSelection(n,i)},null,{keepOrder:!0});return o&&n.tabstopManager&&n.tabstopManager.tabNext(),o},e.prototype.expandSnippetForSelection=function(n,i){var c,t=n.getCursorPosition(),o=n.session.getLine(t.row),p=o.substring(0,t.column),l=o.substr(t.column),a=this.snippetMap;return this.getActiveScopes(n).some(function(s){var f=a[s];return f&&(c=this.findMatchingSnippet(f,p,l)),!!c},this),!!c&&(i&&i.dryRun||(n.session.doc.removeInLine(t.row,t.column-c.replaceBefore.length,t.column+c.replaceAfter.length),this.variables.M__=c.matchBefore,this.variables.T__=c.matchAfter,this.insertSnippetForSelection(n,c.content),this.variables.M__=this.variables.T__=null),!0)},e.prototype.findMatchingSnippet=function(n,i,t){for(var o=n.length;o--;){var p=n[o];if((!p.startRe||p.startRe.test(i))&&(!p.endRe||p.endRe.test(t))&&(p.startRe||p.endRe))return p.matchBefore=p.startRe?p.startRe.exec(i):[""],p.matchAfter=p.endRe?p.endRe.exec(t):[""],p.replaceBefore=p.triggerRe?p.triggerRe.exec(i)[0]:"",p.replaceAfter=p.endTriggerRe?p.endTriggerRe.exec(t)[0]:"",p}},e.prototype.register=function(n,i){var t=this.snippetMap,o=this.snippetNameMap,p=this;function l(s){return s&&!/^\^?\(.*\)\$?$|^\\b$/.test(s)&&(s="(?:"+s+")"),s||""}function a(s,f,d){return s=l(s),f=l(f),d?(s=f+s)&&"$"!=s[s.length-1]&&(s+="$"):(s+=f)&&"^"!=s[0]&&(s="^"+s),new RegExp(s)}function c(s){s.scope||(s.scope=i||"_"),t[i=s.scope]||(t[i]=[],o[i]={});var f=o[i];if(s.name){var d=f[s.name];d&&p.unregister(d),f[s.name]=s}t[i].push(s),s.prefix&&(s.tabTrigger=s.prefix),!s.content&&s.body&&(s.content=Array.isArray(s.body)?s.body.join("\n"):s.body),s.tabTrigger&&!s.trigger&&(!s.guard&&/^\w/.test(s.tabTrigger)&&(s.guard="\\b"),s.trigger=g.escapeRegExp(s.tabTrigger)),(s.trigger||s.guard||s.endTrigger||s.endGuard)&&(s.startRe=a(s.trigger,s.guard,!0),s.triggerRe=new RegExp(s.trigger),s.endRe=a(s.endTrigger,s.endGuard,!0),s.endTriggerRe=new RegExp(s.endTrigger))}n||(n=[]),Array.isArray(n)?n.forEach(c):Object.keys(n).forEach(function(s){c(n[s])}),this._signal("registerSnippets",{scope:i})},e.prototype.unregister=function(n,i){var t=this.snippetMap,o=this.snippetNameMap;function p(l){var a=o[l.scope||i];if(a&&a[l.name]){delete a[l.name];var c=t[l.scope||i],s=c&&c.indexOf(l);s>=0&&c.splice(s,1)}}n.content?p(n):Array.isArray(n)&&n.forEach(p)},e.prototype.parseSnippetFile=function(n){n=n.replace(/\r/g,"");for(var p,i=[],t={},o=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;p=o.exec(n);){if(p[1])try{t=JSON.parse(p[1]),i.push(t)}catch{}if(p[4])t.content=p[4].replace(/^\t/gm,""),i.push(t),t={};else{var l=p[2],a=p[3];if("regex"==l){var c=/\/((?:[^\/\\]|\\.)*)|$/g;t.guard=c.exec(a)[1],t.trigger=c.exec(a)[1],t.endTrigger=c.exec(a)[1],t.endGuard=c.exec(a)[1]}else"snippet"==l?(t.tabTrigger=a.match(/^\S*/)[0],t.name||(t.name=a)):l&&(t[l]=a)}}return i},e.prototype.getSnippetByName=function(n,i){var o,t=this.snippetNameMap;return this.getActiveScopes(i).some(function(p){var l=t[p];return l&&(o=l[n]),!!o},this),o},e}();x.implement(N.prototype,y);var E=function(e,n,i){void 0===i&&(i={});var t=e.getCursorPosition(),o=e.session.getLine(t.row),p=e.session.getTabString(),l=o.match(/^\s*/)[0];t.column<l.length&&(l=l.slice(0,t.column)),n=n.replace(/\r/g,"");var a=this.tokenizeTmSnippet(n);a=(a=this.resolveVariables(a,e)).map(function(C){return"\n"!=C||i.excludeExtraIndent?"string"==typeof C?C.replace(/\t/g,p):C:C+l});var c=[];a.forEach(function(C,D){if("object"==typeof C){var B=C.tabstopId,O=c[B];if(O||((O=c[B]=[]).index=B,O.value="",O.parents={}),-1===O.indexOf(C)){C.choices&&!O.choices&&(O.choices=C.choices),O.push(C);var V=a.indexOf(C,D+1);if(-1!==V){var G=a.slice(D+1,V);G.some(function(K){return"object"==typeof K})&&!O.value?O.value=G:G.length&&(!O.value||"string"!=typeof O.value)&&(O.value=G.join(""))}}}}),c.forEach(function(C){C.length=0});var s={};function f(C){for(var D=[],B=0;B<C.length;B++){var O=C[B];if("object"==typeof O){if(s[O.tabstopId])continue;O=D[C.lastIndexOf(O,B-1)]||{tabstopId:O.tabstopId}}D[B]=O}return D}for(var d=0;d<a.length;d++){var h=a[d];if("object"==typeof h){var w=h.tabstopId,S=c[w],L=a.indexOf(h,d+1);if(s[w]){s[w]===h&&(delete s[w],Object.keys(s).forEach(function(C){S.parents[C]=!0}));continue}s[w]=h;var H=S.value;"string"!=typeof H?H=f(H):h.fmt&&(H=this.tmStrFormat(H,h,e)),a.splice.apply(a,[d+1,Math.max(0,L-d)].concat(H,h)),-1===S.indexOf(h)&&S.push(h)}}var z=0,F=0,U="";return a.forEach(function(C){if("string"==typeof C){var D=C.split("\n");D.length>1?(F=D[D.length-1].length,z+=D.length-1):F+=C.length,U+=C}else C&&(C.start?C.end={row:z,column:F}:C.start={row:z,column:F})}),{text:U,tabstops:c,tokens:a}},P=function(){function e(n){if(this.index=0,this.ranges=[],this.tabstops=[],n.tabstopManager)return n.tabstopManager;n.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=g.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(n)}return e.prototype.attach=function(n){this.$openTabstops=null,this.selectedTabstop=null,this.editor=n,this.session=n.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},e.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},e.prototype.onChange=function(n){for(var i="r"==n.action[0],t=this.selectedTabstop||{},o=t.parents||{},p=this.tabstops.slice(),l=0;l<p.length;l++){var a=p[l];if(a.rangeList.$bias=a==t||o[a.index]?0:1,"remove"==n.action&&a!==t){var s=a.parents&&a.parents[t.index],f=a.rangeList.pointIndex(n.start,s);f=f<0?-f-1:f+1;for(var d=a.rangeList.pointIndex(n.end,s),h=a.rangeList.ranges.slice(f,d=d<0?-d-1:d-1),w=0;w<h.length;w++)this.removeRange(h[w])}a.rangeList.$onChange(n)}var S=this.session;!this.$inChange&&i&&1==S.getLength()&&!S.getValue()&&this.detach()},e.prototype.updateLinkedFields=function(){var n=this.selectedTabstop;if(n&&n.hasLinkedRanges&&n.firstNonLinked){this.$inChange=!0;for(var i=this.session,t=i.getTextRange(n.firstNonLinked),o=0;o<n.length;o++){var p=n[o];if(p.linked){var a=M.snippetManager.tmStrFormat(t,p.original,this.editor);i.replace(p,a)}}this.$inChange=!1}},e.prototype.onAfterExec=function(n){n.command&&!n.command.readOnly&&this.updateLinkedFields()},e.prototype.onChangeSelection=function(){if(this.editor){for(var n=this.editor.selection.lead,i=this.editor.selection.anchor,t=this.editor.selection.isEmpty(),o=0;o<this.ranges.length;o++)if(!this.ranges[o].linked){var p=this.ranges[o].contains(n.row,n.column),l=t||this.ranges[o].contains(i.row,i.column);if(p&&l)return}this.detach()}},e.prototype.onChangeSession=function(){this.detach()},e.prototype.tabNext=function(n){var i=this.tabstops.length,t=this.index+(n||1);(t=Math.min(Math.max(t,1),i))==i&&(t=0),this.selectTabstop(t),this.updateTabstopMarkers(),0===t&&this.detach()},e.prototype.selectTabstop=function(n){this.$openTabstops=null;var i=this.tabstops[this.index];if(i&&this.addTabstopMarkers(i),this.index=n,(i=this.tabstops[this.index])&&i.length){this.selectedTabstop=i;var t=i.firstNonLinked||i;if(i.choices&&(t.cursor=t.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(t);else{var o=this.editor.multiSelect;o.toSingleRange(t);for(var p=0;p<i.length;p++)i.hasLinkedRanges&&i[p].linked||o.addRange(i[p].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},e.prototype.addTabstops=function(n,i,t){var o=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!n[0]){var p=m.fromPoints(t,t);u(p.start,i),u(p.end,i),n[0]=[p],n[0].index=0}var a=[this.index+1,0],c=this.ranges,s=this.snippetId=(this.snippetId||0)+1;n.forEach(function(f,d){var h=this.$openTabstops[d]||f;h.snippetId=s;for(var w=0;w<f.length;w++){var S=f[w],L=m.fromPoints(S.start,S.end||S.start);A(L.start,i),A(L.end,i),L.original=S,L.tabstop=h,c.push(L),h!=f?h.unshift(L):h[w]=L,S.fmtString||h.firstNonLinked&&o?(L.linked=!0,h.hasLinkedRanges=!0):h.firstNonLinked||(h.firstNonLinked=L)}h.firstNonLinked||(h.hasLinkedRanges=!1),h===f&&(a.push(h),this.$openTabstops[d]=h),this.addTabstopMarkers(h),h.rangeList=h.rangeList||new v,h.rangeList.$bias=0,h.rangeList.addList(h)},this),a.length>2&&(this.tabstops.length&&a.push(a.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,a))},e.prototype.addTabstopMarkers=function(n){var i=this.session;n.forEach(function(t){t.markerId||(t.markerId=i.addMarker(t,"ace_snippet-marker","text"))})},e.prototype.removeTabstopMarkers=function(n){var i=this.session;n.forEach(function(t){i.removeMarker(t.markerId),t.markerId=null})},e.prototype.updateTabstopMarkers=function(){if(this.selectedTabstop){var n=this.selectedTabstop.snippetId;0===this.selectedTabstop.index&&n--,this.tabstops.forEach(function(i){i.snippetId===n?this.addTabstopMarkers(i):this.removeTabstopMarkers(i)},this)}},e.prototype.removeRange=function(n){var i=n.tabstop.indexOf(n);-1!=i&&n.tabstop.splice(i,1),-1!=(i=this.ranges.indexOf(n))&&this.ranges.splice(i,1),-1!=(i=n.tabstop.rangeList.ranges.indexOf(n))&&n.tabstop.splice(i,1),this.session.removeMarker(n.markerId),n.tabstop.length||(-1!=(i=this.tabstops.indexOf(n.tabstop))&&this.tabstops.splice(i,1),this.tabstops.length||this.detach())},e}();P.prototype.keyboardHandler=new T,P.prototype.keyboardHandler.bindKeys({Tab:function(e){M.snippetManager&&M.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var A=function(e,n){0==e.row&&(e.column+=n.column),e.row+=n.row},u=function(e,n){e.row==n.row&&(e.column-=n.column),e.row-=n.row};$.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),M.snippetManager=new N;var r=b("./editor").Editor;(function(){this.insertSnippet=function(e,n){return M.snippetManager.insertSnippet(this,e,n)},this.expandSnippet=function(e){return M.snippetManager.expandWithTab(this,e)}}).call(r.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(b,M,W){"use strict";var $=b("../virtual_renderer").VirtualRenderer,x=b("../editor").Editor,y=b("../range").Range,g=b("../lib/event"),m=b("../lib/lang"),v=b("../lib/dom"),T=b("../config").nls,k=b("./../lib/useragent"),_=function(A){return"suggest-aria-id:".concat(A)},I=k.isSafari?"menu":"listbox",R=k.isSafari?"menuitem":"option",N=k.isSafari?"aria-current":"aria-selected",E=function(A){var u=new $(A);u.$maxLines=4;var r=new x(u);return r.setHighlightActiveLine(!1),r.setShowPrintMargin(!1),r.renderer.setShowGutter(!1),r.renderer.setHighlightGutterLine(!1),r.$mouseHandler.$focusTimeout=0,r.$highlightTagPending=!0,r},P=function(){return function A(u){var r=v.createElement("div"),e=E(r);u&&u.appendChild(r),r.style.display="none",e.renderer.content.style.cursor="default",e.renderer.setStyle("ace_autocomplete"),e.renderer.$textLayer.element.setAttribute("role",I),e.renderer.$textLayer.element.setAttribute("aria-roledescription",T("autocomplete.popup.aria-roledescription","Autocomplete suggestions")),e.renderer.$textLayer.element.setAttribute("aria-label",T("autocomplete.popup.aria-label","Autocomplete suggestions")),e.renderer.textarea.setAttribute("aria-hidden","true"),e.setOption("displayIndentGuides",!1),e.setOption("dragDelay",150);var n=function(){};e.focus=n,e.$isFocused=!0,e.renderer.$cursorLayer.restartTimer=n,e.renderer.$cursorLayer.element.style.opacity="0",e.renderer.$maxLines=8,e.renderer.$keepTextAreaAtCursor=!1,e.setHighlightActiveLine(!1),e.session.highlight(""),e.session.$searchHighlight.clazz="ace_highlight-marker",e.on("mousedown",function(c){var s=c.getDocumentPosition();e.selection.moveToPosition(s),o.start.row=o.end.row=s.row,c.stop()});var i,t=new y(-1,0,-1,1/0),o=new y(-1,0,-1,1/0);o.id=e.session.addMarker(o,"ace_active-line","fullLine"),e.setSelectOnHover=function(c){c?t.id&&(e.session.removeMarker(t.id),t.id=null):t.id=e.session.addMarker(t,"ace_line-hover","fullLine")},e.setSelectOnHover(!1),e.on("mousemove",function(c){if(i){if(i.x!=c.x||i.y!=c.y){(i=c).scrollTop=e.renderer.scrollTop,e.isMouseOver=!0;var s=i.getDocumentPosition().row;t.start.row!=s&&(t.id||e.setRow(s),l(s))}}else i=c}),e.renderer.on("beforeRender",function(){if(i&&-1!=t.start.row){i.$pos=null;var c=i.getDocumentPosition().row;t.id||e.setRow(c),l(c,!0)}}),e.renderer.on("afterRender",function(){for(var c=e.renderer.$textLayer,s=c.config.firstRow,f=c.config.lastRow;s<=f;s++){var d=c.element.childNodes[s-c.config.firstRow];d.setAttribute("role",R),d.setAttribute("aria-roledescription",T("autocomplete.popup.item.aria-roledescription","item")),d.setAttribute("aria-setsize",e.data.length),d.setAttribute("aria-describedby","doc-tooltip"),d.setAttribute("aria-posinset",s+1);var h=e.getData(s);if(h){var w="".concat(h.caption||h.value).concat(h.meta?", ".concat(h.meta):"");d.setAttribute("aria-label",w)}d.querySelectorAll(".ace_completion-highlight").forEach(function(L){L.setAttribute("role","mark")})}}),e.renderer.on("afterRender",function(){var c=e.getRow(),s=e.renderer.$textLayer,f=s.element.childNodes[c-s.config.firstRow],d=document.activeElement;if(f!==e.selectedNode&&e.selectedNode&&(v.removeCssClass(e.selectedNode,"ace_selected"),e.selectedNode.removeAttribute(N),e.selectedNode.removeAttribute("id")),d.removeAttribute("aria-activedescendant"),e.selectedNode=f,f){var h=_(c);v.addCssClass(f,"ace_selected"),f.id=h,s.element.setAttribute("aria-activedescendant",h),d.setAttribute("aria-activedescendant",h),f.setAttribute(N,"true")}});var p=function(){l(-1)},l=function(c,s){c!==t.start.row&&(t.start.row=t.end.row=c,s||e.session._emit("changeBackMarker"),e._emit("changeHoverMarker"))};e.getHoveredRow=function(){return t.start.row},g.addListener(e.container,"mouseout",function(){e.isMouseOver=!1,p()}),e.on("hide",p),e.on("changeSelection",p),e.session.doc.getLength=function(){return e.data.length},e.session.doc.getLine=function(c){var s=e.data[c];return"string"==typeof s?s:s&&s.value||""};var a=e.session.bgTokenizer;return a.$tokenizeRow=function(c){var s=e.data[c],f=[];if(!s)return f;"string"==typeof s&&(s={value:s});var d=s.caption||s.value||s.name;function h(C,D){C&&f.push({type:(s.className||"")+(D||""),value:C})}for(var w=d.toLowerCase(),S=(e.filterText||"").toLowerCase(),L=0,H=0,z=0;z<=S.length;z++)if(z!=H&&(s.matchMask&1<<z||z==S.length)){var F=S.slice(H,z);H=z;var U=w.indexOf(F,L);if(-1==U)continue;h(d.slice(L,U),""),h(d.slice(U,L=U+F.length),"completion-highlight")}return h(d.slice(L,d.length),""),f.push({type:"completion-spacer",value:" "}),s.meta&&f.push({type:"completion-meta",value:s.meta}),s.message&&f.push({type:"completion-message",value:s.message}),f},a.$updateOnChange=n,a.start=n,e.session.$computeWidth=function(){return this.screenWidth=0},e.isOpen=!1,e.isTopdown=!1,e.autoSelect=!0,e.filterText="",e.isMouseOver=!1,e.data=[],e.setData=function(c,s){e.filterText=s||"",e.setValue(m.stringRepeat("\n",c.length),-1),e.data=c||[],e.setRow(0)},e.getData=function(c){return e.data[c]},e.getRow=function(){return o.start.row},e.setRow=function(c){c=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,c)),o.start.row!=c&&(e.selection.clearSelection(),o.start.row=o.end.row=c||0,e.session._emit("changeBackMarker"),e.moveCursorTo(c||0,0),e.isOpen&&e._signal("select"))},e.on("changeSelection",function(){e.isOpen&&e.setRow(e.selection.lead.row),e.renderer.scrollCursorIntoView()}),e.hide=function(){this.container.style.display="none",e.anchorPos=null,e.anchor=null,e.isOpen&&(e.isOpen=!1,this._signal("hide"))},e.tryShow=function(c,s,f,d){if(!d&&e.isOpen&&e.anchorPos&&e.anchor&&e.anchorPos.top===c.top&&e.anchorPos.left===c.left&&e.anchor===f)return!0;var h=this.container,w=this.renderer.scrollBar.width||10,S=window.innerHeight-w,L=window.innerWidth-w,H=this.renderer,z=H.$maxLines*s*1.4,F={top:0,bottom:0,left:0},U=S-c.top-3*this.$borderSize-s,C=c.top-3*this.$borderSize;f||(f=C<=U||U>=z?"bottom":"top"),"top"===f?(F.bottom=c.top-this.$borderSize,F.top=F.bottom-z):"bottom"===f&&(F.top=c.top+s+this.$borderSize,F.bottom=F.top+z);var D=F.top>=0&&F.bottom<=S;if(!d&&!D)return!1;H.$maxPixelHeight=D?null:"top"===f?C:U,"top"===f?(h.style.top="",h.style.bottom=S+w-F.bottom+"px",e.isTopdown=!1):(h.style.top=F.top+"px",h.style.bottom="",e.isTopdown=!0),h.style.display="";var B=c.left;return B+h.offsetWidth>L&&(B=L-h.offsetWidth),h.style.left=B+"px",h.style.right="",e.isOpen||(e.isOpen=!0,this._signal("show"),i=null),e.anchorPos=c,e.anchor=f,!0},e.show=function(c,s,f){this.tryShow(c,s,f?"bottom":void 0,!0)},e.goTo=function(c){var s=this.getRow(),f=this.session.getLength()-1;switch(c){case"up":s=s<=0?f:s-1;break;case"down":s=s>=f?-1:s+1;break;case"start":s=0;break;case"end":s=f}this.setRow(s)},e.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},e.$imageSize=0,e.$borderSize=1,e}}();v.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),M.AcePopup=P,M.$singleLineEditor=E,M.getAriaId=_}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(b,M,W){"use strict";var $=function(){function x(y){this.editor=y,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return x.prototype.setScreenReaderContent=function(y){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var m=this.popup.getRow(),v=this.popup.renderer.$textLayer,T=v.element.childNodes[m-v.config.firstRow];if(T){for(var k="doc-tooltip ",_=0;_<this._lines.length;_++)k+="ace-inline-screenreader-line-".concat(_," ");T.setAttribute("aria-describedby",k)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=y.split(/\r\n|\r|\n/);var g=this.createCodeBlock();this.screenReaderDiv.appendChild(g)},x.prototype.destroy=function(){this.screenReaderDiv.remove()},x.prototype.createCodeBlock=function(){var y=document.createElement("pre");y.setAttribute("id","ace-inline-screenreader");for(var g=0;g<this._lines.length;g++){var m=document.createElement("code");m.setAttribute("id","ace-inline-screenreader-line-".concat(g));var v=document.createTextNode(this._lines[g]);m.appendChild(v),y.appendChild(m)}return y},x}();M.AceInlineScreenReader=$}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(b,M,W){"use strict";var $=b("../snippets").snippetManager,x=b("./inline_screenreader").AceInlineScreenReader,y=function(){function g(){this.editor=null}return g.prototype.show=function(m,v,T){if(T=T||"",m&&this.editor&&this.editor!==m&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!m||!v)return!1;this.inlineScreenReader||(this.inlineScreenReader=new x(m));var k=v.snippet?$.getDisplayTextForSnippet(m,v.snippet):v.value;return!(v.hideInlinePreview||!k||!k.startsWith(T)||(this.editor=m,this.inlineScreenReader.setScreenReaderContent(k),""===(k=k.slice(T.length))?m.removeGhostText():m.setGhostText(k),0))},g.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},g.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},g.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},g}();M.AceInline=y}),ace.define("ace/autocomplete/util",["require","exports","module"],function(b,M,W){"use strict";M.parForEach=function(x,y,g){var m=0,v=x.length;0===v&&g();for(var T=0;T<v;T++)y(x[T],function(k,_){++m===v&&g(k,_)})};var $=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;M.retrievePrecedingIdentifier=function(x,y,g){g=g||$;for(var m=[],v=y-1;v>=0&&g.test(x[v]);v--)m.push(x[v]);return m.reverse().join("")},M.retrieveFollowingIdentifier=function(x,y,g){g=g||$;for(var m=[],v=y;v<x.length&&g.test(x[v]);v++)m.push(x[v]);return m},M.getCompletionPrefix=function(x){var m,y=x.getCursorPosition(),g=x.session.getLine(y.row);return x.completers.forEach(function(v){v.identifierRegexps&&v.identifierRegexps.forEach(function(T){!m&&T&&(m=this.retrievePrecedingIdentifier(g,y.column,T))}.bind(this))}.bind(this)),m||this.retrievePrecedingIdentifier(g,y.column)},M.triggerAutocomplete=function(x,g){return g=g??x.session.getPrecedingCharacter(),x.completers.some(function(m){if(m.triggerCharacters&&Array.isArray(m.triggerCharacters))return m.triggerCharacters.includes(g)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(b,M,W){"use strict";var $=b("./keyboard/hash_handler").HashHandler,x=b("./autocomplete/popup").AcePopup,y=b("./autocomplete/inline").AceInline,g=b("./autocomplete/popup").getAriaId,m=b("./autocomplete/util"),v=b("./lib/lang"),T=b("./lib/dom"),k=b("./snippets").snippetManager,_=b("./config"),I=b("./lib/event"),R=b("./lib/scroll").preventParentScroll,N=function(u,r){r.completer&&r.completer.destroy()},E=function(){function u(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new $,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.hasSeen=new Set,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=v.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=v.delayedCall(this.updateDocTooltip.bind(this),50),this.popupTimer=v.delayedCall(this.$updatePopupPosition.bind(this),50),this.stickySelectionTimer=v.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=v.delayedCall(function(){var r=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!r||0===this.editor.completers.length||(this.completions=new A(u.completionsForLoading),this.openPopup(this.editor,r.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(u,"completionsForLoading",{get:function(){return[{caption:_.nls("autocomplete.loading","Loading..."),value:""}]},enumerable:!1,configurable:!0}),u.prototype.$init=function(){return this.popup=new x(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(r){this.insertMatch(),r.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),I.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this)),this.popup},u.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new y,this.inlineRenderer},u.prototype.getPopup=function(){return this.popup||this.$init()},u.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.popupTimer.cancel(),this.stickySelection=!1},u.prototype.$seen=function(r){!this.hasSeen.has(r)&&r&&r.completer&&r.completer.onSeen&&"function"==typeof r.completer.onSeen&&(r.completer.onSeen(this.editor,r),this.hasSeen.add(r))},u.prototype.$onPopupChange=function(r){if(this.inlineRenderer&&this.inlineEnabled){var e=r?null:this.popup.getData(this.popup.getRow());if(this.$updateGhostText(e),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null);this.popupTimer.schedule(),this.tooltipTimer.schedule()}else this.popupTimer.call(null,null),this.tooltipTimer.call(null,null)},u.prototype.$updateGhostText=function(r){var e=this.base.row,n=this.base.column,i=this.editor.getCursorPosition().column,t=this.editor.session.getLine(e).slice(n,i);this.inlineRenderer.show(this.editor,r,t)?this.$seen(r):this.inlineRenderer.hide()},u.prototype.$onPopupRender=function(){var r=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&this.completions.filtered.length>0)for(var e=this.popup.getFirstVisibleRow();e<=this.popup.getLastVisibleRow();e++){var n=this.popup.getData(e);n&&(!r||n.hideInlinePreview)&&this.$seen(n)}},u.prototype.$onPopupShow=function(r){this.$onPopupChange(r),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},u.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var r=this.editor.container.parentNode,e=[];r;)e.push(r),r.addEventListener("scroll",this.onLayoutChange,{passive:!0}),r=r.parentNode;this.$elements=e}},u.prototype.unObserveLayoutChanges=function(){var r=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(e){e.removeEventListener("scroll",r.onLayoutChange,{passive:!0})}),this.$elements=null},u.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},u.prototype.$updatePopupPosition=function(){var r=this.editor,e=r.renderer,n=e.layerConfig.lineHeight,i=e.$cursorLayer.getPixelPosition(this.base,!0);i.left-=this.popup.getTextLeftOffset();var t=r.container.getBoundingClientRect();i.top+=t.top-e.layerConfig.offset,i.left+=t.left-r.renderer.scrollLeft,i.left+=e.gutterWidth;var o={top:i.top,left:i.left};e.$ghostText&&e.$ghostTextWidget&&this.base.row===e.$ghostText.position.row&&(o.top+=e.$ghostTextWidget.el.offsetHeight);var p=r.container.getBoundingClientRect().bottom-n;this.popup.tryShow(p<o.top?{top:p,left:o.left}:o,n,"bottom")||this.popup.tryShow(i,n,"top")||this.popup.show(i,n)},u.prototype.openPopup=function(r,e,n){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var o,i=this.popup.getRow(),t=this.popup.data[i];if(this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:g(this.popup.getRow()),inline:this.inlineEnabled}),r.keyBinding.addKeyboardHandler(this.keyboardHandler),this.stickySelection&&(o=this.popup.data.indexOf(t)),(!o||-1===o)&&(o=0),this.popup.setRow(this.autoSelect?o:-1),o===i&&t!==this.completions.filtered[o]&&this.$onPopupChange(),o===i&&this.inlineRenderer&&this.inlineEnabled){var l=this.popup.getData(this.popup.getRow());this.$updateGhostText(l)}n||(this.popup.setTheme(r.getTheme()),this.popup.setFontSize(r.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},u.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.popup&&this.popup.renderer&&this.popup.renderer.off("afterRender",this.$onPopupRender),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},u.prototype.changeListener=function(r){var e=this.editor.selection.lead;(e.row!=this.base.row||e.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},u.prototype.blurListener=function(r){var e=document.activeElement,n=this.editor.textInput.getElement(),i=r.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(r.relatedTarget);e!=n&&e.parentNode!=(this.popup&&this.popup.container)&&!i&&e!=this.tooltipNode&&r.relatedTarget!=n&&this.detach()},u.prototype.mousedownListener=function(r){this.detach()},u.prototype.mousewheelListener=function(r){this.popup&&!this.popup.isMouseOver&&this.detach()},u.prototype.mouseOutListener=function(r){this.popup.isOpen&&this.$updatePopupPosition()},u.prototype.goTo=function(r){this.popup.goTo(r)},u.prototype.insertMatch=function(r,e){if(r||(r=this.popup.getData(this.popup.getRow())),!r)return!1;if(""===r.value)return this.detach();var n=this.completions,i=this.getCompletionProvider().insertMatch(this.editor,r,n.filterText,e);return this.completions==n&&this.detach(),i},u.prototype.showPopup=function(r,e){this.editor&&this.detach(),this.activated=!0,this.editor=r,r.completer!=this&&(r.completer&&r.completer.detach(),r.completer=this),r.on("changeSelection",this.changeListener),r.on("blur",this.blurListener),r.on("mousedown",this.mousedownListener),r.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,e)},u.prototype.getCompletionProvider=function(r){return this.completionProvider||(this.completionProvider=new P(r)),this.completionProvider},u.prototype.gatherCompletions=function(r,e){return this.getCompletionProvider().gatherCompletions(r,e)},u.prototype.updateCompletions=function(r,e){if(r&&this.base&&this.completions){var i=this.editor.getCursorPosition();if((t=this.editor.session.getTextRange({start:this.base,end:i}))==this.completions.filterText)return;return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,t,r):this.detach()}if(e&&e.matches)return i=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(i.row,i.column),this.base.$insertRight=!0,this.completions=new A(e.matches),this.getCompletionProvider().completions=this.completions,this.openPopup(this.editor,"",r);var n=this.editor.getSession(),t=(i=this.editor.getCursorPosition(),m.getCompletionPrefix(this.editor));this.base=n.doc.createAnchor(i.row,i.column-t.length),this.base.$insertRight=!0;var o={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:t,pos:i}).provideCompletions(this.editor,o,function(p,l,a){var c=l.filtered,s=m.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),a){if(!c.length){var f=!this.autoShown&&this.emptyMessage;return"function"==typeof f&&(f=this.emptyMessage(s)),f?(this.completions=new A([{caption:f,value:""}]),this.openPopup(this.editor,s,r),this.popup.renderer.setStyle("ace_loading",!1),void this.popup.renderer.setStyle("ace_empty-message",!0)):this.detach()}if(1==c.length&&c[0].value==s&&!c[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==c.length)return this.insertMatch(c[0])}this.completions=!a&&this.showLoadingState?new A(u.completionsForLoading.concat(c),l.filterText):l,this.openPopup(this.editor,s,r),this.popup.renderer.setStyle("ace_empty-message",!1),this.popup.renderer.setStyle("ace_loading",!a)}.bind(this)),this.showLoadingState&&!this.autoShown&&(!this.popup||!this.popup.isOpen)&&this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},u.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},u.prototype.updateDocTooltip=function(){var r=this.popup,e=this.completions&&this.completions.filtered,n=e&&(e[r.getHoveredRow()]||e[r.getRow()]),i=null;if(!n||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var t=this.editor.completers.length,o=0;o<t;o++){var p=this.editor.completers[o];if(p.getDocTooltip&&n.completerId===p.id){i=p.getDocTooltip(n);break}}if(!i&&"string"!=typeof n&&(i=n),"string"==typeof i&&(i={docText:i}),!i||!i.docHTML&&!i.docText)return this.hideDocTooltip();this.showDocTooltip(i)},u.prototype.showDocTooltip=function(r){this.tooltipNode||(this.tooltipNode=T.createElement("div"),this.tooltipNode.style.margin="0",this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.style.overscrollBehavior="contain",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"),this.tooltipNode.addEventListener("wheel",R));var e=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(e.isDark?"ace_dark ":"")+(e.cssClass||"");var n=this.tooltipNode;r.docHTML?n.innerHTML=r.docHTML:r.docText&&(n.textContent=r.docText),n.parentNode||this.popup.container.appendChild(this.tooltipNode);var i=this.popup,t=i.container.getBoundingClientRect(),o=400,p=300,l=i.renderer.scrollBar.width||10,a=t.left,c=window.innerWidth-t.right-l,s=i.isTopdown?t.top:window.innerHeight-l-t.bottom,f=[Math.min(c/o,1),Math.min(a/o,1),Math.min(s/p*.9)],d=Math.max.apply(Math,f),h=n.style;h.display="block",d==f[0]?(h.left=t.right+1+"px",h.right="",h.maxWidth=o*d+"px",h.top=t.top+"px",h.bottom="",h.maxHeight=Math.min(window.innerHeight-l-t.top,p)+"px"):d==f[1]?(h.right=window.innerWidth-t.left+"px",h.left="",h.maxWidth=o*d+"px",h.top=t.top+"px",h.bottom="",h.maxHeight=Math.min(window.innerHeight-l-t.top,p)+"px"):d==f[2]&&(h.left=window.innerWidth-t.left+"px",h.maxWidth=Math.min(o,window.innerWidth)+"px",i.isTopdown?(h.top=t.bottom+"px",h.left=t.left+"px",h.right="",h.bottom="",h.maxHeight=Math.min(window.innerHeight-l-t.bottom,p)+"px"):(h.top=i.container.offsetTop-n.offsetHeight+"px",h.left=t.left+"px",h.right="",h.bottom="",h.maxHeight=Math.min(i.container.offsetTop,p)+"px"))},u.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var r=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==r&&this.editor.focus(),this.tooltipNode=null,r.parentNode&&r.parentNode.removeChild(r)}},u.prototype.onTooltipClick=function(r){for(var e=r.target;e&&e!=this.tooltipNode;){if("A"==e.nodeName&&e.href){e.rel="noreferrer",e.target="_blank";break}e=e.parentNode}},u.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var r=this.popup.container;r&&r.parentNode&&r.parentNode.removeChild(r)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",N),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},u.for=function(r){return r.completer instanceof u||(r.completer&&(r.completer.destroy(),r.completer=null),_.get("sharedPopups")?(u.$sharedInstance||(u.$sharedInstance=new u),r.completer=u.$sharedInstance):(r.completer=new u,r.once("destroy",N))),r.completer},u}();E.prototype.commands={Up:function(u){u.completer.goTo("up")},Down:function(u){u.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(u){u.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(u){u.completer.goTo("end")},Esc:function(u){u.completer.detach()},Return:function(u){return u.completer.insertMatch()},"Shift-Return":function(u){u.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(u){var r=u.completer.insertMatch();if(r||u.tabstopManager)return r;u.completer.goTo("down")},Backspace:function(u){u.execCommand("backspace"),!m.getCompletionPrefix(u)&&u.completer&&u.completer.detach()},PageUp:function(u){u.completer.popup.gotoPageUp()},PageDown:function(u){u.completer.popup.gotoPageDown()}},E.startCommand={name:"startAutocomplete",exec:function(u,r){var e=E.for(u);e.autoInsert=!1,e.autoSelect=!0,e.autoShown=!1,e.showPopup(u,r),e.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var P=function(){function u(r){this.initialPosition=r,this.active=!0}return u.prototype.insertByIndex=function(r,e,n){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(r,this.completions.filtered[e],n)},u.prototype.insertMatch=function(r,e,n){if(!e)return!1;if(r.startOperation({command:{name:"insertMatch"}}),e.completer&&e.completer.insertMatch)e.completer.insertMatch(r,e);else{if(!this.completions)return!1;var i=this.completions.filterText.length,t=0;if(e.range&&e.range.start.row===e.range.end.row&&(i-=this.initialPosition.prefix.length,i+=this.initialPosition.pos.column-e.range.start.column,t+=e.range.end.column-this.initialPosition.pos.column),i||t){var o;o=r.selection.getAllRanges?r.selection.getAllRanges():[r.getSelectionRange()];for(var l,p=0;l=o[p];p++)l.start.column-=i,l.end.column+=t,r.session.remove(l)}e.snippet?k.insertSnippet(r,e.snippet):this.$insertString(r,e),e.completer&&e.completer.onInsert&&"function"==typeof e.completer.onInsert&&e.completer.onInsert(r,e),e.command&&"startAutocomplete"===e.command&&r.execCommand(e.command)}return r.endOperation(),!0},u.prototype.$insertString=function(r,e){r.execCommand("insertstring",e.value||e)},u.prototype.gatherCompletions=function(r,e){var n=r.getSession(),i=r.getCursorPosition(),t=m.getCompletionPrefix(r),o=[];this.completers=r.completers;var p=r.completers.length;return r.completers.forEach(function(l,a){l.getCompletions(r,n,i,t,function(c,s){l.hideInlinePreview&&(s=s.map(function(f){return Object.assign(f,{hideInlinePreview:l.hideInlinePreview})})),!c&&s&&(o=o.concat(s)),e(null,{prefix:m.getCompletionPrefix(r),matches:o,finished:0==--p})})}),!0},u.prototype.provideCompletions=function(r,e,n){var i=function(l){var a=l.prefix;this.completions=new A(l.matches),e.exactMatch&&(this.completions.exactMatch=!0),e.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(a),(l.finished||this.completions.filtered.length)&&n(null,this.completions,l.finished)}.bind(this),t=!0,o=null;if(this.gatherCompletions(r,function(l,a){if(this.active&&(l&&(n(l,[],!0),this.detach()),0===a.prefix.indexOf(a.prefix))){if(t)return void(o=a);i(a)}}.bind(this)),t=!1,o){var p=o;o=null,i(p)}},u.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(r){"function"==typeof r.cancel&&r.cancel()})},u}(),A=function(){function u(r,e){this.all=r,this.filtered=r,this.filterText=e||"",this.exactMatch=!1,this.ignoreCaption=!1}return u.prototype.setFilter=function(r){if(r.length>this.filterText&&0===r.lastIndexOf(this.filterText,0))var e=this.filtered;else e=this.all;this.filterText=r,e=(e=this.filterCompletions(e,this.filterText)).sort(function(i,t){return t.exactMatch-i.exactMatch||t.$score-i.$score||(i.caption||i.value).localeCompare(t.caption||t.value)});var n=null;e=e.filter(function(i){var t=i.snippet||i.caption||i.value;return t!==n&&(n=t,!0)}),this.filtered=e},u.prototype.filterCompletions=function(r,e){var n=[],i=e.toUpperCase(),t=e.toLowerCase();e:for(var p,o=0;p=r[o];o++)if(p.skipFilter)p.$score=p.score,n.push(p);else{var l=!this.ignoreCaption&&p.caption||p.value||p.snippet;if(l){var f,d,a=-1,c=0,s=0;if(this.exactMatch){if(e!==l.substr(0,e.length))continue e}else{var h=l.toLowerCase().indexOf(t);if(h>-1)s=h;else for(var w=0;w<e.length;w++){var S=l.indexOf(t[w],a+1),L=l.indexOf(i[w],a+1);if((f=S>=0&&(L<0||S<L)?S:L)<0)continue e;(d=f-a-1)>0&&(-1===a&&(s+=10),s+=d,c|=1<<w),a=f}}p.matchMask=c,p.exactMatch=s?0:1,p.$score=(p.score||0)-s,n.push(p)}}return n},u}();M.Autocomplete=E,M.CompletionProvider=P,M.FilteredList=A}),ace.define("ace/marker_group",["require","exports","module"],function(b,M,W){"use strict";var $=function(){function x(y,g){g&&(this.markerType=g.markerType),this.markers=[],this.session=y,y.addDynamicMarker(this)}return x.prototype.getMarkerAtPosition=function(y){return this.markers.find(function(g){return g.range.contains(y.row,y.column)})},x.prototype.markersComparator=function(y,g){return y.range.start.row-g.range.start.row},x.prototype.setMarkers=function(y){this.markers=y.sort(this.markersComparator).slice(0,this.MAX_MARKERS),this.session._signal("changeBackMarker")},x.prototype.update=function(y,g,m,v){if(this.markers&&this.markers.length)for(var _,T=v.firstRow,k=v.lastRow,I=0,R=0,N=0;N<this.markers.length;N++){var E=this.markers[N];if(!(E.range.end.row<T||E.range.start.row>k||(E.range.start.row===R?I++:(R=E.range.start.row,I=0),I>200))){var P=E.range.clipRows(T,k);if(P.start.row!==P.end.row||P.start.column!==P.end.column){var A=P.toScreenRange(m);if(A.isEmpty()){(_=m.getNextFoldLine(P.end.row,_))&&_.end.row>P.end.row&&(T=_.end.row);continue}"fullLine"===this.markerType?g.drawFullLineMarker(y,A,E.className,v):A.isMultiLine()?"line"===this.markerType?g.drawMultiLineMarker(y,A,E.className,v):g.drawTextMarker(y,A,E.className,v):g.drawSingleLineMarker(y,A,E.className+" ace_br15",v)}}}},x}();$.prototype.MAX_MARKERS=1e4,M.MarkerGroup=$}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(b,M,W){var $=b("../range").Range,x=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;M.getCompletions=function(m,v,T,k,_){var I=function g(m,v){var T=function y(m,v){return m.getTextRange($.fromPoints({row:0,column:0},v)).split(x).length-1}(m,v),k=m.getValue().split(x),_=Object.create(null),I=k[T];return k.forEach(function(R,N){if(R&&R!==I){var E=Math.abs(T-N),P=k.length-E;_[R]=_[R]?Math.max(P,_[R]):P}}),_}(v,T);_(null,Object.keys(I).map(function(N){return{caption:N,value:N,score:I[N],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/marker_group","ace/autocomplete/text_completer","ace/editor","ace/config"],function(b,M,W){"use strict";var $=b("../snippets").snippetManager,x=b("../autocomplete").Autocomplete,y=b("../config"),g=b("../lib/lang"),m=b("../autocomplete/util"),v=b("../marker_group").MarkerGroup,T=b("../autocomplete/text_completer"),k={getCompletions:function(t,o,p,l,a){if(o.$mode.completer)return o.$mode.completer.getCompletions(t,o,p,l,a);var c=t.session.getState(p.row),s=o.$mode.getCompletions(c,o,p,l);a(null,s=s.map(function(f){return f.completerId=k.id,f}))},id:"keywordCompleter"},_=function(t){var o={};return t.replace(/\${(\d+)(:(.*?))?}/g,function(p,l,a,c){return o[l]=c||""}).replace(/\$(\d+?)/g,function(p,l){return o[l]})},I={getCompletions:function(t,o,p,l,a){var c=[],s=o.getTokenAt(p.row,p.column);s&&s.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?c.push("html-tag"):c=$.getActiveScopes(t);var f=$.snippetMap,d=[];c.forEach(function(h){for(var w=f[h]||[],S=w.length;S--;){var L=w[S],H=L.name||L.tabTrigger;H&&d.push({caption:H,snippet:L.content,meta:L.tabTrigger&&!L.name?L.tabTrigger+"\u21e5 ":"snippet",completerId:I.id})}},this),a(null,d)},getDocTooltip:function(t){t.snippet&&!t.docHTML&&(t.docHTML=["<b>",g.escapeHTML(t.caption),"</b>","<hr></hr>",g.escapeHTML(_(t.snippet))].join(""))},id:"snippetCompleter"},R=[I,T,k];M.setCompleters=function(t){R.length=0,t&&R.push.apply(R,t)},M.addCompleter=function(t){R.push(t)},M.textCompleter=T,M.keyWordCompleter=k,M.snippetCompleter=I;var r,N={name:"expandSnippet",exec:function(t){return $.expandWithTab(t)},bindKey:"Tab"},E=function(t,o){P(o.session.$mode)},P=function(t){"string"==typeof t&&(t=y.$modes[t]),t&&($.files||($.files={}),A(t.$id,t.snippetFileId),t.modes&&t.modes.forEach(P))},A=function(t,o){!o||!t||$.files[t]||($.files[t]={},y.loadModule(o,function(p){p&&($.files[t]=p,!p.snippets&&p.snippetText&&(p.snippets=$.parseSnippetFile(p.snippetText)),$.register(p.snippets||[],p.scope),p.includeScopes&&($.snippetMap[p.scope].includeScopes=p.includeScopes,p.includeScopes.forEach(function(l){P("ace/mode/"+l)})))}))},u=function(t){var o=t.editor,p=o.completer&&o.completer.activated;if("backspace"===t.command.name)p&&!m.getCompletionPrefix(o)&&o.completer.detach();else if("insertstring"===t.command.name&&!p){r=t;var l=t.editor.$liveAutocompletionDelay;l?e.delay(l):n(t)}},e=g.delayedCall(function(){n(r)},0),n=function(t){var o=t.editor,p=m.getCompletionPrefix(o),a=m.triggerAutocomplete(o,t.args);if(p&&p.length>=o.$liveAutocompletionThreshold||a){var c=x.for(o);c.autoShown=!0,c.showPopup(o)}},i=b("../editor").Editor;b("../config").defineOptions(i.prototype,"editor",{enableBasicAutocompletion:{set:function(t){t?(x.for(this),this.completers||(this.completers=Array.isArray(t)?t:R),this.commands.addCommand(x.startCommand)):this.commands.removeCommand(x.startCommand)},value:!1},enableLiveAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:R),this.commands.on("afterExec",u)):this.commands.off("afterExec",u)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(t){t?(this.commands.addCommand(N),this.on("changeMode",E),E(0,this)):(this.commands.removeCommand(N),this.off("changeMode",E))},value:!1}}),M.MarkerGroup=v}),ace.require(["ace/ext/language_tools"],function(b){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=b)});