ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),m=(c("../lib/lang"),c("./text_highlight_rules").TextHighlightRules),u=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",l=h.supportFunction="rgb|rgba|url|attr|counter|counters",s=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",o=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",i=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",r=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",n=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",e=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",t=function(){var a=this.createKeywordMapper({"support.function":l,"support.constant":s,"support.type":u,"support.constant.color":o,"support.constant.fonts":i},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:r},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+r+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:r},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:n},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:e},{include:"url"},{token:a,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{token:"paren.lparen",regex:"\\{"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};x.inherits(t,m),h.CssHighlightRules=t}),ace.define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text_highlight_rules").TextHighlightRules,m=function(){this.$rules={start:[{token:["comment.doc.tag","comment.doc.text","lparen.doc"],regex:"(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:["rparen.doc","text.doc","variable.parameter.doc","lparen.doc","variable.parameter.doc","rparen.doc"],regex:/(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.\-\'\" ]+)(\])))/,next:"pop"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","lparen.doc"],regex:"(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|implements|external|exception|throws|enum|define|extends))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:'(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|requires|param|implements|function|extends|typedef|mixes|constructor|var|memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#.:/~"\\-]*)?'},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@method)(\\s+)(\\w[\\w.\\(\\)]*)"},{token:"comment.doc.tag",regex:"@access\\s+(?:private|public|protected)"},{token:"comment.doc.tag",regex:"@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"},{token:"comment.doc.tag",regex:"@\\w+(?=\\s|$)"},m.getTagRule(),{defaultToken:"comment.doc.body",caseInsensitive:!0}],"doc-syntax":[{token:"operator.doc",regex:/[|:]/},{token:"paren.doc",regex:/[\[\]]/}]},this.normalizeRules()};x.inherits(m,b),m.getTagRule=function(u){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},m.getStartRule=function(u){return{token:"comment.doc",regex:/\/\*\*(?!\/)/,next:u}},m.getEndRule=function(u){return{token:"comment.doc",regex:"\\*\\/",next:u}},h.JsDocCommentHighlightRules=m}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules,m=c("./text_highlight_rules").TextHighlightRules,u="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",l=function(i){var r={"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},n=this.createKeywordMapper(r,"identifier"),t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)",a="(function)(\\s*)(\\*?)",d={token:["identifier","text","paren.lparen"],regex:"(\\b(?!"+Object.values(r).join("|")+"\\b)"+u+")(\\s*)(\\()"};this.$rules={no_regex:[b.getStartRule("doc-start"),o("no_regex"),d,{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+u+")(\\s*)(=)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))("+u+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+u+")(\\s*)(:)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|debug|time|trace|timeEnd|assert)\b/},{token:n,regex:u},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:"keyword.operator",regex:/=/},{token:["storage.type","text","storage.type","text","paren.lparen"],regex:a+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:"prototype"},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:u},{regex:"",token:"empty",next:"no_regex"}],start:[b.getStartRule("doc-start"),o("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[o("function_arguments"),{token:"variable.parameter",regex:u},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!i||!i.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(p,v,y){if(this.next="{"==p?this.nextState:"","{"==p&&y.length)y.unshift("start",v);else if("}"==p&&y.length&&(y.shift(),this.next=y.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==p?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+u+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=[^\\(]+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!i||0!=i.jsx)&&s.call(this)),this.embedRules(b,"doc-",[b.getEndRule("no_regex")]),this.normalizeRules()};function s(){var i=u.replace("\\d","\\d\\-"),r={onMatch:function(e,t,a){var d="/"==e.charAt(1)?2:1;return 1==d?(t!=this.nextState?a.unshift(this.next,this.nextState,0):a.unshift(this.next),a[2]++):2==d&&t==this.nextState&&(a[1]--,(!a[1]||a[1]<0)&&(a.shift(),a.shift())),[{type:"meta.tag.punctuation."+(1==d?"":"end-")+"tag-open.xml",value:e.slice(0,d)},{type:"meta.tag.tag-name.xml",value:e.substr(d)}]},regex:"</?(?:"+i+"|(?=>))",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(r);var n={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[n,r,{include:"reference"},{defaultToken:"string.xml"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,a){return t==a[0]&&a.shift(),2==e.length&&(a[0]==this.nextState&&a[1]--,(!a[1]||a[1]<0)&&a.splice(0,2)),this.next=a[0]||"start",[{type:this.token,value:e}]},nextState:"jsx"},n,o("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:i},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},r],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function o(i){return[{token:"comment",regex:/\/\*/,next:[b.getTagRule(),{token:"comment",regex:"\\*\\/",next:i||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[b.getTagRule(),{token:"comment",regex:"$|^",next:i||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}x.inherits(l,m),h.JavaScriptHighlightRules=l}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text_highlight_rules").TextHighlightRules,m=function(u){var l="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+l+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:l},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+l+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+l+":)?"+l+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:l},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===m&&this.normalizeRules()};(function(){this.embedTagRules=function(u,l,s){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+s+".tag-name.xml"],regex:"(<)("+s+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:l+"start"}]}),this.$rules[s+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(o,i,r){return r.splice(0),this.token}}],this.embedRules(u,l,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+s+".tag-name.xml"],regex:"(</)("+s+"(?=\\s|>|$))",next:s+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(b.prototype),x.inherits(m,b),h.XmlHighlightRules=m}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("../lib/lang"),m=c("./css_highlight_rules").CssHighlightRules,u=c("./javascript_highlight_rules").JavaScriptHighlightRules,l=c("./xml_highlight_rules").XmlHighlightRules,s=b.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),o=function(){l.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(i,r){var n=s[r];return["meta.tag.punctuation."+("<"==i?"":"end-")+"tag-open.xml","meta.tag"+(n?"."+n:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(m,"css-","style"),this.embedTagRules(new u({jsx:!1}).getRules(),"js-","script"),this.constructor===o&&this.normalizeRules()};x.inherits(o,l),h.HtmlHighlightRules=o}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,h,_){"use strict";var x=c("../range").Range,b=function(){};(function(){this.checkOutdent=function(m,u){return!!/^\s+$/.test(m)&&/^\s*\}/.test(u)},this.autoOutdent=function(m,u){var s=m.getLine(u).match(/^(\s*\})/);if(!s)return 0;var o=s[1].length,i=m.findMatchingBracket({row:u,column:o});if(!i||i.row==u)return 0;var r=this.$getIndent(m.getLine(i.row));m.replace(new x(u,0,u,o-1),r)},this.$getIndent=function(m){return m.match(/^\s*/)[0]}}).call(b.prototype),h.MatchingBraceOutdent=b}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("../behaviour").Behaviour,m=c("../../token_iterator").TokenIterator;function u(s,o){return s&&s.type.lastIndexOf(o+".xml")>-1}var l=function(){this.add("string_dquotes","insertion",function(s,o,i,r,n){if('"'==n||"'"==n){var e=n,t=r.doc.getTextRange(i.getSelectionRange());if(""!==t&&"'"!==t&&'"'!=t&&i.getWrapBehavioursEnabled())return{text:e+t+e,selection:!1};var a=i.getCursorPosition(),p=r.doc.getLine(a.row).substring(a.column,a.column+1),v=new m(r,a.row,a.column),y=v.getCurrentToken();if(p==e&&(u(y,"attribute-value")||u(y,"string")))return{text:"",selection:[1,1]};if(y||(y=v.stepBackward()),!y)return;for(;u(y,"tag-whitespace")||u(y,"whitespace");)y=v.stepBackward();var w=!p||p.match(/\s/);if(u(y,"attribute-equals")&&(w||">"==p)||u(y,"decl-attribute-equals")&&(w||"?"==p))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(s,o,i,r,n){var e=r.doc.getTextRange(n);if(!n.isMultiLine()&&('"'==e||"'"==e)&&r.doc.getLine(n.start.row).substring(n.start.column+1,n.start.column+2)==e)return n.end.column++,n}),this.add("autoclosing","insertion",function(s,o,i,r,n){if(">"==n){var e=i.getSelectionRange().start,t=new m(r,e.row,e.column),a=t.getCurrentToken()||t.stepBackward();if(!a||!(u(a,"tag-name")||u(a,"tag-whitespace")||u(a,"attribute-name")||u(a,"attribute-equals")||u(a,"attribute-value"))||u(a,"reference.attribute-value"))return;if(u(a,"attribute-value")){var d=t.getCurrentTokenColumn()+a.value.length;if(e.column<d)return;if(e.column==d){var p=t.stepForward();if(p&&u(p,"attribute-value"))return;t.stepBackward()}}if(/^\s*>/.test(r.getLine(e.row).slice(e.column)))return;for(;!u(a,"tag-name");)if("<"==(a=t.stepBackward()).value){a=t.stepForward();break}var v=t.getCurrentTokenRow(),y=t.getCurrentTokenColumn();if(u(t.stepBackward(),"end-tag-open"))return;var w=a.value;return v==e.row&&(w=w.substring(0,e.column-y)),this.voidElements&&this.voidElements.hasOwnProperty(w.toLowerCase())?void 0:{text:"></"+w+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(s,o,i,r,n){if("\n"==n){var e=i.getCursorPosition(),t=r.getLine(e.row),a=new m(r,e.row,e.column),d=a.getCurrentToken();if(u(d,"")&&-1!==d.type.indexOf("tag-close")){if("/>"==d.value)return;for(;d&&-1===d.type.indexOf("tag-name");)d=a.stepBackward();if(!d)return;var p=d.value,v=a.getCurrentTokenRow();if(!(d=a.stepBackward())||-1!==d.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[p]||!this.voidElements){var y=r.getTokenAt(e.row,e.column+1),w=(t=r.getLine(v),this.$getIndent(t)),T=w+r.getTabString();return y&&"</"===y.value?{text:"\n"+T+"\n"+w,selection:[1,T.length,1,T.length]}:{text:"\n"+T}}}}})};x.inherits(l,b),h.XmlBehaviour=l}),ace.define("ace/mode/behaviour/javascript",["require","exports","module","ace/lib/oop","ace/token_iterator","ace/mode/behaviour/cstyle","ace/mode/behaviour/xml"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("../../token_iterator").TokenIterator,m=c("../behaviour/cstyle").CstyleBehaviour,u=c("../behaviour/xml").XmlBehaviour,l=function(){var s=new u({closeCurlyBraces:!0}).getBehaviours();this.addBehaviours(s),this.inherit(m),this.add("autoclosing-fragment","insertion",function(o,i,r,n,e){if(">"==e){var t=r.getSelectionRange().start,a=new b(n,t.row,t.column),d=a.getCurrentToken()||a.stepBackward();if(!d)return;if("<"==d.value)return{text:"></>",selection:[1,1]}}})};x.inherits(l,m),h.JavaScriptBehaviour=l}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("../../range").Range,m=c("./fold_mode").FoldMode,u=h.FoldMode=function(o,i){m.call(this),this.voidElements=o||{},this.optionalEndTags=x.mixin({},this.voidElements),i&&x.mixin(this.optionalEndTags,i)};x.inherits(u,m);var l=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function s(o,i){return o&&o.type&&o.type.lastIndexOf(i+".xml")>-1}(function(){this.getFoldWidget=function(o,i,r){var n=this._getFirstTagInLine(o,r);return n?n.closing||!n.tagName&&n.selfClosing?"markbeginend"===i?"end":"":!n.tagName||n.selfClosing||this.voidElements.hasOwnProperty(n.tagName.toLowerCase())||this._findEndTagInLine(o,r,n.tagName,n.end.column)?"":"start":this.getCommentFoldWidget(o,r)},this.getCommentFoldWidget=function(o,i){return/comment/.test(o.getState(i))&&/<!-/.test(o.getLine(i))?"start":""},this._getFirstTagInLine=function(o,i){for(var r=o.getTokens(i),n=new l,e=0;e<r.length;e++){var t=r[e];if(s(t,"tag-open")){if(n.end.column=n.start.column+t.value.length,n.closing=s(t,"end-tag-open"),!(t=r[++e]))return null;if(n.tagName=t.value,""===t.value){if(!(t=r[++e]))return null;n.tagName=t.value}for(n.end.column+=t.value.length,e++;e<r.length;e++)if(n.end.column+=(t=r[e]).value.length,s(t,"tag-close")){n.selfClosing="/>"==t.value;break}return n}if(s(t,"tag-close"))return n.selfClosing="/>"==t.value,n;n.start.column+=t.value.length}return null},this._findEndTagInLine=function(o,i,r,n){for(var e=o.getTokens(i),t=0,a=0;a<e.length;a++){var d=e[a];if(!((t+=d.value.length)<n-1)&&s(d,"end-tag-open")&&(s(d=e[a+1],"tag-name")&&""===d.value&&(d=e[a+2]),d&&d.value==r))return!0}return!1},this.getFoldWidgetRange=function(o,i,r){if(!this._getFirstTagInLine(o,r))return this.getCommentFoldWidget(o,r)&&o.getCommentFoldRange(r,o.getLine(r).length);var e=o.getMatchingTags({row:r,column:0});return e?new b(e.openTag.end.row,e.openTag.end.column,e.closeTag.start.row,e.closeTag.start.column):void 0}}).call(u.prototype)}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("../../range").Range,m=c("./fold_mode").FoldMode,u=h.FoldMode=function(l){l&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+l.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+l.end)))};x.inherits(u,m),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(l,s,o){var i=l.getLine(o);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var r=this._getFoldWidgetBase(l,s,o);return!r&&this.startRegionRe.test(i)?"start":r},this.getFoldWidgetRange=function(l,s,o,i){var t,r=l.getLine(o);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(l,r,o);if(t=r.match(this.foldingStartMarker)){var n=t.index;if(t[1])return this.openingBracketBlock(l,t[1],o,n);var e=l.getCommentFoldRange(o,n+t[0].length,1);return e&&!e.isMultiLine()&&(i?e=this.getSectionRange(l,o):"all"!=s&&(e=null)),e}return"markbegin"!==s&&(t=r.match(this.foldingStopMarker))?(n=t.index+t[0].length,t[1]?this.closingBracketBlock(l,t[1],o,n):l.getCommentFoldRange(o,n,-1)):void 0},this.getSectionRange=function(l,s){for(var o=l.getLine(s),i=o.search(/\S/),r=s,n=o.length,e=s+=1,t=l.getLength();++s<t;){var a=(o=l.getLine(s)).search(/\S/);if(-1!==a){if(i>a)break;var d=this.getFoldWidgetRange(l,"all",s);if(d){if(d.start.row<=r)break;if(d.isMultiLine())s=d.end.row;else if(i==a)break}e=s}}return new b(r,n,e,l.getLine(e).length)},this.getCommentRegionBlock=function(l,s,o){for(var i=s.search(/\s*$/),r=l.getLength(),n=o,e=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++o<r;){s=l.getLine(o);var a=e.exec(s);if(a&&(a[1]?t--:t++,!t))break}if(o>n)return new b(n,i,o,s.length)}}.call(u.prototype)}),ace.define("ace/mode/folding/javascript",["require","exports","module","ace/lib/oop","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("./xml").FoldMode,m=c("./cstyle").FoldMode,u=h.FoldMode=function(l){l&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+l.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+l.end))),this.xmlFoldMode=new b};x.inherits(u,m),function(){this.getFoldWidgetRangeBase=this.getFoldWidgetRange,this.getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(l,s,o){return this.getFoldWidgetBase(l,s,o)||this.xmlFoldMode.getFoldWidget(l,s,o)},this.getFoldWidgetRange=function(l,s,o,i){return this.getFoldWidgetRangeBase(l,s,o,i)||this.xmlFoldMode.getFoldWidgetRange(l,s,o)}}.call(u.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/javascript","ace/mode/folding/javascript"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text").Mode,m=c("./javascript_highlight_rules").JavaScriptHighlightRules,u=c("./matching_brace_outdent").MatchingBraceOutdent,l=c("../worker/worker_client").WorkerClient,s=c("./behaviour/javascript").JavaScriptBehaviour,o=c("./folding/javascript").FoldMode,i=function(){this.HighlightRules=m,this.$outdent=new u,this.$behaviour=new s,this.foldingRules=new o};x.inherits(i,b),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.$pairQuotesAfter={"`":/\w/},this.getNextLineIndent=function(r,n,e){var t=this.$getIndent(n),a=this.getTokenizer().getLineTokens(n,r),d=a.tokens,p=a.state;if(d.length&&"comment"==d[d.length-1].type)return t;if("start"==r||"no_regex"==r)n.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/)&&(t+=e);else if("doc-start"==r&&("start"==p||"no_regex"==p))return"";return t},this.checkOutdent=function(r,n,e){return this.$outdent.checkOutdent(n,e)},this.autoOutdent=function(r,n,e){this.$outdent.autoOutdent(n,e)},this.createWorker=function(r){var n=new l(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return n.attachToDocument(r.getDocument()),n.on("annotate",function(e){r.setAnnotations(e.data)}),n.on("terminate",function(){r.clearAnnotations()}),n},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/css_completions",["require","exports","module"],function(c,h,_){"use strict";var x={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},b=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var m=document.createElement("c").style;for(var u in m)if("string"==typeof m[u]){var l=u.replace(/[A-Z]/g,function(s){return"-"+s.toLowerCase()});x.hasOwnProperty(l)||(x[l]=1)}}this.completionsDefined=!0},this.getCompletions=function(m,u,l,s){if(this.completionsDefined||this.defineCompletions(),"ruleset"===m||"ace/mode/scss"==u.$mode.$id){var o=u.getLine(l.row).substr(0,l.column),i=/\([^)]*$/.test(o);return i&&(o=o.substr(o.lastIndexOf("(")+1)),/:[^;]+$/.test(o)?(/([\w\-]+):[^:]*$/.test(o),this.getPropertyValueCompletions(m,u,l,s)):this.getPropertyCompletions(m,u,l,s,i)}return[]},this.getPropertyCompletions=function(m,u,l,s,o){return o=o||!1,Object.keys(x).map(function(r){return{caption:r,snippet:r+": $0"+(o?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(m,u,l,s){var o=u.getLine(l.row).substr(0,l.column),i=(/([\w\-]+):[^:]*$/.exec(o)||{})[1];if(!i)return[];var r=[];return i in x&&"object"==typeof x[i]&&(r=Object.keys(x[i])),r.map(function(n){return{caption:n,snippet:n,meta:"property value",score:1e6}})}}).call(b.prototype),h.CssCompletions=b}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(c,h,_){"use strict";var x=c("../../lib/oop"),m=(c("../behaviour"),c("./cstyle").CstyleBehaviour),u=c("../../token_iterator").TokenIterator,l=function(){this.inherit(m),this.add("colon","insertion",function(s,o,i,r,n){if(":"===n&&i.selection.isEmpty()){var e=i.getCursorPosition(),t=new u(r,e.row,e.column),a=t.getCurrentToken();if(a&&a.value.match(/\s+/)&&(a=t.stepBackward()),a&&"support.type"===a.type){var d=r.doc.getLine(e.row);if(":"===d.substring(e.column,e.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(d.substring(e.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(s,o,i,r,n){var e=r.doc.getTextRange(n);if(!n.isMultiLine()&&":"===e){var t=i.getCursorPosition(),a=new u(r,t.row,t.column),d=a.getCurrentToken();if(d&&d.value.match(/\s+/)&&(d=a.stepBackward()),d&&"support.type"===d.type&&";"===r.doc.getLine(n.start.row).substring(n.end.column,n.end.column+1))return n.end.column++,n}}),this.add("semicolon","insertion",function(s,o,i,r,n){if(";"===n&&i.selection.isEmpty()){var e=i.getCursorPosition();if(";"===r.doc.getLine(e.row).substring(e.column,e.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(s,o,i,r,n){if("!"===n&&i.selection.isEmpty()){var e=i.getCursorPosition(),t=r.doc.getLine(e.row);if(/^\s*(;|}|$)/.test(t.substring(e.column)))return{text:"!important",selection:[10,10]}}})};x.inherits(l,m),h.CssBehaviour=l}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text").Mode,m=c("./css_highlight_rules").CssHighlightRules,u=c("./matching_brace_outdent").MatchingBraceOutdent,l=c("../worker/worker_client").WorkerClient,s=c("./css_completions").CssCompletions,o=c("./behaviour/css").CssBehaviour,i=c("./folding/cstyle").FoldMode,r=function(){this.HighlightRules=m,this.$outdent=new u,this.$behaviour=new o,this.$completer=new s,this.foldingRules=new i};x.inherits(r,b),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(n,e,t){var a=this.$getIndent(e),d=this.getTokenizer().getLineTokens(e,n).tokens;return d.length&&"comment"==d[d.length-1].type||e.match(/^.*\{\s*$/)&&(a+=t),a},this.checkOutdent=function(n,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(n,e,t){this.$outdent.autoOutdent(e,t)},this.getCompletions=function(n,e,t,a){return this.$completer.getCompletions(n,e,t,a)},this.createWorker=function(n){var e=new l(["ace"],"ace/mode/css_worker","Worker");return e.attachToDocument(n.getDocument()),e.on("annotate",function(t){n.setAnnotations(t.data)}),e.on("terminate",function(){n.clearAnnotations()}),e},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(r.prototype),h.Mode=r}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("./fold_mode").FoldMode,m=h.FoldMode=function(u,l){this.defaultMode=u,this.subModes=l};x.inherits(m,b),function(){this.$getMode=function(u){for(var l in"string"!=typeof u&&(u=u[0]),this.subModes)if(0===u.indexOf(l))return this.subModes[l];return null},this.$tryMode=function(u,l,s,o){var i=this.$getMode(u);return i?i.getFoldWidget(l,s,o):""},this.getFoldWidget=function(u,l,s){return this.$tryMode(u.getState(s-1),u,l,s)||this.$tryMode(u.getState(s),u,l,s)||this.defaultMode.getFoldWidget(u,l,s)},this.getFoldWidgetRange=function(u,l,s){var o=this.$getMode(u.getState(s-1));return(!o||!o.getFoldWidget(u,l,s))&&(o=this.$getMode(u.getState(s))),(!o||!o.getFoldWidget(u,l,s))&&(o=this.defaultMode),o.getFoldWidgetRange(u,l,s)}}.call(m.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("./mixed").FoldMode,m=c("./xml").FoldMode,u=c("./cstyle").FoldMode,l=h.FoldMode=function(s,o){b.call(this,new m(s,o),{"js-":new u,"css-":new u})};x.inherits(l,b)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(c,h,_){"use strict";var x=c("../token_iterator").TokenIterator,u=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),l={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},s=Object.keys(l);function o(e,t){return e.type.lastIndexOf(t+".xml")>-1}function i(e,t){for(var a=new x(e,t.row,t.column),d=a.getCurrentToken();d&&!o(d,"tag-name");)d=a.stepBackward();if(d)return d.value}var n=function(){};(function(){this.getCompletions=function(e,t,a,d){var p=t.getTokenAt(a.row,a.column);if(!p)return[];if(o(p,"tag-name")||o(p,"tag-open")||o(p,"end-tag-open"))return this.getTagCompletions(e,t,a,d);if(o(p,"tag-whitespace")||o(p,"attribute-name"))return this.getAttributeCompletions(e,t,a,d);if(o(p,"attribute-value"))return this.getAttributeValueCompletions(e,t,a,d);var v=t.getLine(a.row).substr(0,a.column);return/&[a-z]*$/i.test(v)?this.getHTMLEntityCompletions(e,t,a,d):[]},this.getTagCompletions=function(e,t,a,d){return s.map(function(p){return{value:p,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(e,t,a,d){var p=i(t,a);if(!p)return[];var v=u;return p in l&&(v=v.concat(Object.keys(l[p]))),v.map(function(y){return{caption:y,snippet:y+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(e,t,a,d){var p=i(t,a),v=function r(e,t){for(var a=new x(e,t.row,t.column),d=a.getCurrentToken();d&&!o(d,"attribute-name");)d=a.stepBackward();if(d)return d.value}(t,a);if(!p)return[];var y=[];return p in l&&v in l[p]&&"object"==typeof l[p][v]&&(y=Object.keys(l[p][v])),y.map(function(w){return{caption:w,snippet:w,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(e,t,a,d){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(v){return{caption:v,snippet:v,meta:"html entity",score:1e6}})}}).call(n.prototype),h.HtmlCompletions=n}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("../lib/lang"),m=c("./text").Mode,u=c("./javascript").Mode,l=c("./css").Mode,s=c("./html_highlight_rules").HtmlHighlightRules,o=c("./behaviour/xml").XmlBehaviour,i=c("./folding/html").FoldMode,r=c("./html_completions").HtmlCompletions,n=c("../worker/worker_client").WorkerClient,e=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],t=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],a=function(d){this.fragmentContext=d&&d.fragmentContext,this.HighlightRules=s,this.$behaviour=new o,this.$completer=new r,this.createModeDelegates({"js-":u,"css-":l}),this.foldingRules=new i(this.voidElements,b.arrayToMap(t))};x.inherits(a,m),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=b.arrayToMap(e),this.getNextLineIndent=function(d,p,v){return this.$getIndent(p)},this.checkOutdent=function(d,p,v){return!1},this.getCompletions=function(d,p,v,y){return this.$completer.getCompletions(d,p,v,y)},this.createWorker=function(d){if(this.constructor==a){var p=new n(["ace"],"ace/mode/html_worker","Worker");return p.attachToDocument(d.getDocument()),this.fragmentContext&&p.call("setOptions",[{context:this.fragmentContext}]),p.on("error",function(v){d.setAnnotations(v.data)}),p.on("terminate",function(){d.clearAnnotations()}),p}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(a.prototype),h.Mode=a}),ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text_highlight_rules").TextHighlightRules,m=h.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};h.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},h.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},h.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var u=h.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"},l=h.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/},s=h.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/},o=h.constantNumericOctal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/},i=h.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/},r=h.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/},n=h.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"},e=h.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},t=function(){var y=this.$keywords=this.createKeywordMapper({keyword:"alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend","constant.language":"true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION","variable.language":"$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self","support.function":"abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|private_class_method|remove_method|undef_method","invalid.deprecated":"debugger"},"identifier"),w="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})",T={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:w},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:w},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(f,k,g){return g.length&&(g=[]),g.unshift(f[f.length-1],k),this.next="qStateWithoutInterpolation",this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(f,k,g){return g.length&&(g=[]),g.unshift(f[f.length-1],k),this.next="qStateWithInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(f,k,g){return g.length&&(g=[]),g.unshift(f[f.length-1],k),this.next="sStateWithoutInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(f,k,g){return g.length&&(g=[]),g.unshift(f[f.length-1],k),this.next="sStateWithInterpolation",this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(f,k,g){return g.length&&(g=[]),g.unshift(f[f.length-1],k),this.next="rState",this.token}}],{token:"punctuation",regex:"::"},e,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+w+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},i,r,m,u,n,l,s,o,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:y,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(f,k,g){var R="-"==f[2]||"~"==f[2]?"indentedHeredoc":"heredoc",C=f.split(this.splitRegex);return g.push(R,C[3]),[{type:"constant",value:C[1]},{type:"string",value:C[2]},{type:"support.class",value:C[3]},{type:"string",value:C[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(f,k,g){return f===g[1]?(g.shift(),g.shift(),this.next=g[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(f,k,g){return f===g[1]?(g.shift(),g.shift(),this.next=g[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(f,k){return"heredoc"===k[0]||"indentedHeredoc"===k[0]?k[0]:f}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(f,k,g){return this.next="","}"==f&&g.length>1&&"start"!=g[1]&&(g.shift(),this.next=g.shift()),this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(f,k,g){return g.length&&f===g[0]?(g.unshift(f,k),this.token):"string"}},{token:"constant.language.escape",regex:w},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(f,k,g){return g.length&&f===T[g[0]]?(g.shift(),this.next=g.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(f,k,g){return g.length&&f===g[0]?(g.unshift(f,k),this.token):"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(f,k,g){return g.length&&f===T[g[0]]?(g.shift(),this.next=g.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(f,k,g){return g.length&&f===g[0]?(g.unshift(f,k),this.token):"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(f,k,g){return g.length&&f===T[g[0]]?(g.shift(),this.next=g.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(f,k,g){return g.length&&f===g[0]?(g.unshift(f,k),this.token):"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:w},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(f,k,g){return g.length&&f===T[g[0]]?(g.shift(),this.next=g.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(f,k,g){return g.length&&f===g[0]?(g.unshift(f,k),this.token):"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(f,k,g){return g.length&&f[0]===T[g[0]]?(g.shift(),this.next=g.shift(),this.token):(this.next="","constant.language.escape")}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]},this.normalizeRules()};x.inherits(t,b),h.RubyHighlightRules=t}),ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],function(c,h,_){"use strict";var x=c("../../lib/oop"),b=c("./fold_mode").FoldMode,m=c("../../range").Range,u=c("../../token_iterator").TokenIterator,l=h.FoldMode=function(){};x.inherits(l,b),function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1},this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/,this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/,this.getFoldWidget=function(s,o,i){var t,r=s.getLine(i),n=this.foldingStartMarker.test(r),e=this.foldingStopMarker.test(r);if(n&&!e)if((t=r.match(this.foldingStartMarker))[1]){if(("if"==t[1]||"else"==t[1]||"while"==t[1]||"until"==t[1]||"unless"==t[1])&&("else"==t[1]&&!1===/^\s*else\s*$/.test(r)||!1===/^\s*(?:if|else|while|until|unless)\s*/.test(r))||"when"==t[1]&&!0===/\sthen\s/.test(r))return;if("keyword"===s.getTokenAt(i,t.index+2).type)return"start"}else{if(!t[3])return"start";if("comment.multiline"===s.getTokenAt(i,t.index+1).type)return"start"}if("markbeginend"!=o||!e||n&&e)return"";if("end"===(t=r.match(this.foldingStopMarker))[3]){if("keyword"===s.getTokenAt(i,t.index+1).type)return"end"}else{if(!t[1])return"end";if("comment.multiline"===s.getTokenAt(i,t.index+1).type)return"end"}},this.getFoldWidgetRange=function(s,o,i){var n,r=s.doc.getLine(i);return(n=this.foldingStartMarker.exec(r))?n[1]||n[3]?this.rubyBlock(s,i,n.index+2):this.openingBracketBlock(s,"{",i,n.index):(n=this.foldingStopMarker.exec(r))?"end"===n[3]&&"keyword"===s.getTokenAt(i,n.index+1).type||"=end"===n[1]&&"comment.multiline"===s.getTokenAt(i,n.index+1).type?this.rubyBlock(s,i,n.index+1):this.closingBracketBlock(s,"}",i,n.index+n[0].length):void 0},this.rubyBlock=function(s,C,i,r){var n=new u(s,C,i),e=n.getCurrentToken();if(e&&("keyword"==e.type||"comment.multiline"==e.type)){var t=e.value,a=s.getLine(C);switch(e.value){case"if":case"unless":case"while":case"until":if(!new RegExp("^\\s*"+e.value).test(a))return;var p=this.indentKeywords[t];break;case"when":if(/\sthen\s/.test(a))return;case"elsif":case"rescue":case"ensure":p=1;break;case"else":if(!new RegExp("^\\s*"+e.value+"\\s*$").test(a))return;p=1;break;default:p=this.indentKeywords[t]}var v=[t];if(p){var y=-1===p?s.getLine(C-1).length:s.getLine(C).length,w=C,T=[];if(T.push(n.getCurrentTokenRange()),n.step=-1===p?n.stepBackward:n.stepForward,"comment.multiline"==e.type){for(;e=n.step();)if("comment.multiline"===e.type)if(1==p){if(y=6,"=end"==e.value)break}else if("=begin"==e.value)break}else for(;e=n.step();){var f=!1;if("keyword"===e.type){var k=p*this.indentKeywords[e.value];switch(a=s.getLine(n.getCurrentTokenRow()),e.value){case"do":for(var g=n.$tokenIndex-1;g>=0;g--){var R=n.$rowTokens[g];if(R&&("while"==R.value||"until"==R.value||"for"==R.value)){k=0;break}}break;case"else":(!new RegExp("^\\s*"+e.value+"\\s*$").test(a)||"case"==t)&&(k=0,f=!0);break;case"if":case"unless":case"while":case"until":new RegExp("^\\s*"+e.value).test(a)||(k=0,f=!0);break;case"when":(/\sthen\s/.test(a)||"case"==t)&&(k=0,f=!0)}if(k>0)v.unshift(e.value);else if(k<=0&&!1===f){if(v.shift(),!v.length&&(("while"==t||"until"==t||"for"==t)&&"do"!=e.value||"do"==e.value&&-1==p&&0!=k||"do"!=e.value))break;0===k&&v.unshift(e.value)}}}if(!e)return null;if(r)return T.push(n.getCurrentTokenRange()),T;if(C=n.getCurrentTokenRow(),-1===p){if("comment.multiline"===e.type)var M=6;else M=s.getLine(C).length;return new m(C,M,w-1,y)}return new m(w,y,C-1,s.getLine(C-1).length)}}}}.call(l.prototype)}),ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/folding/ruby"],function(c,h,_){"use strict";var x=c("../lib/oop"),b=c("./text").Mode,m=c("./ruby_highlight_rules").RubyHighlightRules,u=c("./matching_brace_outdent").MatchingBraceOutdent,l=c("../range").Range,s=c("./folding/ruby").FoldMode,o=function(){this.HighlightRules=m,this.$outdent=new u,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new s,this.indentKeywords=this.foldingRules.indentKeywords};x.inherits(o,b),function(){this.lineCommentStart="#",this.getNextLineIndent=function(i,r,n){var e=this.$getIndent(r),a=this.getTokenizer().getLineTokens(r,i).tokens;if(a.length&&"comment"==a[a.length-1].type)return e;if("start"==i){var d=r.match(/^.*[\{\(\[]\s*$/),p=r.match(/^\s*(class|def|module)\s.*$/),v=r.match(/.*do(\s*|\s+\|.*\|\s*)$/),y=r.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);(d||p||v||y)&&(e+=n)}return e},this.checkOutdent=function(i,r,n){return/^\s+(end|else|rescue|ensure)$/.test(r+n)||this.$outdent.checkOutdent(r,n)},this.autoOutdent=function(i,r,n){var e=r.getLine(n);if(/}/.test(e))return this.$outdent.autoOutdent(r,n);var t=this.$getIndent(e),a=r.getLine(n-1),d=this.$getIndent(a),p=r.getTabString();d.length<=t.length&&t.slice(-p.length)==p&&r.remove(new l(n,t.length-p.length,n,t.length))},this.getMatching=function(i,r,n){if(null==r){var e=i.selection.lead;n=e.column,r=e.row}var t=i.getTokenAt(r,n);if(t&&t.value in this.indentKeywords)return this.foldingRules.rubyBlock(i,r,n,!0)},this.$id="ace/mode/ruby",this.snippetFileId="ace/snippets/ruby"}.call(o.prototype),h.Mode=o}),ace.define("ace/mode/ejs",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules","ace/lib/oop","ace/mode/html","ace/mode/javascript","ace/mode/css","ace/mode/ruby"],function(c,h,_){"use strict";var u=c("../lib/oop"),x=c("./html_highlight_rules").HtmlHighlightRules,b=c("./javascript_highlight_rules").JavaScriptHighlightRules,m=function(n,e){for(var t in x.call(this),n||(n="(?:<%|<\\?|{{)"),e||(e="(?:%>|\\?>|}})"),this.$rules)this.$rules[t].unshift({token:"markup.list.meta.tag",regex:n+"(?![>}])[-=]?",push:"ejs-start"});this.embedRules(new b({jsx:!1}).getRules(),"ejs-",[{token:"markup.list.meta.tag",regex:"-?"+e,next:"pop"},{token:"comment",regex:"//.*?"+e,next:"pop"}]),this.normalizeRules()};u.inherits(m,x),h.EjsHighlightRules=m,u=c("../lib/oop");var l=c("./html").Mode,s=c("./javascript").Mode,o=c("./css").Mode,r=(c("./ruby"),function(){l.call(this),this.HighlightRules=m,this.createModeDelegates({"js-":s,"css-":o,"ejs-":s})});u.inherits(r,l),function(){this.$id="ace/mode/ejs"}.call(r.prototype),h.Mode=r}),ace.require(["ace/mode/ejs"],function(c){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=c)});