ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(l,u,R){"use strict";var v=l("../lib/oop"),g=l("./text_highlight_rules").TextHighlightRules,p=u.reservedKeywords="!|{|}|case|do|done|elif|else|esac|fi|for|if|in|then|until|while|&|;|export|local|read|typeset|unset|elif|select|set|function|declare|readonly",h=u.languageConstructs="[|]|alias|bg|bind|break|builtin|cd|command|compgen|complete|continue|dirs|disown|echo|enable|eval|exec|exit|fc|fg|getopts|hash|help|history|jobs|kill|let|logout|popd|printf|pushd|pwd|return|set|shift|shopt|source|suspend|test|times|trap|type|ulimit|umask|unalias|wait",e=function(){var n=this.createKeywordMapper({keyword:p,"support.function.builtin":h,"invalid.deprecated":"debugger"},"identifier"),r="(?:\\d+)",a="(?:(?:"+r+"?(?:\\.\\d+))|(?:"+r+"\\.))",c="[a-zA-Z_][a-zA-Z0-9_]*";this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(k,m,f){var _="-"==k[2]?"indentedHeredoc":"heredoc",x=k.split(this.splitRegex);return f.push(_,x[4]),[{type:"constant",value:x[1]},{type:"text",value:x[2]},{type:"string",value:x[3]},{type:"support.class",value:x[4]},{type:"string",value:x[5]}]},rules:{heredoc:[{onMatch:function(k,m,f){return k===f[1]?(f.shift(),f.shift(),this.next=f[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^\t+"},{onMatch:function(k,m,f){return k===f[1]?(f.shift(),f.shift(),this.next=f[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(k,m){return"heredoc"===m[0]||"indentedHeredoc"===m[0]?m[0]:k}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:"(?:\\$(?:SHLVL|\\$|\\!|\\?))"},{token:"variable",regex:"(?:"+c+"(?==))"},{include:"variables"},{token:"support.function",regex:"(?:"+c+"\\s*\\(\\))"},{token:"support.function",regex:"(?:&"+r+")"},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:"(?:(?:(?:"+a+"|"+r+"))|"+a+")"},{token:"constant.numeric",regex:"(?:(?:[1-9]\\d*)|(?:0))\\b"},{token:n,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]},this.normalizeRules()};v.inherits(e,g),u.ShHighlightRules=e}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(l,u,R){"use strict";var v=l("../../lib/oop"),g=l("../../range").Range,p=l("./fold_mode").FoldMode,h=u.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};v.inherits(h,p),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,n,i){var s=e.getLine(i);if(this.singleLineBlockCommentRe.test(s)&&!this.startRegionRe.test(s)&&!this.tripleStarBlockCommentRe.test(s))return"";var r=this._getFoldWidgetBase(e,n,i);return!r&&this.startRegionRe.test(s)?"start":r},this.getFoldWidgetRange=function(e,n,i,s){var t,r=e.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(e,r,i);if(t=r.match(this.foldingStartMarker)){var a=t.index;if(t[1])return this.openingBracketBlock(e,t[1],i,a);var o=e.getCommentFoldRange(i,a+t[0].length,1);return o&&!o.isMultiLine()&&(s?o=this.getSectionRange(e,i):"all"!=n&&(o=null)),o}return"markbegin"!==n&&(t=r.match(this.foldingStopMarker))?(a=t.index+t[0].length,t[1]?this.closingBracketBlock(e,t[1],i,a):e.getCommentFoldRange(i,a,-1)):void 0},this.getSectionRange=function(e,n){for(var i=e.getLine(n),s=i.search(/\S/),r=n,a=i.length,o=n+=1,t=e.getLength();++n<t;){var d=(i=e.getLine(n)).search(/\S/);if(-1!==d){if(s>d)break;var c=this.getFoldWidgetRange(e,"all",n);if(c){if(c.start.row<=r)break;if(c.isMultiLine())n=c.end.row;else if(s==d)break}o=n}}return new g(r,a,o,e.getLine(o).length)},this.getCommentRegionBlock=function(e,n,i){for(var s=n.search(/\s*$/),r=e.getLength(),a=i,o=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++i<r;){n=e.getLine(i);var d=o.exec(n);if(d&&(d[1]?t--:t++,!t))break}if(i>a)return new g(a,s,i,n.length)}}.call(h.prototype)}),ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle"],function(l,u,R){"use strict";var v=l("../lib/oop"),g=l("./text").Mode,p=l("./sh_highlight_rules").ShHighlightRules,h=l("../range").Range,e=l("./folding/cstyle").FoldMode,n=function(){this.HighlightRules=p,this.foldingRules=new e,this.$behaviour=this.$defaultBehaviour};v.inherits(n,g),function(){this.lineCommentStart="#",this.getNextLineIndent=function(s,r,a){var o=this.$getIndent(r),d=this.getTokenizer().getLineTokens(r,s).tokens;return d.length&&"comment"==d[d.length-1].type||"start"==s&&r.match(/^.*[\{\(\[:]\s*$/)&&(o+=a),o};var i={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(s,r,a){if("\r\n"!==a&&"\r"!==a&&"\n"!==a)return!1;var o=this.getTokenizer().getLineTokens(r.trim(),s).tokens;if(!o)return!1;do{var t=o.pop()}while(t&&("comment"==t.type||"text"==t.type&&t.value.match(/^\s+$/)));return!!t&&"keyword"==t.type&&i[t.value]},this.autoOutdent=function(s,r,a){var o=this.$getIndent(r.getLine(a+=1)),t=r.getTabString();o.slice(-t.length)==t&&r.remove(new h(a,o.length-t.length,a,o.length))},this.$id="ace/mode/sh",this.snippetFileId="ace/snippets/sh"}.call(n.prototype),u.Mode=n}),ace.define("ace/mode/dockerfile_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/sh_highlight_rules"],function(l,u,R){"use strict";var v=l("../lib/oop"),g=l("./sh_highlight_rules").ShHighlightRules,p=function(){g.call(this);for(var h=this.$rules.start,e=0;e<h.length;e++)if("variable.language"==h[e].token){h.splice(e,0,{token:"constant.language",regex:"(?:^(?:FROM|MAINTAINER|RUN|CMD|EXPOSE|ENV|ADD|ENTRYPOINT|VOLUME|USER|WORKDIR|ONBUILD|COPY|LABEL)\\b)",caseInsensitive:!0});break}};v.inherits(p,g),u.DockerfileHighlightRules=p}),ace.define("ace/mode/dockerfile",["require","exports","module","ace/lib/oop","ace/mode/sh","ace/mode/dockerfile_highlight_rules","ace/mode/folding/cstyle"],function(l,u,R){"use strict";var v=l("../lib/oop"),g=l("./sh").Mode,p=l("./dockerfile_highlight_rules").DockerfileHighlightRules,h=l("./folding/cstyle").FoldMode,e=function(){g.call(this),this.HighlightRules=p,this.foldingRules=new h};v.inherits(e,g),function(){this.$id="ace/mode/dockerfile"}.call(e.prototype),u.Mode=e}),ace.require(["ace/mode/dockerfile"],function(l){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=l)});