ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(f,_,U){"use strict";var A=f("./lib/dom"),T=f("./lib/oop"),y=f("./lib/event_emitter").EventEmitter,v=f("./lib/lang"),g=f("./range").Range,b=f("./range_list").RangeList,$=f("./keyboard/hash_handler").HashHandler,x=f("./tokenizer").Tokenizer,E=f("./clipboard"),N={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,i,n){var t=e.session.getTextRange();return n?t.replace(/\n\r?([ \t]*\S)/g,"\n"+n+"$1"):t},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return E.getText&&E.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var i=e.session.$mode||{};return i.blockComment&&i.blockComment.start||""},BLOCK_COMMENT_END:function(e){var i=e.session.$mode||{};return i.blockComment&&i.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:S.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:S.bind(null,{year:"2-digit"}),CURRENT_MONTH:S.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:S.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:S.bind(null,{month:"short"}),CURRENT_DATE:S.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:S.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:S.bind(null,{weekday:"short"}),CURRENT_HOUR:S.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:S.bind(null,{minute:"2-digit"}),CURRENT_SECOND:S.bind(null,{second:"2-digit"})};function S(e){var i=(new Date).toLocaleString("en-us",e);return 1==i.length?"0"+i:i}N.SELECTED_TEXT=N.SELECTION;var L=function(){function e(){this.snippetMap={},this.snippetNameMap={},this.variables=N}return e.prototype.getTokenizer=function(){return e.$tokenizer||this.createTokenizer()},e.prototype.createTokenizer=function(){function i(o){return o=o.substr(1),/^\d+$/.test(o)?[{tabstopId:parseInt(o,10)}]:[{text:o}]}function n(o){return"(?:[^\\\\"+o+"]|\\\\.)"}var t={regex:"/("+n("/")+"+)/",onMatch:function(o,l,c){var a=c[0];return a.fmtString=!0,a.guard=o.slice(1,-1),a.flag="",""},next:"formatString"};return e.$tokenizer=new x({start:[{regex:/\\./,onMatch:function(o,l,c){var a=o[1];return("}"==a&&c.length||-1!="`$\\".indexOf(a))&&(o=a),[o]}},{regex:/}/,onMatch:function(o,l,c){return[c.length?c.shift():o]}},{regex:/\$(?:\d+|\w+)/,onMatch:i},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(o,l,c){var a=i(o.substr(1));return c.unshift(a[0]),a},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+n("\\|")+"*\\|",onMatch:function(o,l,c){var a=o.slice(1,-1).replace(/\\[,|\\]|,/g,function(p){return 2==p.length?p[1]:"\0"}).split("\0").map(function(p){return{value:p}});return c[0].choices=a,[a[0]]},next:"start"},t,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(o,l,c){return c.length&&c[0].expectElse?(c[0].expectElse=!1,c[0].ifEnd={elseEnd:c[0]},[c[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(o,l,c){var a=o[1];return"}"==a&&c.length||-1!="`$\\".indexOf(a)?o=a:"n"==a?o="\n":"t"==a?o="\t":-1!="ulULE".indexOf(a)&&(o={changeCase:a,local:a>"a"}),[o]}},{regex:"/\\w*}",onMatch:function(o,l,c){var a=c.shift();return a&&(a.flag=o.slice(1,-1)),this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(o,l,c){return[{text:o.slice(1)}]}},{regex:/\${\w+/,onMatch:function(o,l,c){var a={text:o.slice(2)};return c.unshift(a),[a]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(o,l,c){var a=c.shift();return this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(o,l,c){return c[0].formatFunction=o.slice(2,-1),[c.shift()]},next:"formatString"},t,{regex:/:[\?\-+]?/,onMatch:function(o,l,c){"+"==o[1]&&(c[0].ifEnd=c[0]),"?"==o[1]&&(c[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},e.prototype.tokenizeTmSnippet=function(i,n){return this.getTokenizer().getLineTokens(i,n).tokens.map(function(t){return t.value||t})},e.prototype.getVariableValue=function(i,n,t){if(/^\d+$/.test(n))return(this.variables.__||{})[n]||"";if(/^[A-Z]\d+$/.test(n))return(this.variables[n[0]+"__"]||{})[n.substr(1)]||"";if(n=n.replace(/^TM_/,""),!this.variables.hasOwnProperty(n))return"";var o=this.variables[n];return"function"==typeof o&&(o=this.variables[n](i,n,t)),o??""},e.prototype.tmStrFormat=function(i,n,t){if(!n.fmt)return i;var l=n.guard;l=new RegExp(l,(n.flag||"").replace(/[^gim]/g,""));var c="string"==typeof n.fmt?this.tokenizeTmSnippet(n.fmt,"formatString"):n.fmt,a=this,p=i.replace(l,function(){var s=a.variables.__;a.variables.__=[].slice.call(arguments);for(var h=a.resolveVariables(c,t),m="E",d=0;d<h.length;d++){var w=h[d];if("object"==typeof w)if(h[d]="",w.changeCase&&w.local){var C=h[d+1];C&&"string"==typeof C&&(h[d]="u"==w.changeCase?C[0].toUpperCase():C[0].toLowerCase(),h[d+1]=C.substr(1))}else w.changeCase&&(m=w.changeCase);else"U"==m?h[d]=w.toUpperCase():"L"==m&&(h[d]=w.toLowerCase())}return a.variables.__=s,h.join("")});return p},e.prototype.tmFormatFunction=function(i,n,t){return"upcase"==n.formatFunction?i.toUpperCase():"downcase"==n.formatFunction?i.toLowerCase():i},e.prototype.resolveVariables=function(i,n){for(var t=[],o="",l=!0,c=0;c<i.length;c++){var a=i[c];if("string"!=typeof a){if(a){if(l=!1,a.fmtString){var p=i.indexOf(a,c+1);-1==p&&(p=i.length),a.fmt=i.slice(c+1,p),c=p}if(a.text){var s=this.getVariableValue(n,a.text,o)+"";a.fmtString&&(s=this.tmStrFormat(s,a,n)),a.formatFunction&&(s=this.tmFormatFunction(s,a,n)),s&&!a.ifEnd?(t.push(s),h(a)):!s&&a.ifEnd&&h(a.ifEnd)}else a.elseEnd?h(a.elseEnd):(null!=a.tabstopId||null!=a.changeCase)&&t.push(a)}}else t.push(a),"\n"==a?(l=!0,o=""):l&&(o=/^\t*/.exec(a)[0],l=/\S/.test(a))}function h(m){var d=i.indexOf(m,c+1);-1!=d&&(c=d)}return t},e.prototype.getDisplayTextForSnippet=function(i,n){return O.call(this,i,n).text},e.prototype.insertSnippetForSelection=function(i,n,t){void 0===t&&(t={});var o=O.call(this,i,n,t),l=i.getSelectionRange(),c=i.session.replace(l,o.text);new P(i).addTabstops(o.tabstops,l.start,c,i.inVirtualSelectionMode&&i.selection.index)},e.prototype.insertSnippet=function(i,n,t){void 0===t&&(t={});var o=this;if(i.inVirtualSelectionMode)return o.insertSnippetForSelection(i,n,t);i.forEachSelection(function(){o.insertSnippetForSelection(i,n,t)},null,{keepOrder:!0}),i.tabstopManager&&i.tabstopManager.tabNext()},e.prototype.$getScope=function(i){var n=i.session.$mode.$id||"";if("html"===(n=n.split("/").pop())||"php"===n){"php"===n&&!i.session.$mode.inlinePhp&&(n="html");var t=i.getCursorPosition(),o=i.session.getState(t.row);"object"==typeof o&&(o=o[0]),o.substring&&("js-"==o.substring(0,3)?n="javascript":"css-"==o.substring(0,4)?n="css":"php-"==o.substring(0,4)&&(n="php"))}return n},e.prototype.getActiveScopes=function(i){var n=this.$getScope(i),t=[n],o=this.snippetMap;return o[n]&&o[n].includeScopes&&t.push.apply(t,o[n].includeScopes),t.push("_"),t},e.prototype.expandWithTab=function(i,n){var t=this,o=i.forEachSelection(function(){return t.expandSnippetForSelection(i,n)},null,{keepOrder:!0});return o&&i.tabstopManager&&i.tabstopManager.tabNext(),o},e.prototype.expandSnippetForSelection=function(i,n){var p,t=i.getCursorPosition(),o=i.session.getLine(t.row),l=o.substring(0,t.column),c=o.substr(t.column),a=this.snippetMap;return this.getActiveScopes(i).some(function(s){var h=a[s];return h&&(p=this.findMatchingSnippet(h,l,c)),!!p},this),!!p&&(n&&n.dryRun||(i.session.doc.removeInLine(t.row,t.column-p.replaceBefore.length,t.column+p.replaceAfter.length),this.variables.M__=p.matchBefore,this.variables.T__=p.matchAfter,this.insertSnippetForSelection(i,p.content),this.variables.M__=this.variables.T__=null),!0)},e.prototype.findMatchingSnippet=function(i,n,t){for(var o=i.length;o--;){var l=i[o];if((!l.startRe||l.startRe.test(n))&&(!l.endRe||l.endRe.test(t))&&(l.startRe||l.endRe))return l.matchBefore=l.startRe?l.startRe.exec(n):[""],l.matchAfter=l.endRe?l.endRe.exec(t):[""],l.replaceBefore=l.triggerRe?l.triggerRe.exec(n)[0]:"",l.replaceAfter=l.endTriggerRe?l.endTriggerRe.exec(t)[0]:"",l}},e.prototype.register=function(i,n){var t=this.snippetMap,o=this.snippetNameMap,l=this;function c(s){return s&&!/^\^?\(.*\)\$?$|^\\b$/.test(s)&&(s="(?:"+s+")"),s||""}function a(s,h,m){return s=c(s),h=c(h),m?(s=h+s)&&"$"!=s[s.length-1]&&(s+="$"):(s+=h)&&"^"!=s[0]&&(s="^"+s),new RegExp(s)}function p(s){s.scope||(s.scope=n||"_"),t[n=s.scope]||(t[n]=[],o[n]={});var h=o[n];if(s.name){var m=h[s.name];m&&l.unregister(m),h[s.name]=s}t[n].push(s),s.prefix&&(s.tabTrigger=s.prefix),!s.content&&s.body&&(s.content=Array.isArray(s.body)?s.body.join("\n"):s.body),s.tabTrigger&&!s.trigger&&(!s.guard&&/^\w/.test(s.tabTrigger)&&(s.guard="\\b"),s.trigger=v.escapeRegExp(s.tabTrigger)),(s.trigger||s.guard||s.endTrigger||s.endGuard)&&(s.startRe=a(s.trigger,s.guard,!0),s.triggerRe=new RegExp(s.trigger),s.endRe=a(s.endTrigger,s.endGuard,!0),s.endTriggerRe=new RegExp(s.endTrigger))}i||(i=[]),Array.isArray(i)?i.forEach(p):Object.keys(i).forEach(function(s){p(i[s])}),this._signal("registerSnippets",{scope:n})},e.prototype.unregister=function(i,n){var t=this.snippetMap,o=this.snippetNameMap;function l(c){var a=o[c.scope||n];if(a&&a[c.name]){delete a[c.name];var p=t[c.scope||n],s=p&&p.indexOf(c);s>=0&&p.splice(s,1)}}i.content?l(i):Array.isArray(i)&&i.forEach(l)},e.prototype.parseSnippetFile=function(i){i=i.replace(/\r/g,"");for(var l,n=[],t={},o=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;l=o.exec(i);){if(l[1])try{t=JSON.parse(l[1]),n.push(t)}catch{}if(l[4])t.content=l[4].replace(/^\t/gm,""),n.push(t),t={};else{var c=l[2],a=l[3];if("regex"==c){var p=/\/((?:[^\/\\]|\\.)*)|$/g;t.guard=p.exec(a)[1],t.trigger=p.exec(a)[1],t.endTrigger=p.exec(a)[1],t.endGuard=p.exec(a)[1]}else"snippet"==c?(t.tabTrigger=a.match(/^\S*/)[0],t.name||(t.name=a)):c&&(t[c]=a)}}return n},e.prototype.getSnippetByName=function(i,n){var o,t=this.snippetNameMap;return this.getActiveScopes(n).some(function(l){var c=t[l];return c&&(o=c[i]),!!o},this),o},e}();T.implement(L.prototype,y);var O=function(e,i,n){void 0===n&&(n={});var t=e.getCursorPosition(),o=e.session.getLine(t.row),l=e.session.getTabString(),c=o.match(/^\s*/)[0];t.column<c.length&&(c=c.slice(0,t.column)),i=i.replace(/\r/g,"");var a=this.tokenizeTmSnippet(i);a=(a=this.resolveVariables(a,e)).map(function(R){return"\n"!=R||n.excludeExtraIndent?"string"==typeof R?R.replace(/\t/g,l):R:R+c});var p=[];a.forEach(function(R,F){if("object"==typeof R){var B=R.tabstopId,H=p[B];if(H||((H=p[B]=[]).index=B,H.value="",H.parents={}),-1===H.indexOf(R)){R.choices&&!H.choices&&(H.choices=R.choices),H.push(R);var V=a.indexOf(R,F+1);if(-1!==V){var j=a.slice(F+1,V);j.some(function(K){return"object"==typeof K})&&!H.value?H.value=j:j.length&&(!H.value||"string"!=typeof H.value)&&(H.value=j.join(""))}}}}),p.forEach(function(R){R.length=0});var s={};function h(R){for(var F=[],B=0;B<R.length;B++){var H=R[B];if("object"==typeof H){if(s[H.tabstopId])continue;H=F[R.lastIndexOf(H,B-1)]||{tabstopId:H.tabstopId}}F[B]=H}return F}for(var m=0;m<a.length;m++){var d=a[m];if("object"==typeof d){var w=d.tabstopId,C=p[w],k=a.indexOf(d,m+1);if(s[w]){s[w]===d&&(delete s[w],Object.keys(s).forEach(function(R){C.parents[R]=!0}));continue}s[w]=d;var I=C.value;"string"!=typeof I?I=h(I):d.fmt&&(I=this.tmStrFormat(I,d,e)),a.splice.apply(a,[m+1,Math.max(0,k-m)].concat(I,d)),-1===C.indexOf(d)&&C.push(d)}}var z=0,D=0,W="";return a.forEach(function(R){if("string"==typeof R){var F=R.split("\n");F.length>1?(D=F[F.length-1].length,z+=F.length-1):D+=R.length,W+=R}else R&&(R.start?R.end={row:z,column:D}:R.start={row:z,column:D})}),{text:W,tabstops:p,tokens:a}},P=function(){function e(i){if(this.index=0,this.ranges=[],this.tabstops=[],i.tabstopManager)return i.tabstopManager;i.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=v.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(i)}return e.prototype.attach=function(i){this.$openTabstops=null,this.selectedTabstop=null,this.editor=i,this.session=i.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},e.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},e.prototype.onChange=function(i){for(var n="r"==i.action[0],t=this.selectedTabstop||{},o=t.parents||{},l=this.tabstops.slice(),c=0;c<l.length;c++){var a=l[c];if(a.rangeList.$bias=a==t||o[a.index]?0:1,"remove"==i.action&&a!==t){var s=a.parents&&a.parents[t.index],h=a.rangeList.pointIndex(i.start,s);h=h<0?-h-1:h+1;for(var m=a.rangeList.pointIndex(i.end,s),d=a.rangeList.ranges.slice(h,m=m<0?-m-1:m-1),w=0;w<d.length;w++)this.removeRange(d[w])}a.rangeList.$onChange(i)}var C=this.session;!this.$inChange&&n&&1==C.getLength()&&!C.getValue()&&this.detach()},e.prototype.updateLinkedFields=function(){var i=this.selectedTabstop;if(i&&i.hasLinkedRanges&&i.firstNonLinked){this.$inChange=!0;for(var n=this.session,t=n.getTextRange(i.firstNonLinked),o=0;o<i.length;o++){var l=i[o];if(l.linked){var a=_.snippetManager.tmStrFormat(t,l.original,this.editor);n.replace(l,a)}}this.$inChange=!1}},e.prototype.onAfterExec=function(i){i.command&&!i.command.readOnly&&this.updateLinkedFields()},e.prototype.onChangeSelection=function(){if(this.editor){for(var i=this.editor.selection.lead,n=this.editor.selection.anchor,t=this.editor.selection.isEmpty(),o=0;o<this.ranges.length;o++)if(!this.ranges[o].linked){var l=this.ranges[o].contains(i.row,i.column),c=t||this.ranges[o].contains(n.row,n.column);if(l&&c)return}this.detach()}},e.prototype.onChangeSession=function(){this.detach()},e.prototype.tabNext=function(i){var n=this.tabstops.length,t=this.index+(i||1);(t=Math.min(Math.max(t,1),n))==n&&(t=0),this.selectTabstop(t),this.updateTabstopMarkers(),0===t&&this.detach()},e.prototype.selectTabstop=function(i){this.$openTabstops=null;var n=this.tabstops[this.index];if(n&&this.addTabstopMarkers(n),this.index=i,(n=this.tabstops[this.index])&&n.length){this.selectedTabstop=n;var t=n.firstNonLinked||n;if(n.choices&&(t.cursor=t.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(t);else{var o=this.editor.multiSelect;o.toSingleRange(t);for(var l=0;l<n.length;l++)n.hasLinkedRanges&&n[l].linked||o.addRange(n[l].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},e.prototype.addTabstops=function(i,n,t){var o=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!i[0]){var l=g.fromPoints(t,t);u(l.start,n),u(l.end,n),i[0]=[l],i[0].index=0}var a=[this.index+1,0],p=this.ranges,s=this.snippetId=(this.snippetId||0)+1;i.forEach(function(h,m){var d=this.$openTabstops[m]||h;d.snippetId=s;for(var w=0;w<h.length;w++){var C=h[w],k=g.fromPoints(C.start,C.end||C.start);M(k.start,n),M(k.end,n),k.original=C,k.tabstop=d,p.push(k),d!=h?d.unshift(k):d[w]=k,C.fmtString||d.firstNonLinked&&o?(k.linked=!0,d.hasLinkedRanges=!0):d.firstNonLinked||(d.firstNonLinked=k)}d.firstNonLinked||(d.hasLinkedRanges=!1),d===h&&(a.push(d),this.$openTabstops[m]=d),this.addTabstopMarkers(d),d.rangeList=d.rangeList||new b,d.rangeList.$bias=0,d.rangeList.addList(d)},this),a.length>2&&(this.tabstops.length&&a.push(a.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,a))},e.prototype.addTabstopMarkers=function(i){var n=this.session;i.forEach(function(t){t.markerId||(t.markerId=n.addMarker(t,"ace_snippet-marker","text"))})},e.prototype.removeTabstopMarkers=function(i){var n=this.session;i.forEach(function(t){n.removeMarker(t.markerId),t.markerId=null})},e.prototype.updateTabstopMarkers=function(){if(this.selectedTabstop){var i=this.selectedTabstop.snippetId;0===this.selectedTabstop.index&&i--,this.tabstops.forEach(function(n){n.snippetId===i?this.addTabstopMarkers(n):this.removeTabstopMarkers(n)},this)}},e.prototype.removeRange=function(i){var n=i.tabstop.indexOf(i);-1!=n&&i.tabstop.splice(n,1),-1!=(n=this.ranges.indexOf(i))&&this.ranges.splice(n,1),-1!=(n=i.tabstop.rangeList.ranges.indexOf(i))&&i.tabstop.splice(n,1),this.session.removeMarker(i.markerId),i.tabstop.length||(-1!=(n=this.tabstops.indexOf(i.tabstop))&&this.tabstops.splice(n,1),this.tabstops.length||this.detach())},e}();P.prototype.keyboardHandler=new $,P.prototype.keyboardHandler.bindKeys({Tab:function(e){_.snippetManager&&_.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var M=function(e,i){0==e.row&&(e.column+=i.column),e.row+=i.row},u=function(e,i){e.row==i.row&&(e.column-=i.column),e.row-=i.row};A.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),_.snippetManager=new L;var r=f("./editor").Editor;(function(){this.insertSnippet=function(e,i){return _.snippetManager.insertSnippet(this,e,i)},this.expandSnippet=function(e){return _.snippetManager.expandWithTab(this,e)}}).call(r.prototype)}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(f,_,U){"use strict";var A=function(){function T(y){this.editor=y,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return T.prototype.setScreenReaderContent=function(y){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var g=this.popup.getRow(),b=this.popup.renderer.$textLayer,$=b.element.childNodes[g-b.config.firstRow];if($){for(var x="doc-tooltip ",E=0;E<this._lines.length;E++)x+="ace-inline-screenreader-line-".concat(E," ");$.setAttribute("aria-describedby",x)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=y.split(/\r\n|\r|\n/);var v=this.createCodeBlock();this.screenReaderDiv.appendChild(v)},T.prototype.destroy=function(){this.screenReaderDiv.remove()},T.prototype.createCodeBlock=function(){var y=document.createElement("pre");y.setAttribute("id","ace-inline-screenreader");for(var v=0;v<this._lines.length;v++){var g=document.createElement("code");g.setAttribute("id","ace-inline-screenreader-line-".concat(v));var b=document.createTextNode(this._lines[v]);g.appendChild(b),y.appendChild(g)}return y},T}();_.AceInlineScreenReader=A}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(f,_,U){"use strict";var A=f("../snippets").snippetManager,T=f("./inline_screenreader").AceInlineScreenReader,y=function(){function v(){this.editor=null}return v.prototype.show=function(g,b,$){if($=$||"",g&&this.editor&&this.editor!==g&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!g||!b)return!1;this.inlineScreenReader||(this.inlineScreenReader=new T(g));var x=b.snippet?A.getDisplayTextForSnippet(g,b.snippet):b.value;return!(b.hideInlinePreview||!x||!x.startsWith($)||(this.editor=g,this.inlineScreenReader.setScreenReaderContent(x),""===(x=x.slice($.length))?g.removeGhostText():g.setGhostText(x),0))},v.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},v.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},v.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},v}();_.AceInline=y}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(f,_,U){"use strict";var A=f("../virtual_renderer").VirtualRenderer,T=f("../editor").Editor,y=f("../range").Range,v=f("../lib/event"),g=f("../lib/lang"),b=f("../lib/dom"),$=f("../config").nls,x=f("./../lib/useragent"),E=function(M){return"suggest-aria-id:".concat(M)},N=x.isSafari?"menu":"listbox",S=x.isSafari?"menuitem":"option",L=x.isSafari?"aria-current":"aria-selected",O=function(M){var u=new A(M);u.$maxLines=4;var r=new T(u);return r.setHighlightActiveLine(!1),r.setShowPrintMargin(!1),r.renderer.setShowGutter(!1),r.renderer.setHighlightGutterLine(!1),r.$mouseHandler.$focusTimeout=0,r.$highlightTagPending=!0,r},P=function(){return function M(u){var r=b.createElement("div"),e=O(r);u&&u.appendChild(r),r.style.display="none",e.renderer.content.style.cursor="default",e.renderer.setStyle("ace_autocomplete"),e.renderer.$textLayer.element.setAttribute("role",N),e.renderer.$textLayer.element.setAttribute("aria-roledescription",$("autocomplete.popup.aria-roledescription","Autocomplete suggestions")),e.renderer.$textLayer.element.setAttribute("aria-label",$("autocomplete.popup.aria-label","Autocomplete suggestions")),e.renderer.textarea.setAttribute("aria-hidden","true"),e.setOption("displayIndentGuides",!1),e.setOption("dragDelay",150);var i=function(){};e.focus=i,e.$isFocused=!0,e.renderer.$cursorLayer.restartTimer=i,e.renderer.$cursorLayer.element.style.opacity="0",e.renderer.$maxLines=8,e.renderer.$keepTextAreaAtCursor=!1,e.setHighlightActiveLine(!1),e.session.highlight(""),e.session.$searchHighlight.clazz="ace_highlight-marker",e.on("mousedown",function(p){var s=p.getDocumentPosition();e.selection.moveToPosition(s),o.start.row=o.end.row=s.row,p.stop()});var n,t=new y(-1,0,-1,1/0),o=new y(-1,0,-1,1/0);o.id=e.session.addMarker(o,"ace_active-line","fullLine"),e.setSelectOnHover=function(p){p?t.id&&(e.session.removeMarker(t.id),t.id=null):t.id=e.session.addMarker(t,"ace_line-hover","fullLine")},e.setSelectOnHover(!1),e.on("mousemove",function(p){if(n){if(n.x!=p.x||n.y!=p.y){(n=p).scrollTop=e.renderer.scrollTop,e.isMouseOver=!0;var s=n.getDocumentPosition().row;t.start.row!=s&&(t.id||e.setRow(s),c(s))}}else n=p}),e.renderer.on("beforeRender",function(){if(n&&-1!=t.start.row){n.$pos=null;var p=n.getDocumentPosition().row;t.id||e.setRow(p),c(p,!0)}}),e.renderer.on("afterRender",function(){for(var p=e.renderer.$textLayer,s=p.config.firstRow,h=p.config.lastRow;s<=h;s++){var m=p.element.childNodes[s-p.config.firstRow];m.setAttribute("role",S),m.setAttribute("aria-roledescription",$("autocomplete.popup.item.aria-roledescription","item")),m.setAttribute("aria-setsize",e.data.length),m.setAttribute("aria-describedby","doc-tooltip"),m.setAttribute("aria-posinset",s+1);var d=e.getData(s);if(d){var w="".concat(d.caption||d.value).concat(d.meta?", ".concat(d.meta):"");m.setAttribute("aria-label",w)}m.querySelectorAll(".ace_completion-highlight").forEach(function(k){k.setAttribute("role","mark")})}}),e.renderer.on("afterRender",function(){var p=e.getRow(),s=e.renderer.$textLayer,h=s.element.childNodes[p-s.config.firstRow],m=document.activeElement;if(h!==e.selectedNode&&e.selectedNode&&(b.removeCssClass(e.selectedNode,"ace_selected"),e.selectedNode.removeAttribute(L),e.selectedNode.removeAttribute("id")),m.removeAttribute("aria-activedescendant"),e.selectedNode=h,h){var d=E(p);b.addCssClass(h,"ace_selected"),h.id=d,s.element.setAttribute("aria-activedescendant",d),m.setAttribute("aria-activedescendant",d),h.setAttribute(L,"true")}});var l=function(){c(-1)},c=function(p,s){p!==t.start.row&&(t.start.row=t.end.row=p,s||e.session._emit("changeBackMarker"),e._emit("changeHoverMarker"))};e.getHoveredRow=function(){return t.start.row},v.addListener(e.container,"mouseout",function(){e.isMouseOver=!1,l()}),e.on("hide",l),e.on("changeSelection",l),e.session.doc.getLength=function(){return e.data.length},e.session.doc.getLine=function(p){var s=e.data[p];return"string"==typeof s?s:s&&s.value||""};var a=e.session.bgTokenizer;return a.$tokenizeRow=function(p){var s=e.data[p],h=[];if(!s)return h;"string"==typeof s&&(s={value:s});var m=s.caption||s.value||s.name;function d(R,F){R&&h.push({type:(s.className||"")+(F||""),value:R})}for(var w=m.toLowerCase(),C=(e.filterText||"").toLowerCase(),k=0,I=0,z=0;z<=C.length;z++)if(z!=I&&(s.matchMask&1<<z||z==C.length)){var D=C.slice(I,z);I=z;var W=w.indexOf(D,k);if(-1==W)continue;d(m.slice(k,W),""),d(m.slice(W,k=W+D.length),"completion-highlight")}return d(m.slice(k,m.length),""),h.push({type:"completion-spacer",value:" "}),s.meta&&h.push({type:"completion-meta",value:s.meta}),s.message&&h.push({type:"completion-message",value:s.message}),h},a.$updateOnChange=i,a.start=i,e.session.$computeWidth=function(){return this.screenWidth=0},e.isOpen=!1,e.isTopdown=!1,e.autoSelect=!0,e.filterText="",e.isMouseOver=!1,e.data=[],e.setData=function(p,s){e.filterText=s||"",e.setValue(g.stringRepeat("\n",p.length),-1),e.data=p||[],e.setRow(0)},e.getData=function(p){return e.data[p]},e.getRow=function(){return o.start.row},e.setRow=function(p){p=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,p)),o.start.row!=p&&(e.selection.clearSelection(),o.start.row=o.end.row=p||0,e.session._emit("changeBackMarker"),e.moveCursorTo(p||0,0),e.isOpen&&e._signal("select"))},e.on("changeSelection",function(){e.isOpen&&e.setRow(e.selection.lead.row),e.renderer.scrollCursorIntoView()}),e.hide=function(){this.container.style.display="none",e.anchorPos=null,e.anchor=null,e.isOpen&&(e.isOpen=!1,this._signal("hide"))},e.tryShow=function(p,s,h,m){if(!m&&e.isOpen&&e.anchorPos&&e.anchor&&e.anchorPos.top===p.top&&e.anchorPos.left===p.left&&e.anchor===h)return!0;var d=this.container,w=this.renderer.scrollBar.width||10,C=window.innerHeight-w,k=window.innerWidth-w,I=this.renderer,z=I.$maxLines*s*1.4,D={top:0,bottom:0,left:0},W=C-p.top-3*this.$borderSize-s,R=p.top-3*this.$borderSize;h||(h=R<=W||W>=z?"bottom":"top"),"top"===h?(D.bottom=p.top-this.$borderSize,D.top=D.bottom-z):"bottom"===h&&(D.top=p.top+s+this.$borderSize,D.bottom=D.top+z);var F=D.top>=0&&D.bottom<=C;if(!m&&!F)return!1;I.$maxPixelHeight=F?null:"top"===h?R:W,"top"===h?(d.style.top="",d.style.bottom=C+w-D.bottom+"px",e.isTopdown=!1):(d.style.top=D.top+"px",d.style.bottom="",e.isTopdown=!0),d.style.display="";var B=p.left;return B+d.offsetWidth>k&&(B=k-d.offsetWidth),d.style.left=B+"px",d.style.right="",e.isOpen||(e.isOpen=!0,this._signal("show"),n=null),e.anchorPos=p,e.anchor=h,!0},e.show=function(p,s,h){this.tryShow(p,s,h?"bottom":void 0,!0)},e.goTo=function(p){var s=this.getRow(),h=this.session.getLength()-1;switch(p){case"up":s=s<=0?h:s-1;break;case"down":s=s>=h?-1:s+1;break;case"start":s=0;break;case"end":s=h}this.setRow(s)},e.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},e.$imageSize=0,e.$borderSize=1,e}}();b.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),_.AcePopup=P,_.$singleLineEditor=O,_.getAriaId=E}),ace.define("ace/autocomplete/util",["require","exports","module"],function(f,_,U){"use strict";_.parForEach=function(T,y,v){var g=0,b=T.length;0===b&&v();for(var $=0;$<b;$++)y(T[$],function(x,E){++g===b&&v(x,E)})};var A=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;_.retrievePrecedingIdentifier=function(T,y,v){v=v||A;for(var g=[],b=y-1;b>=0&&v.test(T[b]);b--)g.push(T[b]);return g.reverse().join("")},_.retrieveFollowingIdentifier=function(T,y,v){v=v||A;for(var g=[],b=y;b<T.length&&v.test(T[b]);b++)g.push(T[b]);return g},_.getCompletionPrefix=function(T){var g,y=T.getCursorPosition(),v=T.session.getLine(y.row);return T.completers.forEach(function(b){b.identifierRegexps&&b.identifierRegexps.forEach(function($){!g&&$&&(g=this.retrievePrecedingIdentifier(v,y.column,$))}.bind(this))}.bind(this)),g||this.retrievePrecedingIdentifier(v,y.column)},_.triggerAutocomplete=function(T,v){return v=v??T.session.getPrecedingCharacter(),T.completers.some(function(g){if(g.triggerCharacters&&Array.isArray(g.triggerCharacters))return g.triggerCharacters.includes(v)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(f,_,U){"use strict";var A=f("./keyboard/hash_handler").HashHandler,T=f("./autocomplete/popup").AcePopup,y=f("./autocomplete/inline").AceInline,v=f("./autocomplete/popup").getAriaId,g=f("./autocomplete/util"),b=f("./lib/lang"),$=f("./lib/dom"),x=f("./snippets").snippetManager,E=f("./config"),N=f("./lib/event"),S=f("./lib/scroll").preventParentScroll,L=function(u,r){r.completer&&r.completer.destroy()},O=function(){function u(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new A,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.hasSeen=new Set,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=b.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=b.delayedCall(this.updateDocTooltip.bind(this),50),this.popupTimer=b.delayedCall(this.$updatePopupPosition.bind(this),50),this.stickySelectionTimer=b.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=b.delayedCall(function(){var r=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!r||0===this.editor.completers.length||(this.completions=new M(u.completionsForLoading),this.openPopup(this.editor,r.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(u,"completionsForLoading",{get:function(){return[{caption:E.nls("autocomplete.loading","Loading..."),value:""}]},enumerable:!1,configurable:!0}),u.prototype.$init=function(){return this.popup=new T(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(r){this.insertMatch(),r.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),N.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this)),this.popup},u.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new y,this.inlineRenderer},u.prototype.getPopup=function(){return this.popup||this.$init()},u.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.popupTimer.cancel(),this.stickySelection=!1},u.prototype.$seen=function(r){!this.hasSeen.has(r)&&r&&r.completer&&r.completer.onSeen&&"function"==typeof r.completer.onSeen&&(r.completer.onSeen(this.editor,r),this.hasSeen.add(r))},u.prototype.$onPopupChange=function(r){if(this.inlineRenderer&&this.inlineEnabled){var e=r?null:this.popup.getData(this.popup.getRow());if(this.$updateGhostText(e),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null);this.popupTimer.schedule(),this.tooltipTimer.schedule()}else this.popupTimer.call(null,null),this.tooltipTimer.call(null,null)},u.prototype.$updateGhostText=function(r){var e=this.base.row,i=this.base.column,n=this.editor.getCursorPosition().column,t=this.editor.session.getLine(e).slice(i,n);this.inlineRenderer.show(this.editor,r,t)?this.$seen(r):this.inlineRenderer.hide()},u.prototype.$onPopupRender=function(){var r=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&this.completions.filtered.length>0)for(var e=this.popup.getFirstVisibleRow();e<=this.popup.getLastVisibleRow();e++){var i=this.popup.getData(e);i&&(!r||i.hideInlinePreview)&&this.$seen(i)}},u.prototype.$onPopupShow=function(r){this.$onPopupChange(r),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},u.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var r=this.editor.container.parentNode,e=[];r;)e.push(r),r.addEventListener("scroll",this.onLayoutChange,{passive:!0}),r=r.parentNode;this.$elements=e}},u.prototype.unObserveLayoutChanges=function(){var r=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(e){e.removeEventListener("scroll",r.onLayoutChange,{passive:!0})}),this.$elements=null},u.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},u.prototype.$updatePopupPosition=function(){var r=this.editor,e=r.renderer,i=e.layerConfig.lineHeight,n=e.$cursorLayer.getPixelPosition(this.base,!0);n.left-=this.popup.getTextLeftOffset();var t=r.container.getBoundingClientRect();n.top+=t.top-e.layerConfig.offset,n.left+=t.left-r.renderer.scrollLeft,n.left+=e.gutterWidth;var o={top:n.top,left:n.left};e.$ghostText&&e.$ghostTextWidget&&this.base.row===e.$ghostText.position.row&&(o.top+=e.$ghostTextWidget.el.offsetHeight);var l=r.container.getBoundingClientRect().bottom-i;this.popup.tryShow(l<o.top?{top:l,left:o.left}:o,i,"bottom")||this.popup.tryShow(n,i,"top")||this.popup.show(n,i)},u.prototype.openPopup=function(r,e,i){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var o,n=this.popup.getRow(),t=this.popup.data[n];if(this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:v(this.popup.getRow()),inline:this.inlineEnabled}),r.keyBinding.addKeyboardHandler(this.keyboardHandler),this.stickySelection&&(o=this.popup.data.indexOf(t)),(!o||-1===o)&&(o=0),this.popup.setRow(this.autoSelect?o:-1),o===n&&t!==this.completions.filtered[o]&&this.$onPopupChange(),o===n&&this.inlineRenderer&&this.inlineEnabled){var c=this.popup.getData(this.popup.getRow());this.$updateGhostText(c)}i||(this.popup.setTheme(r.getTheme()),this.popup.setFontSize(r.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},u.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.popup&&this.popup.renderer&&this.popup.renderer.off("afterRender",this.$onPopupRender),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},u.prototype.changeListener=function(r){var e=this.editor.selection.lead;(e.row!=this.base.row||e.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},u.prototype.blurListener=function(r){var e=document.activeElement,i=this.editor.textInput.getElement(),n=r.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(r.relatedTarget);e!=i&&e.parentNode!=(this.popup&&this.popup.container)&&!n&&e!=this.tooltipNode&&r.relatedTarget!=i&&this.detach()},u.prototype.mousedownListener=function(r){this.detach()},u.prototype.mousewheelListener=function(r){this.popup&&!this.popup.isMouseOver&&this.detach()},u.prototype.mouseOutListener=function(r){this.popup.isOpen&&this.$updatePopupPosition()},u.prototype.goTo=function(r){this.popup.goTo(r)},u.prototype.insertMatch=function(r,e){if(r||(r=this.popup.getData(this.popup.getRow())),!r)return!1;if(""===r.value)return this.detach();var i=this.completions,n=this.getCompletionProvider().insertMatch(this.editor,r,i.filterText,e);return this.completions==i&&this.detach(),n},u.prototype.showPopup=function(r,e){this.editor&&this.detach(),this.activated=!0,this.editor=r,r.completer!=this&&(r.completer&&r.completer.detach(),r.completer=this),r.on("changeSelection",this.changeListener),r.on("blur",this.blurListener),r.on("mousedown",this.mousedownListener),r.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,e)},u.prototype.getCompletionProvider=function(r){return this.completionProvider||(this.completionProvider=new P(r)),this.completionProvider},u.prototype.gatherCompletions=function(r,e){return this.getCompletionProvider().gatherCompletions(r,e)},u.prototype.updateCompletions=function(r,e){if(r&&this.base&&this.completions){var n=this.editor.getCursorPosition();if((t=this.editor.session.getTextRange({start:this.base,end:n}))==this.completions.filterText)return;return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,t,r):this.detach()}if(e&&e.matches)return n=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(n.row,n.column),this.base.$insertRight=!0,this.completions=new M(e.matches),this.getCompletionProvider().completions=this.completions,this.openPopup(this.editor,"",r);var i=this.editor.getSession(),t=(n=this.editor.getCursorPosition(),g.getCompletionPrefix(this.editor));this.base=i.doc.createAnchor(n.row,n.column-t.length),this.base.$insertRight=!0;var o={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:t,pos:n}).provideCompletions(this.editor,o,function(l,c,a){var p=c.filtered,s=g.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),a){if(!p.length){var h=!this.autoShown&&this.emptyMessage;return"function"==typeof h&&(h=this.emptyMessage(s)),h?(this.completions=new M([{caption:h,value:""}]),this.openPopup(this.editor,s,r),this.popup.renderer.setStyle("ace_loading",!1),void this.popup.renderer.setStyle("ace_empty-message",!0)):this.detach()}if(1==p.length&&p[0].value==s&&!p[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==p.length)return this.insertMatch(p[0])}this.completions=!a&&this.showLoadingState?new M(u.completionsForLoading.concat(p),c.filterText):c,this.openPopup(this.editor,s,r),this.popup.renderer.setStyle("ace_empty-message",!1),this.popup.renderer.setStyle("ace_loading",!a)}.bind(this)),this.showLoadingState&&!this.autoShown&&(!this.popup||!this.popup.isOpen)&&this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},u.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},u.prototype.updateDocTooltip=function(){var r=this.popup,e=this.completions&&this.completions.filtered,i=e&&(e[r.getHoveredRow()]||e[r.getRow()]),n=null;if(!i||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var t=this.editor.completers.length,o=0;o<t;o++){var l=this.editor.completers[o];if(l.getDocTooltip&&i.completerId===l.id){n=l.getDocTooltip(i);break}}if(!n&&"string"!=typeof i&&(n=i),"string"==typeof n&&(n={docText:n}),!n||!n.docHTML&&!n.docText)return this.hideDocTooltip();this.showDocTooltip(n)},u.prototype.showDocTooltip=function(r){this.tooltipNode||(this.tooltipNode=$.createElement("div"),this.tooltipNode.style.margin="0",this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.style.overscrollBehavior="contain",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"),this.tooltipNode.addEventListener("wheel",S));var e=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(e.isDark?"ace_dark ":"")+(e.cssClass||"");var i=this.tooltipNode;r.docHTML?i.innerHTML=r.docHTML:r.docText&&(i.textContent=r.docText),i.parentNode||this.popup.container.appendChild(this.tooltipNode);var n=this.popup,t=n.container.getBoundingClientRect(),o=400,l=300,c=n.renderer.scrollBar.width||10,a=t.left,p=window.innerWidth-t.right-c,s=n.isTopdown?t.top:window.innerHeight-c-t.bottom,h=[Math.min(p/o,1),Math.min(a/o,1),Math.min(s/l*.9)],m=Math.max.apply(Math,h),d=i.style;d.display="block",m==h[0]?(d.left=t.right+1+"px",d.right="",d.maxWidth=o*m+"px",d.top=t.top+"px",d.bottom="",d.maxHeight=Math.min(window.innerHeight-c-t.top,l)+"px"):m==h[1]?(d.right=window.innerWidth-t.left+"px",d.left="",d.maxWidth=o*m+"px",d.top=t.top+"px",d.bottom="",d.maxHeight=Math.min(window.innerHeight-c-t.top,l)+"px"):m==h[2]&&(d.left=window.innerWidth-t.left+"px",d.maxWidth=Math.min(o,window.innerWidth)+"px",n.isTopdown?(d.top=t.bottom+"px",d.left=t.left+"px",d.right="",d.bottom="",d.maxHeight=Math.min(window.innerHeight-c-t.bottom,l)+"px"):(d.top=n.container.offsetTop-i.offsetHeight+"px",d.left=t.left+"px",d.right="",d.bottom="",d.maxHeight=Math.min(n.container.offsetTop,l)+"px"))},u.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var r=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==r&&this.editor.focus(),this.tooltipNode=null,r.parentNode&&r.parentNode.removeChild(r)}},u.prototype.onTooltipClick=function(r){for(var e=r.target;e&&e!=this.tooltipNode;){if("A"==e.nodeName&&e.href){e.rel="noreferrer",e.target="_blank";break}e=e.parentNode}},u.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var r=this.popup.container;r&&r.parentNode&&r.parentNode.removeChild(r)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",L),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},u.for=function(r){return r.completer instanceof u||(r.completer&&(r.completer.destroy(),r.completer=null),E.get("sharedPopups")?(u.$sharedInstance||(u.$sharedInstance=new u),r.completer=u.$sharedInstance):(r.completer=new u,r.once("destroy",L))),r.completer},u}();O.prototype.commands={Up:function(u){u.completer.goTo("up")},Down:function(u){u.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(u){u.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(u){u.completer.goTo("end")},Esc:function(u){u.completer.detach()},Return:function(u){return u.completer.insertMatch()},"Shift-Return":function(u){u.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(u){var r=u.completer.insertMatch();if(r||u.tabstopManager)return r;u.completer.goTo("down")},Backspace:function(u){u.execCommand("backspace"),!g.getCompletionPrefix(u)&&u.completer&&u.completer.detach()},PageUp:function(u){u.completer.popup.gotoPageUp()},PageDown:function(u){u.completer.popup.gotoPageDown()}},O.startCommand={name:"startAutocomplete",exec:function(u,r){var e=O.for(u);e.autoInsert=!1,e.autoSelect=!0,e.autoShown=!1,e.showPopup(u,r),e.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var P=function(){function u(r){this.initialPosition=r,this.active=!0}return u.prototype.insertByIndex=function(r,e,i){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(r,this.completions.filtered[e],i)},u.prototype.insertMatch=function(r,e,i){if(!e)return!1;if(r.startOperation({command:{name:"insertMatch"}}),e.completer&&e.completer.insertMatch)e.completer.insertMatch(r,e);else{if(!this.completions)return!1;var n=this.completions.filterText.length,t=0;if(e.range&&e.range.start.row===e.range.end.row&&(n-=this.initialPosition.prefix.length,n+=this.initialPosition.pos.column-e.range.start.column,t+=e.range.end.column-this.initialPosition.pos.column),n||t){var o;o=r.selection.getAllRanges?r.selection.getAllRanges():[r.getSelectionRange()];for(var c,l=0;c=o[l];l++)c.start.column-=n,c.end.column+=t,r.session.remove(c)}e.snippet?x.insertSnippet(r,e.snippet):this.$insertString(r,e),e.completer&&e.completer.onInsert&&"function"==typeof e.completer.onInsert&&e.completer.onInsert(r,e),e.command&&"startAutocomplete"===e.command&&r.execCommand(e.command)}return r.endOperation(),!0},u.prototype.$insertString=function(r,e){r.execCommand("insertstring",e.value||e)},u.prototype.gatherCompletions=function(r,e){var i=r.getSession(),n=r.getCursorPosition(),t=g.getCompletionPrefix(r),o=[];this.completers=r.completers;var l=r.completers.length;return r.completers.forEach(function(c,a){c.getCompletions(r,i,n,t,function(p,s){c.hideInlinePreview&&(s=s.map(function(h){return Object.assign(h,{hideInlinePreview:c.hideInlinePreview})})),!p&&s&&(o=o.concat(s)),e(null,{prefix:g.getCompletionPrefix(r),matches:o,finished:0==--l})})}),!0},u.prototype.provideCompletions=function(r,e,i){var n=function(c){var a=c.prefix;this.completions=new M(c.matches),e.exactMatch&&(this.completions.exactMatch=!0),e.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(a),(c.finished||this.completions.filtered.length)&&i(null,this.completions,c.finished)}.bind(this),t=!0,o=null;if(this.gatherCompletions(r,function(c,a){if(this.active&&(c&&(i(c,[],!0),this.detach()),0===a.prefix.indexOf(a.prefix))){if(t)return void(o=a);n(a)}}.bind(this)),t=!1,o){var l=o;o=null,n(l)}},u.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(r){"function"==typeof r.cancel&&r.cancel()})},u}(),M=function(){function u(r,e){this.all=r,this.filtered=r,this.filterText=e||"",this.exactMatch=!1,this.ignoreCaption=!1}return u.prototype.setFilter=function(r){if(r.length>this.filterText&&0===r.lastIndexOf(this.filterText,0))var e=this.filtered;else e=this.all;this.filterText=r,e=(e=this.filterCompletions(e,this.filterText)).sort(function(n,t){return t.exactMatch-n.exactMatch||t.$score-n.$score||(n.caption||n.value).localeCompare(t.caption||t.value)});var i=null;e=e.filter(function(n){var t=n.snippet||n.caption||n.value;return t!==i&&(i=t,!0)}),this.filtered=e},u.prototype.filterCompletions=function(r,e){var i=[],n=e.toUpperCase(),t=e.toLowerCase();e:for(var l,o=0;l=r[o];o++)if(l.skipFilter)l.$score=l.score,i.push(l);else{var c=!this.ignoreCaption&&l.caption||l.value||l.snippet;if(c){var h,m,a=-1,p=0,s=0;if(this.exactMatch){if(e!==c.substr(0,e.length))continue e}else{var d=c.toLowerCase().indexOf(t);if(d>-1)s=d;else for(var w=0;w<e.length;w++){var C=c.indexOf(t[w],a+1),k=c.indexOf(n[w],a+1);if((h=C>=0&&(k<0||C<k)?C:k)<0)continue e;(m=h-a-1)>0&&(-1===a&&(s+=10),s+=m,p|=1<<w),a=h}}l.matchMask=p,l.exactMatch=s?0:1,l.$score=(l.score||0)-s,i.push(l)}}return i},u}();_.Autocomplete=O,_.CompletionProvider=P,_.FilteredList=M}),ace.define("ace/ext/command_bar",["require","exports","module","ace/tooltip","ace/lib/event_emitter","ace/lib/lang","ace/lib/dom","ace/lib/oop","ace/lib/useragent"],function(f,_,U){var A=this&&this.__values||function(i){var n="function"==typeof Symbol&&Symbol.iterator,t=n&&i[n],o=0;if(t)return t.call(i);if(i&&"number"==typeof i.length)return{next:function(){return i&&o>=i.length&&(i=void 0),{value:i&&i[o++],done:!i}}};throw new TypeError(n?"Object is not iterable.":"Symbol.iterator is not defined.")},T=f("../tooltip").Tooltip,y=f("../lib/event_emitter").EventEmitter,v=f("../lib/lang"),g=f("../lib/dom"),b=f("../lib/oop"),$=f("../lib/useragent"),x="command_bar_tooltip_button",E="command_bar_button_value",N="command_bar_button_caption",S="command_bar_keybinding",L="command_bar_tooltip",O="MoreOptionsButton",u=function(i,n){return n.row>i.row||n.row===i.row&&n.column>i.column?i:n},r={Ctrl:{mac:"^"},Option:{mac:"\u2325"},Command:{mac:"\u2318"},Cmd:{mac:"\u2318"},Shift:"\u21e7",Left:"\u2190",Right:"\u2192",Up:"\u2191",Down:"\u2193"},e=function(){function i(n,t){var o,l;t=t||{},this.parentNode=n,this.tooltip=new T(this.parentNode),this.moreOptions=new T(this.parentNode),this.maxElementsOnTooltip=t.maxElementsOnTooltip||4,this.$alwaysShow=t.alwaysShow||!1,this.eventListeners={},this.elements={},this.commands={},this.tooltipEl=g.buildDom(["div",{class:L}],this.tooltip.getElement()),this.moreOptionsEl=g.buildDom(["div",{class:L+" tooltip_more_options"}],this.moreOptions.getElement()),this.$showTooltipTimer=v.delayedCall(this.$showTooltip.bind(this),t.showDelay||100),this.$hideTooltipTimer=v.delayedCall(this.$hideTooltip.bind(this),t.hideDelay||100),this.$tooltipEnter=this.$tooltipEnter.bind(this),this.$onMouseMove=this.$onMouseMove.bind(this),this.$onChangeScroll=this.$onChangeScroll.bind(this),this.$onEditorChangeSession=this.$onEditorChangeSession.bind(this),this.$scheduleTooltipForHide=this.$scheduleTooltipForHide.bind(this),this.$preventMouseEvent=this.$preventMouseEvent.bind(this);try{for(var c=A(["mousedown","mouseup","click"]),a=c.next();!a.done;a=c.next()){var p=a.value;this.tooltip.getElement().addEventListener(p,this.$preventMouseEvent),this.moreOptions.getElement().addEventListener(p,this.$preventMouseEvent)}}catch(s){o={error:s}}finally{try{a&&!a.done&&(l=c.return)&&l.call(c)}finally{if(o)throw o.error}}}return i.prototype.registerCommand=function(n,t){var o=Object.keys(this.commands).length<this.maxElementsOnTooltip;!o&&!this.elements[O]&&this.$createCommand(O,{name:"\xb7\xb7\xb7",exec:function(){this.$shouldHideMoreOptions=!1,this.$setMoreOptionsVisibility(!this.isMoreOptionsShown())}.bind(this),type:"checkbox",getValue:function(){return this.isMoreOptionsShown()}.bind(this),enabled:!0},!0),this.$createCommand(n,t,o),this.isShown()&&this.updatePosition()},i.prototype.isShown=function(){return!!this.tooltip&&this.tooltip.isOpen},i.prototype.isMoreOptionsShown=function(){return!!this.moreOptions&&this.moreOptions.isOpen},i.prototype.getAlwaysShow=function(){return this.$alwaysShow},i.prototype.setAlwaysShow=function(n){this.$alwaysShow=n,this.$updateOnHoverHandlers(!this.$alwaysShow),this._signal("alwaysShow",this.$alwaysShow)},i.prototype.attach=function(n){!n||this.isShown()&&this.editor===n||(this.detach(),this.editor=n,this.editor.on("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.on("changeScrollLeft",this.$onChangeScroll),this.editor.session.on("changeScrollTop",this.$onChangeScroll)),this.getAlwaysShow()?this.$showTooltip():this.$updateOnHoverHandlers(!0))},i.prototype.updatePosition=function(){if(this.editor){var t,n=this.editor.renderer;if((t=this.editor.selection.getAllRanges?this.editor.selection.getAllRanges():[this.editor.getSelectionRange()]).length){for(var c,o=u(t[0].start,t[0].end),l=0;c=t[l];l++)o=u(o,u(c.start,c.end));var a=n.$cursorLayer.getPixelPosition(o,!0),p=this.tooltip.getElement(),s=window.innerWidth,h=window.innerHeight,m=this.editor.container.getBoundingClientRect();a.top+=m.top-n.layerConfig.offset,a.left+=m.left+n.gutterWidth-n.scrollLeft;var d=a.top>=m.top&&a.top<=m.bottom&&a.left>=m.left+n.gutterWidth&&a.left<=m.right;if(!d&&this.isShown())return void this.$hideTooltip();if(d&&!this.isShown()&&this.getAlwaysShow())return void this.$showTooltip();var w=a.top-p.offsetHeight,C=Math.min(s-p.offsetWidth,a.left);if(!(w>=0&&w+p.offsetHeight<=h&&C>=0&&C+p.offsetWidth<=s))return void this.$hideTooltip();if(this.tooltip.setPosition(C,w),this.isMoreOptionsShown()){w+=p.offsetHeight,C=this.elements[O].getBoundingClientRect().left;var I=this.moreOptions.getElement();h=window.innerHeight,w+I.offsetHeight>h&&(w-=p.offsetHeight+I.offsetHeight),C+I.offsetWidth>s&&(C=s-I.offsetWidth),this.moreOptions.setPosition(C,w)}}}},i.prototype.update=function(){Object.keys(this.elements).forEach(this.$updateElement.bind(this))},i.prototype.detach=function(){this.tooltip.hide(),this.moreOptions.hide(),this.$updateOnHoverHandlers(!1),this.editor&&(this.editor.off("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.off("changeScrollLeft",this.$onChangeScroll),this.editor.session.off("changeScrollTop",this.$onChangeScroll))),this.$mouseInTooltip=!1,this.editor=null},i.prototype.destroy=function(){this.tooltip&&this.moreOptions&&(this.detach(),this.tooltip.destroy(),this.moreOptions.destroy()),this.eventListeners={},this.commands={},this.elements={},this.tooltip=this.moreOptions=this.parentNode=null},i.prototype.$createCommand=function(n,t,o){var p,l=o?this.tooltipEl:this.moreOptionsEl,c=[],a=t.bindKey;a&&("object"==typeof a&&(a=$.isMac?a.mac:a.win),c=(c=(a=a.split("|")[0]).split("-")).map(function(h){if(r[h]){if("string"==typeof r[h])return r[h];if($.isMac&&r[h].mac)return r[h].mac}return h})),o&&t.iconCssClass?p=["div",{class:["ace_icon_svg",t.iconCssClass].join(" "),"aria-label":t.name+" ("+t.bindKey+")"}]:(p=[["div",{class:E}],["div",{class:N},t.name]],c.length&&p.push(["div",{class:S},c.map(function(h){return["div",h]})])),g.buildDom(["div",{class:[x,t.cssClass||""].join(" "),ref:n},p],l,this.elements),this.commands[n]=t;var s=function(h){this.editor&&this.editor.focus(),this.$shouldHideMoreOptions=this.isMoreOptionsShown(),!this.elements[n].disabled&&t.exec&&t.exec(this.editor),this.$shouldHideMoreOptions&&this.$setMoreOptionsVisibility(!1),this.update(),h.preventDefault()}.bind(this);this.eventListeners[n]=s,this.elements[n].addEventListener("click",s.bind(this)),this.$updateElement(n)},i.prototype.$setMoreOptionsVisibility=function(n){n?(this.moreOptions.setTheme(this.editor.renderer.theme),this.moreOptions.setClassName(L+"_wrapper"),this.moreOptions.show(),this.update(),this.updatePosition()):this.moreOptions.hide()},i.prototype.$onEditorChangeSession=function(n){n.oldSession&&(n.oldSession.off("changeScrollTop",this.$onChangeScroll),n.oldSession.off("changeScrollLeft",this.$onChangeScroll)),this.detach()},i.prototype.$onChangeScroll=function(){this.editor.renderer&&(this.isShown()||this.getAlwaysShow())&&this.editor.renderer.once("afterRender",this.updatePosition.bind(this))},i.prototype.$onMouseMove=function(n){if(!this.$mouseInTooltip){var t=this.editor.getCursorPosition(),o=this.editor.renderer.textToScreenCoordinates(t.row,t.column);n.clientY>=o.pageY&&n.clientY<o.pageY+this.editor.renderer.lineHeight?(!this.isShown()&&!this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.delay(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()):(this.isShown()&&!this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.delay(),this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel())}},i.prototype.$preventMouseEvent=function(n){this.editor&&this.editor.focus(),n.preventDefault()},i.prototype.$scheduleTooltipForHide=function(){this.$mouseInTooltip=!1,this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.delay()},i.prototype.$tooltipEnter=function(){this.$mouseInTooltip=!0,this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()},i.prototype.$updateOnHoverHandlers=function(n){var t=this.tooltip.getElement(),o=this.moreOptions.getElement();n?(this.editor&&(this.editor.on("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().addEventListener("mouseout",this.$scheduleTooltipForHide,!0)),t.addEventListener("mouseenter",this.$tooltipEnter),t.addEventListener("mouseleave",this.$scheduleTooltipForHide),o.addEventListener("mouseenter",this.$tooltipEnter),o.addEventListener("mouseleave",this.$scheduleTooltipForHide)):(this.editor&&(this.editor.off("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().removeEventListener("mouseout",this.$scheduleTooltipForHide,!0)),t.removeEventListener("mouseenter",this.$tooltipEnter),t.removeEventListener("mouseleave",this.$scheduleTooltipForHide),o.removeEventListener("mouseenter",this.$tooltipEnter),o.removeEventListener("mouseleave",this.$scheduleTooltipForHide))},i.prototype.$showTooltip=function(){this.isShown()||(this.tooltip.setTheme(this.editor.renderer.theme),this.tooltip.setClassName(L+"_wrapper"),this.tooltip.show(),this.update(),this.updatePosition(),this._signal("show"))},i.prototype.$hideTooltip=function(){this.$mouseInTooltip=!1,this.isShown()&&(this.moreOptions.hide(),this.tooltip.hide(),this._signal("hide"))},i.prototype.$updateElement=function(n){var t=this.commands[n];if(t){var o=this.elements[n],l=t.enabled;if("function"==typeof l&&(l=l(this.editor)),"function"==typeof t.getValue){var c=t.getValue(this.editor);if("text"===t.type)o.textContent=c;else if("checkbox"===t.type){var a=c?g.addCssClass:g.removeCssClass,p=o.parentElement===this.tooltipEl;o.ariaChecked=c,p?a(o,"ace_selected"):a(o=o.querySelector("."+E),"ace_checkmark")}}l&&o.disabled?(g.removeCssClass(o,"ace_disabled"),o.ariaDisabled=o.disabled=!1,o.removeAttribute("disabled")):!l&&!o.disabled&&(g.addCssClass(o,"ace_disabled"),o.ariaDisabled=o.disabled=!0,o.setAttribute("disabled",""))}},i}();b.implement(e.prototype,y),g.importCssString("\n.ace_tooltip.".concat(L,"_wrapper {\n    padding: 0;\n}\n\n.ace_tooltip .").concat(L," {\n    padding: 1px 5px;\n    display: flex;\n    pointer-events: auto;\n}\n\n.ace_tooltip .").concat(L,".tooltip_more_options {\n    padding: 1px;\n    flex-direction: column;\n}\n\ndiv.").concat(x," {\n    display: inline-flex;\n    cursor: pointer;\n    margin: 1px;\n    border-radius: 2px;\n    padding: 2px 5px;\n    align-items: center;\n}\n\ndiv.").concat(x,".ace_selected,\ndiv.").concat(x,":hover:not(.ace_disabled) {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\ndiv.").concat(x,".ace_disabled {\n    color: #777;\n    pointer-events: none;\n}\n\ndiv.").concat(x," .ace_icon_svg {\n    height: 12px;\n    background-color: #000;\n}\n\ndiv.").concat(x,".ace_disabled .ace_icon_svg {\n    background-color: #777;\n}\n\n.").concat(L,".tooltip_more_options .").concat(x," {\n    display: flex;\n}\n\n.").concat(L,".").concat(E," {\n    display: none;\n}\n\n.").concat(L,".tooltip_more_options .").concat(E," {\n    display: inline-block;\n    width: 12px;\n}\n\n.").concat(N," {\n    display: inline-block;\n}\n\n.").concat(S," {\n    margin: 0 2px;\n    display: inline-block;\n    font-size: 8px;\n}\n\n.").concat(L,".tooltip_more_options .").concat(S," {\n    margin-left: auto;\n}\n\n.").concat(S," div {\n    display: inline-block;\n    min-width: 8px;\n    padding: 2px;\n    margin: 0 1px;\n    border-radius: 2px;\n    background-color: #ccc;\n    text-align: center;\n}\n\n.ace_dark.ace_tooltip .").concat(L," {\n    background-color: #373737;\n    color: #eee;\n}\n\n.ace_dark div.").concat(x,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark div.").concat(x,".ace_selected,\n.ace_dark div.").concat(x,":hover:not(.ace_disabled) {\n    background-color: rgba(255, 255, 255, 0.1);\n}\n\n.ace_dark div.").concat(x," .ace_icon_svg {\n    background-color: #eee;\n}\n\n.ace_dark div.").concat(x,".ace_disabled .ace_icon_svg {\n    background-color: #979797;\n}\n\n.ace_dark .").concat(x,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark .").concat(S," div {\n    background-color: #575757;\n}\n\n.ace_checkmark::before {\n    content: '\u2713';\n}\n"),"commandbar.css",!1),_.CommandBarTooltip=e,_.TOOLTIP_CLASS_NAME=L,_.BUTTON_CLASS_NAME=x}),ace.define("ace/marker_group",["require","exports","module"],function(f,_,U){"use strict";var A=function(){function T(y,v){v&&(this.markerType=v.markerType),this.markers=[],this.session=y,y.addDynamicMarker(this)}return T.prototype.getMarkerAtPosition=function(y){return this.markers.find(function(v){return v.range.contains(y.row,y.column)})},T.prototype.markersComparator=function(y,v){return y.range.start.row-v.range.start.row},T.prototype.setMarkers=function(y){this.markers=y.sort(this.markersComparator).slice(0,this.MAX_MARKERS),this.session._signal("changeBackMarker")},T.prototype.update=function(y,v,g,b){if(this.markers&&this.markers.length)for(var E,$=b.firstRow,x=b.lastRow,N=0,S=0,L=0;L<this.markers.length;L++){var O=this.markers[L];if(!(O.range.end.row<$||O.range.start.row>x||(O.range.start.row===S?N++:(S=O.range.start.row,N=0),N>200))){var P=O.range.clipRows($,x);if(P.start.row!==P.end.row||P.start.column!==P.end.column){var M=P.toScreenRange(g);if(M.isEmpty()){(E=g.getNextFoldLine(P.end.row,E))&&E.end.row>P.end.row&&($=E.end.row);continue}"fullLine"===this.markerType?v.drawFullLineMarker(y,M,O.className,b):M.isMultiLine()?"line"===this.markerType?v.drawMultiLineMarker(y,M,O.className,b):v.drawTextMarker(y,M,O.className,b):v.drawSingleLineMarker(y,M,O.className+" ace_br15",b)}}}},T}();A.prototype.MAX_MARKERS=1e4,_.MarkerGroup=A}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(f,_,U){var A=f("../range").Range,T=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;_.getCompletions=function(g,b,$,x,E){var N=function v(g,b){var $=function y(g,b){return g.getTextRange(A.fromPoints({row:0,column:0},b)).split(T).length-1}(g,b),x=g.getValue().split(T),E=Object.create(null),N=x[$];return x.forEach(function(S,L){if(S&&S!==N){var O=Math.abs($-L),P=x.length-O;E[S]=E[S]?Math.max(P,E[S]):P}}),E}(b,$);E(null,Object.keys(N).map(function(L){return{caption:L,value:L,score:N[L],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/marker_group","ace/autocomplete/text_completer","ace/editor","ace/config"],function(f,_,U){"use strict";var A=f("../snippets").snippetManager,T=f("../autocomplete").Autocomplete,y=f("../config"),v=f("../lib/lang"),g=f("../autocomplete/util"),b=f("../marker_group").MarkerGroup,$=f("../autocomplete/text_completer"),x={getCompletions:function(t,o,l,c,a){if(o.$mode.completer)return o.$mode.completer.getCompletions(t,o,l,c,a);var p=t.session.getState(l.row),s=o.$mode.getCompletions(p,o,l,c);a(null,s=s.map(function(h){return h.completerId=x.id,h}))},id:"keywordCompleter"},E=function(t){var o={};return t.replace(/\${(\d+)(:(.*?))?}/g,function(l,c,a,p){return o[c]=p||""}).replace(/\$(\d+?)/g,function(l,c){return o[c]})},N={getCompletions:function(t,o,l,c,a){var p=[],s=o.getTokenAt(l.row,l.column);s&&s.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?p.push("html-tag"):p=A.getActiveScopes(t);var h=A.snippetMap,m=[];p.forEach(function(d){for(var w=h[d]||[],C=w.length;C--;){var k=w[C],I=k.name||k.tabTrigger;I&&m.push({caption:I,snippet:k.content,meta:k.tabTrigger&&!k.name?k.tabTrigger+"\u21e5 ":"snippet",completerId:N.id})}},this),a(null,m)},getDocTooltip:function(t){t.snippet&&!t.docHTML&&(t.docHTML=["<b>",v.escapeHTML(t.caption),"</b>","<hr></hr>",v.escapeHTML(E(t.snippet))].join(""))},id:"snippetCompleter"},S=[N,$,x];_.setCompleters=function(t){S.length=0,t&&S.push.apply(S,t)},_.addCompleter=function(t){S.push(t)},_.textCompleter=$,_.keyWordCompleter=x,_.snippetCompleter=N;var r,L={name:"expandSnippet",exec:function(t){return A.expandWithTab(t)},bindKey:"Tab"},O=function(t,o){P(o.session.$mode)},P=function(t){"string"==typeof t&&(t=y.$modes[t]),t&&(A.files||(A.files={}),M(t.$id,t.snippetFileId),t.modes&&t.modes.forEach(P))},M=function(t,o){!o||!t||A.files[t]||(A.files[t]={},y.loadModule(o,function(l){l&&(A.files[t]=l,!l.snippets&&l.snippetText&&(l.snippets=A.parseSnippetFile(l.snippetText)),A.register(l.snippets||[],l.scope),l.includeScopes&&(A.snippetMap[l.scope].includeScopes=l.includeScopes,l.includeScopes.forEach(function(c){P("ace/mode/"+c)})))}))},u=function(t){var o=t.editor,l=o.completer&&o.completer.activated;if("backspace"===t.command.name)l&&!g.getCompletionPrefix(o)&&o.completer.detach();else if("insertstring"===t.command.name&&!l){r=t;var c=t.editor.$liveAutocompletionDelay;c?e.delay(c):i(t)}},e=v.delayedCall(function(){i(r)},0),i=function(t){var o=t.editor,l=g.getCompletionPrefix(o),a=g.triggerAutocomplete(o,t.args);if(l&&l.length>=o.$liveAutocompletionThreshold||a){var p=T.for(o);p.autoShown=!0,p.showPopup(o)}},n=f("../editor").Editor;f("../config").defineOptions(n.prototype,"editor",{enableBasicAutocompletion:{set:function(t){t?(T.for(this),this.completers||(this.completers=Array.isArray(t)?t:S),this.commands.addCommand(T.startCommand)):this.commands.removeCommand(T.startCommand)},value:!1},enableLiveAutocompletion:{set:function(t){t?(this.completers||(this.completers=Array.isArray(t)?t:S),this.commands.on("afterExec",u)):this.commands.off("afterExec",u)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(t){t?(this.commands.addCommand(L),this.on("changeMode",O),O(0,this)):(this.commands.removeCommand(L),this.off("changeMode",O))},value:!1}}),_.MarkerGroup=b}),ace.define("ace/ext/inline_autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/inline","ace/autocomplete","ace/autocomplete","ace/editor","ace/autocomplete/util","ace/lib/dom","ace/lib/lang","ace/ext/command_bar","ace/ext/command_bar","ace/ext/language_tools","ace/ext/language_tools","ace/ext/language_tools","ace/config"],function(f,_,U){"use strict";var A=f("../keyboard/hash_handler").HashHandler,T=f("../autocomplete/inline").AceInline,y=f("../autocomplete").FilteredList,v=f("../autocomplete").CompletionProvider,g=f("../editor").Editor,b=f("../autocomplete/util"),$=f("../lib/dom"),x=f("../lib/lang"),E=f("./command_bar").CommandBarTooltip,N=f("./command_bar").BUTTON_CLASS_NAME,S=f("./language_tools").snippetCompleter,L=f("./language_tools").textCompleter,O=f("./language_tools").keyWordCompleter,P=function(r,e){e.completer&&e.completer.destroy()},M=function(){function r(e){this.editor=e,this.keyboardHandler=new A(this.commands),this.$index=-1,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.changeTimer=x.delayedCall(function(){this.updateCompletions()}.bind(this))}return r.prototype.getInlineRenderer=function(){return this.inlineRenderer||(this.inlineRenderer=new T),this.inlineRenderer},r.prototype.getInlineTooltip=function(){return this.inlineTooltip||(this.inlineTooltip=r.createInlineTooltip(document.body||document.documentElement)),this.inlineTooltip},r.prototype.show=function(e){this.activated=!0,this.editor.completer!==this&&(this.editor.completer&&this.editor.completer.detach(),this.editor.completer=this),this.editor.on("changeSelection",this.changeListener),this.editor.on("blur",this.blurListener),this.updateCompletions(e)},r.prototype.$open=function(){this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({}),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.getInlineTooltip().attach(this.editor),-1===this.$index?this.setIndex(0):this.$showCompletion(),this.changeTimer.cancel()},r.prototype.insertMatch=function(){var e=this.getCompletionProvider().insertByIndex(this.editor,this.$index);return this.detach(),e},r.prototype.changeListener=function(e){var i=this.editor.selection.lead;(i.row!=this.base.row||i.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},r.prototype.blurListener=function(e){this.detach()},r.prototype.goTo=function(e){if(this.completions&&this.completions.filtered){var i=this.completions.filtered.length;switch(e.toLowerCase()){case"prev":this.setIndex((this.$index-1+i)%i);break;case"next":this.setIndex((this.$index+1+i)%i);break;case"first":this.setIndex(0);break;case"last":this.setIndex(this.completions.filtered.length-1)}}},r.prototype.getLength=function(){return this.completions&&this.completions.filtered?this.completions.filtered.length:0},r.prototype.getData=function(e){return null==e||null===e?this.completions.filtered[this.$index]:this.completions.filtered[e]},r.prototype.getIndex=function(){return this.$index},r.prototype.isOpen=function(){return this.$index>=0},r.prototype.setIndex=function(e){if(this.completions&&this.completions.filtered){var i=Math.max(-1,Math.min(this.completions.filtered.length-1,e));i!==this.$index&&(this.$index=i,this.$showCompletion())}},r.prototype.getCompletionProvider=function(e){return this.completionProvider||(this.completionProvider=new v(e)),this.completionProvider},r.prototype.$showCompletion=function(){this.getInlineRenderer().show(this.editor,this.completions.filtered[this.$index],this.completions.filterText)||this.getInlineRenderer().hide(),this.inlineTooltip&&this.inlineTooltip.isShown()&&this.inlineTooltip.update()},r.prototype.$updatePrefix=function(){var e=this.editor.getCursorPosition(),i=this.editor.session.getTextRange({start:this.base,end:e});return this.completions.setFilter(i),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=i||this.completions.filtered[0].snippet)?(this.$open(this.editor,i),i):this.detach()},r.prototype.updateCompletions=function(o){var t="";if(o&&o.matches){var n=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(n.row,n.column),this.base.$insertRight=!0,this.completions=new y(o.matches),this.$open(this.editor,"")}this.base&&this.completions&&(t=this.$updatePrefix());var i=this.editor.getSession();n=this.editor.getCursorPosition(),t=b.getCompletionPrefix(this.editor),this.base=i.doc.createAnchor(n.row,n.column-t.length),this.base.$insertRight=!0,o={exactMatch:!0,ignoreCaption:!0},this.getCompletionProvider({prefix:t,base:this.base,pos:n}).provideCompletions(this.editor,o,function(l,c,a){var p=c.filtered,s=b.getCompletionPrefix(this.editor);if(a){if(!p.length)return this.detach();if(1==p.length&&p[0].value==s&&!p[0].snippet)return this.detach()}this.completions=c,this.$open(this.editor,s)}.bind(this))},r.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener)),this.changeTimer.cancel(),this.inlineTooltip&&this.inlineTooltip.detach(),this.setIndex(-1),this.completionProvider&&this.completionProvider.detach(),this.inlineRenderer&&this.inlineRenderer.isOpen()&&this.inlineRenderer.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},r.prototype.destroy=function(){this.detach(),this.inlineRenderer&&this.inlineRenderer.destroy(),this.inlineTooltip&&this.inlineTooltip.destroy(),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",P),this.editor.completer=null),this.inlineTooltip=this.editor=this.inlineRenderer=null},r.prototype.updateDocTooltip=function(){},r}();M.prototype.commands={Previous:{bindKey:"Alt-[",name:"Previous",exec:function(r){r.completer.goTo("prev")}},Next:{bindKey:"Alt-]",name:"Next",exec:function(r){r.completer.goTo("next")}},Accept:{bindKey:{win:"Tab|Ctrl-Right",mac:"Tab|Cmd-Right"},name:"Accept",exec:function(r){return r.completer.insertMatch()}},Close:{bindKey:"Esc",name:"Close",exec:function(r){r.completer.detach()}}},M.for=function(r){return r.completer instanceof M||(r.completer&&(r.completer.destroy(),r.completer=null),r.completer=new M(r),r.once("destroy",P)),r.completer},M.startCommand={name:"startInlineAutocomplete",exec:function(r,e){M.for(r).show(e)},bindKey:{win:"Alt-C",mac:"Option-C"}};var u=[S,L,O];f("../config").defineOptions(g.prototype,"editor",{enableInlineAutocompletion:{set:function(r){r?(this.completers||(this.completers=Array.isArray(r)?r:u),this.commands.addCommand(M.startCommand)):this.commands.removeCommand(M.startCommand)},value:!1}}),M.createInlineTooltip=function(r){var e=new E(r);return e.registerCommand("Previous",Object.assign({},M.prototype.commands.Previous,{enabled:!0,type:"button",iconCssClass:"ace_arrow_rotated"})),e.registerCommand("Position",{enabled:!1,getValue:function(i){return i?[i.completer.getIndex()+1,i.completer.getLength()].join("/"):""},type:"text",cssClass:"completion_position"}),e.registerCommand("Next",Object.assign({},M.prototype.commands.Next,{enabled:!0,type:"button",iconCssClass:"ace_arrow"})),e.registerCommand("Accept",Object.assign({},M.prototype.commands.Accept,{enabled:function(i){return!!i&&i.completer.getIndex()>=0},type:"button"})),e.registerCommand("ShowTooltip",{name:"Always Show Tooltip",exec:function(){e.setAlwaysShow(!e.getAlwaysShow())},enabled:!0,getValue:function(){return e.getAlwaysShow()},type:"checkbox"}),e},$.importCssString('\n\n.ace_icon_svg.ace_arrow,\n.ace_icon_svg.ace_arrow_rotated {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTUuODM3MDEgMTVMNC41ODc1MSAxMy43MTU1TDEwLjE0NjggOEw0LjU4NzUxIDIuMjg0NDZMNS44MzcwMSAxTDEyLjY0NjUgOEw1LjgzNzAxIDE1WiIgZmlsbD0iYmxhY2siLz48L3N2Zz4=");\n}\n\n.ace_icon_svg.ace_arrow_rotated {\n    transform: rotate(180deg);\n}\n\ndiv.'.concat(N,".completion_position {\n    padding: 0;\n}\n"),"inlineautocomplete.css",!1),_.InlineAutocomplete=M}),ace.require(["ace/ext/inline_autocomplete"],function(f){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=f)});