ace.define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:["comment.doc.tag","comment.doc.text","lparen.doc"],regex:"(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:["rparen.doc","text.doc","variable.parameter.doc","lparen.doc","variable.parameter.doc","rparen.doc"],regex:/(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.\-\'\" ]+)(\])))/,next:"pop"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","lparen.doc"],regex:"(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|implements|external|exception|throws|enum|define|extends))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:'(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|requires|param|implements|function|extends|typedef|mixes|constructor|var|memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#.:/~"\\-]*)?'},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@method)(\\s+)(\\w[\\w.\\(\\)]*)"},{token:"comment.doc.tag",regex:"@access\\s+(?:private|public|protected)"},{token:"comment.doc.tag",regex:"@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"},{token:"comment.doc.tag",regex:"@\\w+(?=\\s|$)"},g.getTagRule(),{defaultToken:"comment.doc.body",caseInsensitive:!0}],"doc-syntax":[{token:"operator.doc",regex:/[|:]/},{token:"paren.doc",regex:/[\[\]]/}]},this.normalizeRules()};f.inherits(g,p),g.getTagRule=function(l){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},g.getStartRule=function(l){return{token:"comment.doc",regex:/\/\*\*(?!\/)/,next:l}},g.getEndRule=function(l){return{token:"comment.doc",regex:"\\*\\/",next:l}},h.JsDocCommentHighlightRules=g}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules,g=s("./text_highlight_rules").TextHighlightRules,l="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",i=function(u){var o={"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},r=this.createKeywordMapper(o,"identifier"),t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)",n="(function)(\\s*)(\\*?)",d={token:["identifier","text","paren.lparen"],regex:"(\\b(?!"+Object.values(o).join("|")+"\\b)"+l+")(\\s*)(\\()"};this.$rules={no_regex:[p.getStartRule("doc-start"),a("no_regex"),d,{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+l+")(\\s*)(=)(\\s*)"+n+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))("+l+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+l+")(\\s*)(:)(\\s*)"+n+"(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)"+n+"(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|debug|time|trace|timeEnd|assert)\b/},{token:r,regex:l},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:"keyword.operator",regex:/=/},{token:["storage.type","text","storage.type","text","paren.lparen"],regex:n+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:"prototype"},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:l},{regex:"",token:"empty",next:"no_regex"}],start:[p.getStartRule("doc-start"),a("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[a("function_arguments"),{token:"variable.parameter",regex:l},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!u||!u.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(m,x,b){if(this.next="{"==m?this.nextState:"","{"==m&&b.length)b.unshift("start",x);else if("}"==m&&b.length&&(b.shift(),this.next=b.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==m?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+l+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=[^\\(]+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!u||0!=u.jsx)&&c.call(this)),this.embedRules(p,"doc-",[p.getEndRule("no_regex")]),this.normalizeRules()};function c(){var u=l.replace("\\d","\\d\\-"),o={onMatch:function(e,t,n){var d="/"==e.charAt(1)?2:1;return 1==d?(t!=this.nextState?n.unshift(this.next,this.nextState,0):n.unshift(this.next),n[2]++):2==d&&t==this.nextState&&(n[1]--,(!n[1]||n[1]<0)&&(n.shift(),n.shift())),[{type:"meta.tag.punctuation."+(1==d?"":"end-")+"tag-open.xml",value:e.slice(0,d)},{type:"meta.tag.tag-name.xml",value:e.substr(d)}]},regex:"</?(?:"+u+"|(?=>))",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(o);var r={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[r,o,{include:"reference"},{defaultToken:"string.xml"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,n){return t==n[0]&&n.shift(),2==e.length&&(n[0]==this.nextState&&n[1]--,(!n[1]||n[1]<0)&&n.splice(0,2)),this.next=n[0]||"start",[{type:this.token,value:e}]},nextState:"jsx"},r,a("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:u},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},o],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function a(u){return[{token:"comment",regex:/\/\*/,next:[p.getTagRule(),{token:"comment",regex:"\\*\\/",next:u||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[p.getTagRule(),{token:"comment",regex:"$|^",next:u||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}f.inherits(i,g),h.JavaScriptHighlightRules=i}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(s,h,v){"use strict";var f=s("../range").Range,p=function(){};(function(){this.checkOutdent=function(g,l){return!!/^\s+$/.test(g)&&/^\s*\}/.test(l)},this.autoOutdent=function(g,l){var c=g.getLine(l).match(/^(\s*\})/);if(!c)return 0;var a=c[1].length,u=g.findMatchingBracket({row:l,column:a});if(!u||u.row==l)return 0;var o=this.$getIndent(g.getLine(u.row));g.replace(new f(l,0,l,a-1),o)},this.$getIndent=function(g){return g.match(/^\s*/)[0]}}).call(p.prototype),h.MatchingBraceOutdent=p}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("../behaviour").Behaviour,g=s("../../token_iterator").TokenIterator;function l(c,a){return c&&c.type.lastIndexOf(a+".xml")>-1}var i=function(){this.add("string_dquotes","insertion",function(c,a,u,o,r){if('"'==r||"'"==r){var e=r,t=o.doc.getTextRange(u.getSelectionRange());if(""!==t&&"'"!==t&&'"'!=t&&u.getWrapBehavioursEnabled())return{text:e+t+e,selection:!1};var n=u.getCursorPosition(),m=o.doc.getLine(n.row).substring(n.column,n.column+1),x=new g(o,n.row,n.column),b=x.getCurrentToken();if(m==e&&(l(b,"attribute-value")||l(b,"string")))return{text:"",selection:[1,1]};if(b||(b=x.stepBackward()),!b)return;for(;l(b,"tag-whitespace")||l(b,"whitespace");)b=x.stepBackward();var k=!m||m.match(/\s/);if(l(b,"attribute-equals")&&(k||">"==m)||l(b,"decl-attribute-equals")&&(k||"?"==m))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(c,a,u,o,r){var e=o.doc.getTextRange(r);if(!r.isMultiLine()&&('"'==e||"'"==e)&&o.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==e)return r.end.column++,r}),this.add("autoclosing","insertion",function(c,a,u,o,r){if(">"==r){var e=u.getSelectionRange().start,t=new g(o,e.row,e.column),n=t.getCurrentToken()||t.stepBackward();if(!n||!(l(n,"tag-name")||l(n,"tag-whitespace")||l(n,"attribute-name")||l(n,"attribute-equals")||l(n,"attribute-value"))||l(n,"reference.attribute-value"))return;if(l(n,"attribute-value")){var d=t.getCurrentTokenColumn()+n.value.length;if(e.column<d)return;if(e.column==d){var m=t.stepForward();if(m&&l(m,"attribute-value"))return;t.stepBackward()}}if(/^\s*>/.test(o.getLine(e.row).slice(e.column)))return;for(;!l(n,"tag-name");)if("<"==(n=t.stepBackward()).value){n=t.stepForward();break}var x=t.getCurrentTokenRow(),b=t.getCurrentTokenColumn();if(l(t.stepBackward(),"end-tag-open"))return;var k=n.value;return x==e.row&&(k=k.substring(0,e.column-b)),this.voidElements&&this.voidElements.hasOwnProperty(k.toLowerCase())?void 0:{text:"></"+k+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(c,a,u,o,r){if("\n"==r){var e=u.getCursorPosition(),t=o.getLine(e.row),n=new g(o,e.row,e.column),d=n.getCurrentToken();if(l(d,"")&&-1!==d.type.indexOf("tag-close")){if("/>"==d.value)return;for(;d&&-1===d.type.indexOf("tag-name");)d=n.stepBackward();if(!d)return;var m=d.value,x=n.getCurrentTokenRow();if(!(d=n.stepBackward())||-1!==d.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[m]||!this.voidElements){var b=o.getTokenAt(e.row,e.column+1),k=(t=o.getLine(x),this.$getIndent(t)),y=k+o.getTabString();return b&&"</"===b.value?{text:"\n"+y+"\n"+k,selection:[1,y.length,1,y.length]}:{text:"\n"+y}}}}})};f.inherits(i,p),h.XmlBehaviour=i}),ace.define("ace/mode/behaviour/javascript",["require","exports","module","ace/lib/oop","ace/token_iterator","ace/mode/behaviour/cstyle","ace/mode/behaviour/xml"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("../../token_iterator").TokenIterator,g=s("../behaviour/cstyle").CstyleBehaviour,l=s("../behaviour/xml").XmlBehaviour,i=function(){var c=new l({closeCurlyBraces:!0}).getBehaviours();this.addBehaviours(c),this.inherit(g),this.add("autoclosing-fragment","insertion",function(a,u,o,r,e){if(">"==e){var t=o.getSelectionRange().start,n=new p(r,t.row,t.column),d=n.getCurrentToken()||n.stepBackward();if(!d)return;if("<"==d.value)return{text:"></>",selection:[1,1]}}})};f.inherits(i,g),h.JavaScriptBehaviour=i}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("../../range").Range,g=s("./fold_mode").FoldMode,l=h.FoldMode=function(a,u){g.call(this),this.voidElements=a||{},this.optionalEndTags=f.mixin({},this.voidElements),u&&f.mixin(this.optionalEndTags,u)};f.inherits(l,g);var i=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function c(a,u){return a&&a.type&&a.type.lastIndexOf(u+".xml")>-1}(function(){this.getFoldWidget=function(a,u,o){var r=this._getFirstTagInLine(a,o);return r?r.closing||!r.tagName&&r.selfClosing?"markbeginend"===u?"end":"":!r.tagName||r.selfClosing||this.voidElements.hasOwnProperty(r.tagName.toLowerCase())||this._findEndTagInLine(a,o,r.tagName,r.end.column)?"":"start":this.getCommentFoldWidget(a,o)},this.getCommentFoldWidget=function(a,u){return/comment/.test(a.getState(u))&&/<!-/.test(a.getLine(u))?"start":""},this._getFirstTagInLine=function(a,u){for(var o=a.getTokens(u),r=new i,e=0;e<o.length;e++){var t=o[e];if(c(t,"tag-open")){if(r.end.column=r.start.column+t.value.length,r.closing=c(t,"end-tag-open"),!(t=o[++e]))return null;if(r.tagName=t.value,""===t.value){if(!(t=o[++e]))return null;r.tagName=t.value}for(r.end.column+=t.value.length,e++;e<o.length;e++)if(r.end.column+=(t=o[e]).value.length,c(t,"tag-close")){r.selfClosing="/>"==t.value;break}return r}if(c(t,"tag-close"))return r.selfClosing="/>"==t.value,r;r.start.column+=t.value.length}return null},this._findEndTagInLine=function(a,u,o,r){for(var e=a.getTokens(u),t=0,n=0;n<e.length;n++){var d=e[n];if(!((t+=d.value.length)<r-1)&&c(d,"end-tag-open")&&(c(d=e[n+1],"tag-name")&&""===d.value&&(d=e[n+2]),d&&d.value==o))return!0}return!1},this.getFoldWidgetRange=function(a,u,o){if(!this._getFirstTagInLine(a,o))return this.getCommentFoldWidget(a,o)&&a.getCommentFoldRange(o,a.getLine(o).length);var e=a.getMatchingTags({row:o,column:0});return e?new p(e.openTag.end.row,e.openTag.end.column,e.closeTag.start.row,e.closeTag.start.column):void 0}}).call(l.prototype)}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("../../range").Range,g=s("./fold_mode").FoldMode,l=h.FoldMode=function(i){i&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+i.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+i.end)))};f.inherits(l,g),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(i,c,a){var u=i.getLine(a);if(this.singleLineBlockCommentRe.test(u)&&!this.startRegionRe.test(u)&&!this.tripleStarBlockCommentRe.test(u))return"";var o=this._getFoldWidgetBase(i,c,a);return!o&&this.startRegionRe.test(u)?"start":o},this.getFoldWidgetRange=function(i,c,a,u){var t,o=i.getLine(a);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(i,o,a);if(t=o.match(this.foldingStartMarker)){var r=t.index;if(t[1])return this.openingBracketBlock(i,t[1],a,r);var e=i.getCommentFoldRange(a,r+t[0].length,1);return e&&!e.isMultiLine()&&(u?e=this.getSectionRange(i,a):"all"!=c&&(e=null)),e}return"markbegin"!==c&&(t=o.match(this.foldingStopMarker))?(r=t.index+t[0].length,t[1]?this.closingBracketBlock(i,t[1],a,r):i.getCommentFoldRange(a,r,-1)):void 0},this.getSectionRange=function(i,c){for(var a=i.getLine(c),u=a.search(/\S/),o=c,r=a.length,e=c+=1,t=i.getLength();++c<t;){var n=(a=i.getLine(c)).search(/\S/);if(-1!==n){if(u>n)break;var d=this.getFoldWidgetRange(i,"all",c);if(d){if(d.start.row<=o)break;if(d.isMultiLine())c=d.end.row;else if(u==n)break}e=c}}return new p(o,r,e,i.getLine(e).length)},this.getCommentRegionBlock=function(i,c,a){for(var u=c.search(/\s*$/),o=i.getLength(),r=a,e=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++a<o;){c=i.getLine(a);var n=e.exec(c);if(n&&(n[1]?t--:t++,!t))break}if(a>r)return new p(r,u,a,c.length)}}.call(l.prototype)}),ace.define("ace/mode/folding/javascript",["require","exports","module","ace/lib/oop","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("./xml").FoldMode,g=s("./cstyle").FoldMode,l=h.FoldMode=function(i){i&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+i.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+i.end))),this.xmlFoldMode=new p};f.inherits(l,g),function(){this.getFoldWidgetRangeBase=this.getFoldWidgetRange,this.getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(i,c,a){return this.getFoldWidgetBase(i,c,a)||this.xmlFoldMode.getFoldWidget(i,c,a)},this.getFoldWidgetRange=function(i,c,a,u){return this.getFoldWidgetRangeBase(i,c,a,u)||this.xmlFoldMode.getFoldWidgetRange(i,c,a)}}.call(l.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/javascript","ace/mode/folding/javascript"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./text").Mode,g=s("./javascript_highlight_rules").JavaScriptHighlightRules,l=s("./matching_brace_outdent").MatchingBraceOutdent,i=s("../worker/worker_client").WorkerClient,c=s("./behaviour/javascript").JavaScriptBehaviour,a=s("./folding/javascript").FoldMode,u=function(){this.HighlightRules=g,this.$outdent=new l,this.$behaviour=new c,this.foldingRules=new a};f.inherits(u,p),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.$pairQuotesAfter={"`":/\w/},this.getNextLineIndent=function(o,r,e){var t=this.$getIndent(r),n=this.getTokenizer().getLineTokens(r,o),d=n.tokens,m=n.state;if(d.length&&"comment"==d[d.length-1].type)return t;if("start"==o||"no_regex"==o)r.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/)&&(t+=e);else if("doc-start"==o&&("start"==m||"no_regex"==m))return"";return t},this.checkOutdent=function(o,r,e){return this.$outdent.checkOutdent(r,e)},this.autoOutdent=function(o,r,e){this.$outdent.autoOutdent(r,e)},this.createWorker=function(o){var r=new i(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return r.attachToDocument(o.getDocument()),r.on("annotate",function(e){o.setAnnotations(e.data)}),r.on("terminate",function(){o.clearAnnotations()}),r},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(u.prototype),h.Mode=u}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),g=(s("../lib/lang"),s("./text_highlight_rules").TextHighlightRules),l=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",i=h.supportFunction="rgb|rgba|url|attr|counter|counters",c=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",a=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",u=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",o=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",r=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",e=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",t=function(){var n=this.createKeywordMapper({"support.function":i,"support.constant":c,"support.type":l,"support.constant.color":a,"support.constant.fonts":u},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:o},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+o+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:o},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:r},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:e},{include:"url"},{token:n,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{token:"paren.lparen",regex:"\\{"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};f.inherits(t,g),h.CssHighlightRules=t}),ace.define("ace/mode/css_completions",["require","exports","module"],function(s,h,v){"use strict";var f={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},p=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var g=document.createElement("c").style;for(var l in g)if("string"==typeof g[l]){var i=l.replace(/[A-Z]/g,function(c){return"-"+c.toLowerCase()});f.hasOwnProperty(i)||(f[i]=1)}}this.completionsDefined=!0},this.getCompletions=function(g,l,i,c){if(this.completionsDefined||this.defineCompletions(),"ruleset"===g||"ace/mode/scss"==l.$mode.$id){var a=l.getLine(i.row).substr(0,i.column),u=/\([^)]*$/.test(a);return u&&(a=a.substr(a.lastIndexOf("(")+1)),/:[^;]+$/.test(a)?(/([\w\-]+):[^:]*$/.test(a),this.getPropertyValueCompletions(g,l,i,c)):this.getPropertyCompletions(g,l,i,c,u)}return[]},this.getPropertyCompletions=function(g,l,i,c,a){return a=a||!1,Object.keys(f).map(function(o){return{caption:o,snippet:o+": $0"+(a?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(g,l,i,c){var a=l.getLine(i.row).substr(0,i.column),u=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!u)return[];var o=[];return u in f&&"object"==typeof f[u]&&(o=Object.keys(f[u])),o.map(function(r){return{caption:r,snippet:r,meta:"property value",score:1e6}})}}).call(p.prototype),h.CssCompletions=p}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(s,h,v){"use strict";var f=s("../../lib/oop"),g=(s("../behaviour"),s("./cstyle").CstyleBehaviour),l=s("../../token_iterator").TokenIterator,i=function(){this.inherit(g),this.add("colon","insertion",function(c,a,u,o,r){if(":"===r&&u.selection.isEmpty()){var e=u.getCursorPosition(),t=new l(o,e.row,e.column),n=t.getCurrentToken();if(n&&n.value.match(/\s+/)&&(n=t.stepBackward()),n&&"support.type"===n.type){var d=o.doc.getLine(e.row);if(":"===d.substring(e.column,e.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(d.substring(e.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(c,a,u,o,r){var e=o.doc.getTextRange(r);if(!r.isMultiLine()&&":"===e){var t=u.getCursorPosition(),n=new l(o,t.row,t.column),d=n.getCurrentToken();if(d&&d.value.match(/\s+/)&&(d=n.stepBackward()),d&&"support.type"===d.type&&";"===o.doc.getLine(r.start.row).substring(r.end.column,r.end.column+1))return r.end.column++,r}}),this.add("semicolon","insertion",function(c,a,u,o,r){if(";"===r&&u.selection.isEmpty()){var e=u.getCursorPosition();if(";"===o.doc.getLine(e.row).substring(e.column,e.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(c,a,u,o,r){if("!"===r&&u.selection.isEmpty()){var e=u.getCursorPosition(),t=o.doc.getLine(e.row);if(/^\s*(;|}|$)/.test(t.substring(e.column)))return{text:"!important",selection:[10,10]}}})};f.inherits(i,g),h.CssBehaviour=i}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./text").Mode,g=s("./css_highlight_rules").CssHighlightRules,l=s("./matching_brace_outdent").MatchingBraceOutdent,i=s("../worker/worker_client").WorkerClient,c=s("./css_completions").CssCompletions,a=s("./behaviour/css").CssBehaviour,u=s("./folding/cstyle").FoldMode,o=function(){this.HighlightRules=g,this.$outdent=new l,this.$behaviour=new a,this.$completer=new c,this.foldingRules=new u};f.inherits(o,p),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(r,e,t){var n=this.$getIndent(e),d=this.getTokenizer().getLineTokens(e,r).tokens;return d.length&&"comment"==d[d.length-1].type||e.match(/^.*\{\s*$/)&&(n+=t),n},this.checkOutdent=function(r,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(r,e,t){this.$outdent.autoOutdent(e,t)},this.getCompletions=function(r,e,t,n){return this.$completer.getCompletions(r,e,t,n)},this.createWorker=function(r){var e=new i(["ace"],"ace/mode/css_worker","Worker");return e.attachToDocument(r.getDocument()),e.on("annotate",function(t){r.setAnnotations(t.data)}),e.on("terminate",function(){r.clearAnnotations()}),e},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(o.prototype),h.Mode=o}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./text_highlight_rules").TextHighlightRules,g=function(l){var i="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+i+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:i},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+i+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+i+":)?"+i+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:i},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===g&&this.normalizeRules()};(function(){this.embedTagRules=function(l,i,c){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+c+".tag-name.xml"],regex:"(<)("+c+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:i+"start"}]}),this.$rules[c+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(a,u,o){return o.splice(0),this.token}}],this.embedRules(l,i,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+c+".tag-name.xml"],regex:"(</)("+c+"(?=\\s|>|$))",next:c+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(p.prototype),f.inherits(g,p),h.XmlHighlightRules=g}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("../lib/lang"),g=s("./css_highlight_rules").CssHighlightRules,l=s("./javascript_highlight_rules").JavaScriptHighlightRules,i=s("./xml_highlight_rules").XmlHighlightRules,c=p.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),a=function(){i.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(u,o){var r=c[o];return["meta.tag.punctuation."+("<"==u?"":"end-")+"tag-open.xml","meta.tag"+(r?"."+r:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(g,"css-","style"),this.embedTagRules(new l({jsx:!1}).getRules(),"js-","script"),this.constructor===a&&this.normalizeRules()};f.inherits(a,i),h.HtmlHighlightRules=a}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("./fold_mode").FoldMode,g=h.FoldMode=function(l,i){this.defaultMode=l,this.subModes=i};f.inherits(g,p),function(){this.$getMode=function(l){for(var i in"string"!=typeof l&&(l=l[0]),this.subModes)if(0===l.indexOf(i))return this.subModes[i];return null},this.$tryMode=function(l,i,c,a){var u=this.$getMode(l);return u?u.getFoldWidget(i,c,a):""},this.getFoldWidget=function(l,i,c){return this.$tryMode(l.getState(c-1),l,i,c)||this.$tryMode(l.getState(c),l,i,c)||this.defaultMode.getFoldWidget(l,i,c)},this.getFoldWidgetRange=function(l,i,c){var a=this.$getMode(l.getState(c-1));return(!a||!a.getFoldWidget(l,i,c))&&(a=this.$getMode(l.getState(c))),(!a||!a.getFoldWidget(l,i,c))&&(a=this.defaultMode),a.getFoldWidgetRange(l,i,c)}}.call(g.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("./mixed").FoldMode,g=s("./xml").FoldMode,l=s("./cstyle").FoldMode,i=h.FoldMode=function(c,a){p.call(this,new g(c,a),{"js-":new l,"css-":new l})};f.inherits(i,p)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(s,h,v){"use strict";var f=s("../token_iterator").TokenIterator,l=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),i={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},c=Object.keys(i);function a(e,t){return e.type.lastIndexOf(t+".xml")>-1}function u(e,t){for(var n=new f(e,t.row,t.column),d=n.getCurrentToken();d&&!a(d,"tag-name");)d=n.stepBackward();if(d)return d.value}var r=function(){};(function(){this.getCompletions=function(e,t,n,d){var m=t.getTokenAt(n.row,n.column);if(!m)return[];if(a(m,"tag-name")||a(m,"tag-open")||a(m,"end-tag-open"))return this.getTagCompletions(e,t,n,d);if(a(m,"tag-whitespace")||a(m,"attribute-name"))return this.getAttributeCompletions(e,t,n,d);if(a(m,"attribute-value"))return this.getAttributeValueCompletions(e,t,n,d);var x=t.getLine(n.row).substr(0,n.column);return/&[a-z]*$/i.test(x)?this.getHTMLEntityCompletions(e,t,n,d):[]},this.getTagCompletions=function(e,t,n,d){return c.map(function(m){return{value:m,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(e,t,n,d){var m=u(t,n);if(!m)return[];var x=l;return m in i&&(x=x.concat(Object.keys(i[m]))),x.map(function(b){return{caption:b,snippet:b+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(e,t,n,d){var m=u(t,n),x=function o(e,t){for(var n=new f(e,t.row,t.column),d=n.getCurrentToken();d&&!a(d,"attribute-name");)d=n.stepBackward();if(d)return d.value}(t,n);if(!m)return[];var b=[];return m in i&&x in i[m]&&"object"==typeof i[m][x]&&(b=Object.keys(i[m][x])),b.map(function(k){return{caption:k,snippet:k,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(e,t,n,d){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(x){return{caption:x,snippet:x,meta:"html entity",score:1e6}})}}).call(r.prototype),h.HtmlCompletions=r}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("../lib/lang"),g=s("./text").Mode,l=s("./javascript").Mode,i=s("./css").Mode,c=s("./html_highlight_rules").HtmlHighlightRules,a=s("./behaviour/xml").XmlBehaviour,u=s("./folding/html").FoldMode,o=s("./html_completions").HtmlCompletions,r=s("../worker/worker_client").WorkerClient,e=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],t=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],n=function(d){this.fragmentContext=d&&d.fragmentContext,this.HighlightRules=c,this.$behaviour=new a,this.$completer=new o,this.createModeDelegates({"js-":l,"css-":i}),this.foldingRules=new u(this.voidElements,p.arrayToMap(t))};f.inherits(n,g),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=p.arrayToMap(e),this.getNextLineIndent=function(d,m,x){return this.$getIndent(m)},this.checkOutdent=function(d,m,x){return!1},this.getCompletions=function(d,m,x,b){return this.$completer.getCompletions(d,m,x,b)},this.createWorker=function(d){if(this.constructor==n){var m=new r(["ace"],"ace/mode/html_worker","Worker");return m.attachToDocument(d.getDocument()),this.fragmentContext&&m.call("setOptions",[{context:this.fragmentContext}]),m.on("error",function(x){d.setAnnotations(x.data)}),m.on("terminate",function(){d.clearAnnotations()}),m}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(n.prototype),h.Mode=n}),ace.define("ace/mode/astro_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./html_highlight_rules").HtmlHighlightRules,g=s("./javascript_highlight_rules").JavaScriptHighlightRules,l=function(){p.call(this);var i={token:"paren.quasi.start",regex:/{/,next:function(o,r){return"start"!==o&&(-1!==o.indexOf("attribute-equals")?(r.splice(0),r.unshift("tag_stuff")):r.unshift(o)),"inline-js-start"}};for(var c in this.$rules)c.startsWith("js")||c.startsWith("css")||c.startsWith("comment")||this.$rules[c].unshift(i);this.$rules.start.unshift({token:"comment",regex:/^---$/,onMatch:function(o,r,e){return e.splice(0),this.token},next:"javascript-start"}),this.embedRules(g,"javascript-",[{regex:/^---$/,token:"comment",next:"start",onMatch:function(o,r,e){return e.splice(0),this.token}}]),this.embedRules(g,"inline-js-");var a=[{regex:/}/,token:"paren.quasi.end",onMatch:function(o,r,e){return"inline-js-start"===e[0]?(e.shift(),this.next=e.shift(),-1!==this.next.indexOf("string")?"paren.quasi.end":"paren.rparen"):(this.next=e.shift()||"start",this.token)}},{regex:/{/,token:"paren.lparen",push:"inline-js-start"}];function u(o){for(var r in this.$rules[o+"jsxAttributes"])if("meta.tag.punctuation.tag-close.xml"===this.$rules[o+"jsxAttributes"][r].token){this.$rules[o+"jsxAttributes"][r].onMatch=function(e,t,n){return t==n[0]&&n.shift(),2==e.length&&(n[0]==this.nextState&&n[1]--,(!n[1]||n[1]<0)&&n.splice(0,2)),this.next=n[0]||o+"start",[{type:this.token,value:e}]};break}}this.$rules["inline-js-start"].unshift(a),this.$rules["inline-js-no_regex"].unshift(a),u.call(this,"javascript-"),u.call(this,"inline-js-"),this.normalizeRules()};f.inherits(l,p),h.AstroHighlightRules=l}),ace.define("ace/mode/behaviour/html",["require","exports","module","ace/lib/oop","ace/mode/behaviour/xml"],function(s,h,v){"use strict";var f=s("../../lib/oop"),p=s("../behaviour/xml").XmlBehaviour,g=function(){p.call(this)};f.inherits(g,p),h.HtmlBehaviour=g}),ace.define("ace/mode/astro",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/astro_highlight_rules","ace/mode/behaviour/html"],function(s,h,v){"use strict";var f=s("../lib/oop"),p=s("./html").Mode,g=s("./astro_highlight_rules").AstroHighlightRules,l=s("./behaviour/html").HtmlBehaviour,i=function(){p.call(this),this.HighlightRules=g,this.$behaviour=new l};f.inherits(i,p),function(){this.$id="ace/mode/astro"}.call(i.prototype),h.Mode=i}),ace.require(["ace/mode/astro"],function(s){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=s)});