ace.define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:["comment.doc.tag","comment.doc.text","lparen.doc"],regex:"(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:["rparen.doc","text.doc","variable.parameter.doc","lparen.doc","variable.parameter.doc","rparen.doc"],regex:/(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.\-\'\" ]+)(\])))/,next:"pop"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","lparen.doc"],regex:"(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|implements|external|exception|throws|enum|define|extends))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:'(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|requires|param|implements|function|extends|typedef|mixes|constructor|var|memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#.:/~"\\-]*)?'},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@method)(\\s+)(\\w[\\w.\\(\\)]*)"},{token:"comment.doc.tag",regex:"@access\\s+(?:private|public|protected)"},{token:"comment.doc.tag",regex:"@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"},{token:"comment.doc.tag",regex:"@\\w+(?=\\s|$)"},g.getTagRule(),{defaultToken:"comment.doc.body",caseInsensitive:!0}],"doc-syntax":[{token:"operator.doc",regex:/[|:]/},{token:"paren.doc",regex:/[\[\]]/}]},this.normalizeRules()};f.inherits(g,p),g.getTagRule=function(i){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},g.getStartRule=function(i){return{token:"comment.doc",regex:/\/\*\*(?!\/)/,next:i}},g.getEndRule=function(i){return{token:"comment.doc",regex:"\\*\\/",next:i}},h.JsDocCommentHighlightRules=g}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules,g=u("./text_highlight_rules").TextHighlightRules,i="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",n=function(c){var l={"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},o=this.createKeywordMapper(l,"identifier"),t="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)",a="(function)(\\s*)(\\*?)",d={token:["identifier","text","paren.lparen"],regex:"(\\b(?!"+Object.values(l).join("|")+"\\b)"+i+")(\\s*)(\\()"};this.$rules={no_regex:[p.getStartRule("doc-start"),r("no_regex"),d,{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)"+a+"(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|debug|time|trace|timeEnd|assert)\b/},{token:o,regex:i},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:"keyword.operator",regex:/=/},{token:["storage.type","text","storage.type","text","paren.lparen"],regex:a+"(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","storage.type","text","text","entity.name.function","text","paren.lparen"],regex:"(function)(?:(?:(\\s*)(\\*)(\\s*))|(\\s+))(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:"prototype"},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:i},{regex:"",token:"empty",next:"no_regex"}],start:[p.getStartRule("doc-start"),r("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[r("function_arguments"),{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:t},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!c||!c.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(m,x,b){if(this.next="{"==m?this.nextState:"","{"==m&&b.length)b.unshift("start",x);else if("}"==m&&b.length&&(b.shift(),this.next=b.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==m?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:t},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+i+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=[^\\(]+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!c||0!=c.jsx)&&s.call(this)),this.embedRules(p,"doc-",[p.getEndRule("no_regex")]),this.normalizeRules()};function s(){var c=i.replace("\\d","\\d\\-"),l={onMatch:function(e,t,a){var d="/"==e.charAt(1)?2:1;return 1==d?(t!=this.nextState?a.unshift(this.next,this.nextState,0):a.unshift(this.next),a[2]++):2==d&&t==this.nextState&&(a[1]--,(!a[1]||a[1]<0)&&(a.shift(),a.shift())),[{type:"meta.tag.punctuation."+(1==d?"":"end-")+"tag-open.xml",value:e.slice(0,d)},{type:"meta.tag.tag-name.xml",value:e.substr(d)}]},regex:"</?(?:"+c+"|(?=>))",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(l);var o={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[o,l,{include:"reference"},{defaultToken:"string.xml"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(e,t,a){return t==a[0]&&a.shift(),2==e.length&&(a[0]==this.nextState&&a[1]--,(!a[1]||a[1]<0)&&a.splice(0,2)),this.next=a[0]||"start",[{type:this.token,value:e}]},nextState:"jsx"},o,r("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:c},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},l],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function r(c){return[{token:"comment",regex:/\/\*/,next:[p.getTagRule(),{token:"comment",regex:"\\*\\/",next:c||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[p.getTagRule(),{token:"comment",regex:"$|^",next:c||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}f.inherits(n,g),h.JavaScriptHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(u,h,v){"use strict";var f=u("../range").Range,p=function(){};(function(){this.checkOutdent=function(g,i){return!!/^\s+$/.test(g)&&/^\s*\}/.test(i)},this.autoOutdent=function(g,i){var s=g.getLine(i).match(/^(\s*\})/);if(!s)return 0;var r=s[1].length,c=g.findMatchingBracket({row:i,column:r});if(!c||c.row==i)return 0;var l=this.$getIndent(g.getLine(c.row));g.replace(new f(i,0,i,r-1),l)},this.$getIndent=function(g){return g.match(/^\s*/)[0]}}).call(p.prototype),h.MatchingBraceOutdent=p}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("../behaviour").Behaviour,g=u("../../token_iterator").TokenIterator;function i(s,r){return s&&s.type.lastIndexOf(r+".xml")>-1}var n=function(){this.add("string_dquotes","insertion",function(s,r,c,l,o){if('"'==o||"'"==o){var e=o,t=l.doc.getTextRange(c.getSelectionRange());if(""!==t&&"'"!==t&&'"'!=t&&c.getWrapBehavioursEnabled())return{text:e+t+e,selection:!1};var a=c.getCursorPosition(),m=l.doc.getLine(a.row).substring(a.column,a.column+1),x=new g(l,a.row,a.column),b=x.getCurrentToken();if(m==e&&(i(b,"attribute-value")||i(b,"string")))return{text:"",selection:[1,1]};if(b||(b=x.stepBackward()),!b)return;for(;i(b,"tag-whitespace")||i(b,"whitespace");)b=x.stepBackward();var k=!m||m.match(/\s/);if(i(b,"attribute-equals")&&(k||">"==m)||i(b,"decl-attribute-equals")&&(k||"?"==m))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(s,r,c,l,o){var e=l.doc.getTextRange(o);if(!o.isMultiLine()&&('"'==e||"'"==e)&&l.doc.getLine(o.start.row).substring(o.start.column+1,o.start.column+2)==e)return o.end.column++,o}),this.add("autoclosing","insertion",function(s,r,c,l,o){if(">"==o){var e=c.getSelectionRange().start,t=new g(l,e.row,e.column),a=t.getCurrentToken()||t.stepBackward();if(!a||!(i(a,"tag-name")||i(a,"tag-whitespace")||i(a,"attribute-name")||i(a,"attribute-equals")||i(a,"attribute-value"))||i(a,"reference.attribute-value"))return;if(i(a,"attribute-value")){var d=t.getCurrentTokenColumn()+a.value.length;if(e.column<d)return;if(e.column==d){var m=t.stepForward();if(m&&i(m,"attribute-value"))return;t.stepBackward()}}if(/^\s*>/.test(l.getLine(e.row).slice(e.column)))return;for(;!i(a,"tag-name");)if("<"==(a=t.stepBackward()).value){a=t.stepForward();break}var x=t.getCurrentTokenRow(),b=t.getCurrentTokenColumn();if(i(t.stepBackward(),"end-tag-open"))return;var k=a.value;return x==e.row&&(k=k.substring(0,e.column-b)),this.voidElements&&this.voidElements.hasOwnProperty(k.toLowerCase())?void 0:{text:"></"+k+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(s,r,c,l,o){if("\n"==o){var e=c.getCursorPosition(),t=l.getLine(e.row),a=new g(l,e.row,e.column),d=a.getCurrentToken();if(i(d,"")&&-1!==d.type.indexOf("tag-close")){if("/>"==d.value)return;for(;d&&-1===d.type.indexOf("tag-name");)d=a.stepBackward();if(!d)return;var m=d.value,x=a.getCurrentTokenRow();if(!(d=a.stepBackward())||-1!==d.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[m]||!this.voidElements){var b=l.getTokenAt(e.row,e.column+1),k=(t=l.getLine(x),this.$getIndent(t)),y=k+l.getTabString();return b&&"</"===b.value?{text:"\n"+y+"\n"+k,selection:[1,y.length,1,y.length]}:{text:"\n"+y}}}}})};f.inherits(n,p),h.XmlBehaviour=n}),ace.define("ace/mode/behaviour/javascript",["require","exports","module","ace/lib/oop","ace/token_iterator","ace/mode/behaviour/cstyle","ace/mode/behaviour/xml"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("../../token_iterator").TokenIterator,g=u("../behaviour/cstyle").CstyleBehaviour,i=u("../behaviour/xml").XmlBehaviour,n=function(){var s=new i({closeCurlyBraces:!0}).getBehaviours();this.addBehaviours(s),this.inherit(g),this.add("autoclosing-fragment","insertion",function(r,c,l,o,e){if(">"==e){var t=l.getSelectionRange().start,a=new p(o,t.row,t.column),d=a.getCurrentToken()||a.stepBackward();if(!d)return;if("<"==d.value)return{text:"></>",selection:[1,1]}}})};f.inherits(n,g),h.JavaScriptBehaviour=n}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("../../range").Range,g=u("./fold_mode").FoldMode,i=h.FoldMode=function(r,c){g.call(this),this.voidElements=r||{},this.optionalEndTags=f.mixin({},this.voidElements),c&&f.mixin(this.optionalEndTags,c)};f.inherits(i,g);var n=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function s(r,c){return r&&r.type&&r.type.lastIndexOf(c+".xml")>-1}(function(){this.getFoldWidget=function(r,c,l){var o=this._getFirstTagInLine(r,l);return o?o.closing||!o.tagName&&o.selfClosing?"markbeginend"===c?"end":"":!o.tagName||o.selfClosing||this.voidElements.hasOwnProperty(o.tagName.toLowerCase())||this._findEndTagInLine(r,l,o.tagName,o.end.column)?"":"start":this.getCommentFoldWidget(r,l)},this.getCommentFoldWidget=function(r,c){return/comment/.test(r.getState(c))&&/<!-/.test(r.getLine(c))?"start":""},this._getFirstTagInLine=function(r,c){for(var l=r.getTokens(c),o=new n,e=0;e<l.length;e++){var t=l[e];if(s(t,"tag-open")){if(o.end.column=o.start.column+t.value.length,o.closing=s(t,"end-tag-open"),!(t=l[++e]))return null;if(o.tagName=t.value,""===t.value){if(!(t=l[++e]))return null;o.tagName=t.value}for(o.end.column+=t.value.length,e++;e<l.length;e++)if(o.end.column+=(t=l[e]).value.length,s(t,"tag-close")){o.selfClosing="/>"==t.value;break}return o}if(s(t,"tag-close"))return o.selfClosing="/>"==t.value,o;o.start.column+=t.value.length}return null},this._findEndTagInLine=function(r,c,l,o){for(var e=r.getTokens(c),t=0,a=0;a<e.length;a++){var d=e[a];if(!((t+=d.value.length)<o-1)&&s(d,"end-tag-open")&&(s(d=e[a+1],"tag-name")&&""===d.value&&(d=e[a+2]),d&&d.value==l))return!0}return!1},this.getFoldWidgetRange=function(r,c,l){if(!this._getFirstTagInLine(r,l))return this.getCommentFoldWidget(r,l)&&r.getCommentFoldRange(l,r.getLine(l).length);var e=r.getMatchingTags({row:l,column:0});return e?new p(e.openTag.end.row,e.openTag.end.column,e.closeTag.start.row,e.closeTag.start.column):void 0}}).call(i.prototype)}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("../../range").Range,g=u("./fold_mode").FoldMode,i=h.FoldMode=function(n){n&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+n.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+n.end)))};f.inherits(i,g),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(n,s,r){var c=n.getLine(r);if(this.singleLineBlockCommentRe.test(c)&&!this.startRegionRe.test(c)&&!this.tripleStarBlockCommentRe.test(c))return"";var l=this._getFoldWidgetBase(n,s,r);return!l&&this.startRegionRe.test(c)?"start":l},this.getFoldWidgetRange=function(n,s,r,c){var t,l=n.getLine(r);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(n,l,r);if(t=l.match(this.foldingStartMarker)){var o=t.index;if(t[1])return this.openingBracketBlock(n,t[1],r,o);var e=n.getCommentFoldRange(r,o+t[0].length,1);return e&&!e.isMultiLine()&&(c?e=this.getSectionRange(n,r):"all"!=s&&(e=null)),e}return"markbegin"!==s&&(t=l.match(this.foldingStopMarker))?(o=t.index+t[0].length,t[1]?this.closingBracketBlock(n,t[1],r,o):n.getCommentFoldRange(r,o,-1)):void 0},this.getSectionRange=function(n,s){for(var r=n.getLine(s),c=r.search(/\S/),l=s,o=r.length,e=s+=1,t=n.getLength();++s<t;){var a=(r=n.getLine(s)).search(/\S/);if(-1!==a){if(c>a)break;var d=this.getFoldWidgetRange(n,"all",s);if(d){if(d.start.row<=l)break;if(d.isMultiLine())s=d.end.row;else if(c==a)break}e=s}}return new p(l,o,e,n.getLine(e).length)},this.getCommentRegionBlock=function(n,s,r){for(var c=s.search(/\s*$/),l=n.getLength(),o=r,e=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++r<l;){s=n.getLine(r);var a=e.exec(s);if(a&&(a[1]?t--:t++,!t))break}if(r>o)return new p(o,c,r,s.length)}}.call(i.prototype)}),ace.define("ace/mode/folding/javascript",["require","exports","module","ace/lib/oop","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("./xml").FoldMode,g=u("./cstyle").FoldMode,i=h.FoldMode=function(n){n&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+n.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+n.end))),this.xmlFoldMode=new p};f.inherits(i,g),function(){this.getFoldWidgetRangeBase=this.getFoldWidgetRange,this.getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(n,s,r){return this.getFoldWidgetBase(n,s,r)||this.xmlFoldMode.getFoldWidget(n,s,r)},this.getFoldWidgetRange=function(n,s,r,c){return this.getFoldWidgetRangeBase(n,s,r,c)||this.xmlFoldMode.getFoldWidgetRange(n,s,r)}}.call(i.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/javascript","ace/mode/folding/javascript"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./text").Mode,g=u("./javascript_highlight_rules").JavaScriptHighlightRules,i=u("./matching_brace_outdent").MatchingBraceOutdent,n=u("../worker/worker_client").WorkerClient,s=u("./behaviour/javascript").JavaScriptBehaviour,r=u("./folding/javascript").FoldMode,c=function(){this.HighlightRules=g,this.$outdent=new i,this.$behaviour=new s,this.foldingRules=new r};f.inherits(c,p),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.$pairQuotesAfter={"`":/\w/},this.getNextLineIndent=function(l,o,e){var t=this.$getIndent(o),a=this.getTokenizer().getLineTokens(o,l),d=a.tokens,m=a.state;if(d.length&&"comment"==d[d.length-1].type)return t;if("start"==l||"no_regex"==l)o.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/)&&(t+=e);else if("doc-start"==l&&("start"==m||"no_regex"==m))return"";return t},this.checkOutdent=function(l,o,e){return this.$outdent.checkOutdent(o,e)},this.autoOutdent=function(l,o,e){this.$outdent.autoOutdent(o,e)},this.createWorker=function(l){var o=new n(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return o.attachToDocument(l.getDocument()),o.on("annotate",function(e){l.setAnnotations(e.data)}),o.on("terminate",function(){l.clearAnnotations()}),o},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(c.prototype),h.Mode=c}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),g=(u("../lib/lang"),u("./text_highlight_rules").TextHighlightRules),i=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",n=h.supportFunction="rgb|rgba|url|attr|counter|counters",s=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",r=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",c=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",l=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",o=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",e=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",t=function(){var a=this.createKeywordMapper({"support.function":n,"support.constant":s,"support.type":i,"support.constant.color":r,"support.constant.fonts":c},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:l},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+l+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:l},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:o},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:e},{include:"url"},{token:a,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{token:"paren.lparen",regex:"\\{"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};f.inherits(t,g),h.CssHighlightRules=t}),ace.define("ace/mode/css_completions",["require","exports","module"],function(u,h,v){"use strict";var f={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},p=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var g=document.createElement("c").style;for(var i in g)if("string"==typeof g[i]){var n=i.replace(/[A-Z]/g,function(s){return"-"+s.toLowerCase()});f.hasOwnProperty(n)||(f[n]=1)}}this.completionsDefined=!0},this.getCompletions=function(g,i,n,s){if(this.completionsDefined||this.defineCompletions(),"ruleset"===g||"ace/mode/scss"==i.$mode.$id){var r=i.getLine(n.row).substr(0,n.column),c=/\([^)]*$/.test(r);return c&&(r=r.substr(r.lastIndexOf("(")+1)),/:[^;]+$/.test(r)?(/([\w\-]+):[^:]*$/.test(r),this.getPropertyValueCompletions(g,i,n,s)):this.getPropertyCompletions(g,i,n,s,c)}return[]},this.getPropertyCompletions=function(g,i,n,s,r){return r=r||!1,Object.keys(f).map(function(l){return{caption:l,snippet:l+": $0"+(r?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(g,i,n,s){var r=i.getLine(n.row).substr(0,n.column),c=(/([\w\-]+):[^:]*$/.exec(r)||{})[1];if(!c)return[];var l=[];return c in f&&"object"==typeof f[c]&&(l=Object.keys(f[c])),l.map(function(o){return{caption:o,snippet:o,meta:"property value",score:1e6}})}}).call(p.prototype),h.CssCompletions=p}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(u,h,v){"use strict";var f=u("../../lib/oop"),g=(u("../behaviour"),u("./cstyle").CstyleBehaviour),i=u("../../token_iterator").TokenIterator,n=function(){this.inherit(g),this.add("colon","insertion",function(s,r,c,l,o){if(":"===o&&c.selection.isEmpty()){var e=c.getCursorPosition(),t=new i(l,e.row,e.column),a=t.getCurrentToken();if(a&&a.value.match(/\s+/)&&(a=t.stepBackward()),a&&"support.type"===a.type){var d=l.doc.getLine(e.row);if(":"===d.substring(e.column,e.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(d.substring(e.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(s,r,c,l,o){var e=l.doc.getTextRange(o);if(!o.isMultiLine()&&":"===e){var t=c.getCursorPosition(),a=new i(l,t.row,t.column),d=a.getCurrentToken();if(d&&d.value.match(/\s+/)&&(d=a.stepBackward()),d&&"support.type"===d.type&&";"===l.doc.getLine(o.start.row).substring(o.end.column,o.end.column+1))return o.end.column++,o}}),this.add("semicolon","insertion",function(s,r,c,l,o){if(";"===o&&c.selection.isEmpty()){var e=c.getCursorPosition();if(";"===l.doc.getLine(e.row).substring(e.column,e.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(s,r,c,l,o){if("!"===o&&c.selection.isEmpty()){var e=c.getCursorPosition(),t=l.doc.getLine(e.row);if(/^\s*(;|}|$)/.test(t.substring(e.column)))return{text:"!important",selection:[10,10]}}})};f.inherits(n,g),h.CssBehaviour=n}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./text").Mode,g=u("./css_highlight_rules").CssHighlightRules,i=u("./matching_brace_outdent").MatchingBraceOutdent,n=u("../worker/worker_client").WorkerClient,s=u("./css_completions").CssCompletions,r=u("./behaviour/css").CssBehaviour,c=u("./folding/cstyle").FoldMode,l=function(){this.HighlightRules=g,this.$outdent=new i,this.$behaviour=new r,this.$completer=new s,this.foldingRules=new c};f.inherits(l,p),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(o,e,t){var a=this.$getIndent(e),d=this.getTokenizer().getLineTokens(e,o).tokens;return d.length&&"comment"==d[d.length-1].type||e.match(/^.*\{\s*$/)&&(a+=t),a},this.checkOutdent=function(o,e,t){return this.$outdent.checkOutdent(e,t)},this.autoOutdent=function(o,e,t){this.$outdent.autoOutdent(e,t)},this.getCompletions=function(o,e,t,a){return this.$completer.getCompletions(o,e,t,a)},this.createWorker=function(o){var e=new n(["ace"],"ace/mode/css_worker","Worker");return e.attachToDocument(o.getDocument()),e.on("annotate",function(t){o.setAnnotations(t.data)}),e.on("terminate",function(){o.clearAnnotations()}),e},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(l.prototype),h.Mode=l}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./text_highlight_rules").TextHighlightRules,g=function(i){var n="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+n+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:n},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+n+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+n+":)?"+n+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:n},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===g&&this.normalizeRules()};(function(){this.embedTagRules=function(i,n,s){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+s+".tag-name.xml"],regex:"(<)("+s+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:n+"start"}]}),this.$rules[s+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(r,c,l){return l.splice(0),this.token}}],this.embedRules(i,n,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+s+".tag-name.xml"],regex:"(</)("+s+"(?=\\s|>|$))",next:s+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(p.prototype),f.inherits(g,p),h.XmlHighlightRules=g}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("../lib/lang"),g=u("./css_highlight_rules").CssHighlightRules,i=u("./javascript_highlight_rules").JavaScriptHighlightRules,n=u("./xml_highlight_rules").XmlHighlightRules,s=p.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),r=function(){n.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(c,l){var o=s[l];return["meta.tag.punctuation."+("<"==c?"":"end-")+"tag-open.xml","meta.tag"+(o?"."+o:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(g,"css-","style"),this.embedTagRules(new i({jsx:!1}).getRules(),"js-","script"),this.constructor===r&&this.normalizeRules()};f.inherits(r,n),h.HtmlHighlightRules=r}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("./fold_mode").FoldMode,g=h.FoldMode=function(i,n){this.defaultMode=i,this.subModes=n};f.inherits(g,p),function(){this.$getMode=function(i){for(var n in"string"!=typeof i&&(i=i[0]),this.subModes)if(0===i.indexOf(n))return this.subModes[n];return null},this.$tryMode=function(i,n,s,r){var c=this.$getMode(i);return c?c.getFoldWidget(n,s,r):""},this.getFoldWidget=function(i,n,s){return this.$tryMode(i.getState(s-1),i,n,s)||this.$tryMode(i.getState(s),i,n,s)||this.defaultMode.getFoldWidget(i,n,s)},this.getFoldWidgetRange=function(i,n,s){var r=this.$getMode(i.getState(s-1));return(!r||!r.getFoldWidget(i,n,s))&&(r=this.$getMode(i.getState(s))),(!r||!r.getFoldWidget(i,n,s))&&(r=this.defaultMode),r.getFoldWidgetRange(i,n,s)}}.call(g.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(u,h,v){"use strict";var f=u("../../lib/oop"),p=u("./mixed").FoldMode,g=u("./xml").FoldMode,i=u("./cstyle").FoldMode,n=h.FoldMode=function(s,r){p.call(this,new g(s,r),{"js-":new i,"css-":new i})};f.inherits(n,p)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(u,h,v){"use strict";var f=u("../token_iterator").TokenIterator,i=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),n={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},s=Object.keys(n);function r(e,t){return e.type.lastIndexOf(t+".xml")>-1}function c(e,t){for(var a=new f(e,t.row,t.column),d=a.getCurrentToken();d&&!r(d,"tag-name");)d=a.stepBackward();if(d)return d.value}var o=function(){};(function(){this.getCompletions=function(e,t,a,d){var m=t.getTokenAt(a.row,a.column);if(!m)return[];if(r(m,"tag-name")||r(m,"tag-open")||r(m,"end-tag-open"))return this.getTagCompletions(e,t,a,d);if(r(m,"tag-whitespace")||r(m,"attribute-name"))return this.getAttributeCompletions(e,t,a,d);if(r(m,"attribute-value"))return this.getAttributeValueCompletions(e,t,a,d);var x=t.getLine(a.row).substr(0,a.column);return/&[a-z]*$/i.test(x)?this.getHTMLEntityCompletions(e,t,a,d):[]},this.getTagCompletions=function(e,t,a,d){return s.map(function(m){return{value:m,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(e,t,a,d){var m=c(t,a);if(!m)return[];var x=i;return m in n&&(x=x.concat(Object.keys(n[m]))),x.map(function(b){return{caption:b,snippet:b+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(e,t,a,d){var m=c(t,a),x=function l(e,t){for(var a=new f(e,t.row,t.column),d=a.getCurrentToken();d&&!r(d,"attribute-name");)d=a.stepBackward();if(d)return d.value}(t,a);if(!m)return[];var b=[];return m in n&&x in n[m]&&"object"==typeof n[m][x]&&(b=Object.keys(n[m][x])),b.map(function(k){return{caption:k,snippet:k,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(e,t,a,d){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(x){return{caption:x,snippet:x,meta:"html entity",score:1e6}})}}).call(o.prototype),h.HtmlCompletions=o}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("../lib/lang"),g=u("./text").Mode,i=u("./javascript").Mode,n=u("./css").Mode,s=u("./html_highlight_rules").HtmlHighlightRules,r=u("./behaviour/xml").XmlBehaviour,c=u("./folding/html").FoldMode,l=u("./html_completions").HtmlCompletions,o=u("../worker/worker_client").WorkerClient,e=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],t=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],a=function(d){this.fragmentContext=d&&d.fragmentContext,this.HighlightRules=s,this.$behaviour=new r,this.$completer=new l,this.createModeDelegates({"js-":i,"css-":n}),this.foldingRules=new c(this.voidElements,p.arrayToMap(t))};f.inherits(a,g),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=p.arrayToMap(e),this.getNextLineIndent=function(d,m,x){return this.$getIndent(m)},this.checkOutdent=function(d,m,x){return!1},this.getCompletions=function(d,m,x,b){return this.$completer.getCompletions(d,m,x,b)},this.createWorker=function(d){if(this.constructor==a){var m=new o(["ace"],"ace/mode/html_worker","Worker");return m.attachToDocument(d.getDocument()),this.fragmentContext&&m.call("setOptions",[{context:this.fragmentContext}]),m.on("error",function(x){d.setAnnotations(x.data)}),m.on("terminate",function(){d.clearAnnotations()}),m}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(a.prototype),h.Mode=a}),ace.define("ace/mode/visualforce_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("../mode/html_highlight_rules").HtmlHighlightRules;function g(n){return{token:n.token+".start",regex:n.start,push:[{token:"constant.language.escape",regex:n.escape},{token:n.token+".end",regex:n.start,next:"pop"},{defaultToken:n.token}]}}var i=function(){var n=this.createKeywordMapper({"variable.language":"$Action|$Api|$Component|$ComponentLabel|$CurrentPage|$FieldSet|$Label|$Label|$ObjectType|$Organization|$Page|$Permission|$Profile|$Resource|$SControl|$Setup|$Site|$System.OriginDateTime|$User|$UserRole|Site|UITheme|UIThemeDisplayed",keyword:"","storage.type":"","constant.language":"true|false|null|TRUE|FALSE|NULL","support.function":"DATE|DATEVALUE|DATETIMEVALUE|DAY|MONTH|NOW|TODAY|YEAR|BLANKVALUE|ISBLANK|NULLVALUE|PRIORVALUE|AND|CASE|IF|ISCHANGED|ISNEW|ISNUMBER|NOT|OR|ABS|CEILING|EXP|FLOOR|LN|LOG|MAX|MIN|MOD|ROUND|SQRT|BEGINS|BR|CASESAFEID|CONTAINS|FIND|GETSESSIONID|HTMLENCODE|ISPICKVAL|JSENCODE|JSINHTMLENCODE|LEFT|LEN|LOWER|LPAD|MID|RIGHT|RPAD|SUBSTITUTE|TEXT|TRIM|UPPER|URLENCODE|VALUE|GETRECORDIDS|INCLUDE|LINKTO|REGEX|REQUIRESCRIPT|URLFOR|VLOOKUP|HTMLENCODE|JSENCODE|JSINHTMLENCODE|URLENCODE"},"identifier");p.call(this);var s={token:"keyword.start",regex:"{!",push:"Visualforce"};for(var r in this.$rules)this.$rules[r].unshift(s);this.$rules.Visualforce=[g({start:'"',escape:/\\[btnfr"'\\]/,token:"string",multiline:!0}),g({start:"'",escape:/\\[btnfr"'\\]/,token:"string",multiline:!0}),{token:"comment.start",regex:"\\/\\*",push:[{token:"comment.end",regex:"\\*\\/|(?=})",next:"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"keyword.end",regex:"}",next:"pop"},{token:n,regex:/[a-zA-Z$_\u00a1-\uffff][a-zA-Z\d$_\u00a1-\uffff]*\b/},{token:"keyword.operator",regex:/==|<>|!=|<=|>=|&&|\|\||[+\-*/^()=<>&]/},{token:"punctuation.operator",regex:/[?:,;.]/},{token:"paren.lparen",regex:/[\[({]/},{token:"paren.rparen",regex:/[\])}]/}],this.normalizeRules()};f.inherits(i,p),h.VisualforceHighlightRules=i}),ace.define("ace/mode/visualforce",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/visualforce_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html"],function(u,h,v){"use strict";var f=u("../lib/oop"),p=u("./html").Mode,g=u("./visualforce_highlight_rules").VisualforceHighlightRules,i=u("./behaviour/xml").XmlBehaviour,n=u("./folding/html").FoldMode;function s(){p.call(this),this.HighlightRules=g,this.foldingRules=new n,this.$behaviour=new i}f.inherits(s,p),s.prototype.emmetConfig={profile:"xhtml"},h.Mode=s}),ace.require(["ace/mode/visualforce"],function(u){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=u)});