ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(S,v,K){"use strict";var V=S("./lib/dom"),z=S("./lib/oop"),B=S("./lib/event_emitter").EventEmitter,O=S("./lib/lang"),$=S("./range").Range,T=S("./range_list").RangeList,L=S("./keyboard/hash_handler").HashHandler,P=S("./tokenizer").Tokenizer,A=S("./clipboard"),R={CURRENT_WORD:function(r){return r.session.getTextRange(r.session.getWordRange())},SELECTION:function(r,e,t){var a=r.session.getTextRange();return t?a.replace(/\n\r?([ \t]*\S)/g,"\n"+t+"$1"):a},CURRENT_LINE:function(r){return r.session.getLine(r.getCursorPosition().row)},PREV_LINE:function(r){return r.session.getLine(r.getCursorPosition().row-1)},LINE_INDEX:function(r){return r.getCursorPosition().row},LINE_NUMBER:function(r){return r.getCursorPosition().row+1},SOFT_TABS:function(r){return r.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(r){return r.session.getTabSize()},CLIPBOARD:function(r){return A.getText&&A.getText()},FILENAME:function(r){return/[^/\\]*$/.exec(this.FILEPATH(r))[0]},FILENAME_BASE:function(r){return/[^/\\]*$/.exec(this.FILEPATH(r))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(r){return this.FILEPATH(r).replace(/[^/\\]*$/,"")},FILEPATH:function(r){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(r){var e=r.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(r){var e=r.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(r){return(r.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:E.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:E.bind(null,{year:"2-digit"}),CURRENT_MONTH:E.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:E.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:E.bind(null,{month:"short"}),CURRENT_DATE:E.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:E.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:E.bind(null,{weekday:"short"}),CURRENT_HOUR:E.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:E.bind(null,{minute:"2-digit"}),CURRENT_SECOND:E.bind(null,{second:"2-digit"})};function E(r){var e=(new Date).toLocaleString("en-us",r);return 1==e.length?"0"+e:e}R.SELECTED_TEXT=R.SELECTION;var I=function(){function r(){this.snippetMap={},this.snippetNameMap={},this.variables=R}return r.prototype.getTokenizer=function(){return r.$tokenizer||this.createTokenizer()},r.prototype.createTokenizer=function(){function e(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function t(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var a={regex:"/("+t("/")+"+)/",onMatch:function(i,s,c){var n=c[0];return n.fmtString=!0,n.guard=i.slice(1,-1),n.flag="",""},next:"formatString"};return r.$tokenizer=new P({start:[{regex:/\\./,onMatch:function(i,s,c){var n=i[1];return("}"==n&&c.length||-1!="`$\\".indexOf(n))&&(i=n),[i]}},{regex:/}/,onMatch:function(i,s,c){return[c.length?c.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,s,c){var n=e(i.substr(1));return c.unshift(n[0]),n},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(i,s,c){var n=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(p){return 2==p.length?p[1]:"\0"}).split("\0").map(function(p){return{value:p}});return c[0].choices=n,[n[0]]},next:"start"},a,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,s,c){return c.length&&c[0].expectElse?(c[0].expectElse=!1,c[0].ifEnd={elseEnd:c[0]},[c[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,s,c){var n=i[1];return"}"==n&&c.length||-1!="`$\\".indexOf(n)?i=n:"n"==n?i="\n":"t"==n?i="\t":-1!="ulULE".indexOf(n)&&(i={changeCase:n,local:n>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,s,c){var n=c.shift();return n&&(n.flag=i.slice(1,-1)),this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,s,c){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,s,c){var n={text:i.slice(2)};return c.unshift(n),[n]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,s,c){var n=c.shift();return this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,s,c){return c[0].formatFunction=i.slice(2,-1),[c.shift()]},next:"formatString"},a,{regex:/:[\?\-+]?/,onMatch:function(i,s,c){"+"==i[1]&&(c[0].ifEnd=c[0]),"?"==i[1]&&(c[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},r.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(a){return a.value||a})},r.prototype.getVariableValue=function(e,t,a){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var i=this.variables[t];return"function"==typeof i&&(i=this.variables[t](e,t,a)),i??""},r.prototype.tmStrFormat=function(e,t,a){if(!t.fmt)return e;var s=t.guard;s=new RegExp(s,(t.flag||"").replace(/[^gim]/g,""));var c="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,n=this,p=e.replace(s,function(){var o=n.variables.__;n.variables.__=[].slice.call(arguments);for(var h=n.resolveVariables(c,a),b="E",u=0;u<h.length;u++){var y=h[u];if("object"==typeof y)if(h[u]="",y.changeCase&&y.local){var _=h[u+1];_&&"string"==typeof _&&(h[u]="u"==y.changeCase?_[0].toUpperCase():_[0].toLowerCase(),h[u+1]=_.substr(1))}else y.changeCase&&(b=y.changeCase);else"U"==b?h[u]=y.toUpperCase():"L"==b&&(h[u]=y.toLowerCase())}return n.variables.__=o,h.join("")});return p},r.prototype.tmFormatFunction=function(e,t,a){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},r.prototype.resolveVariables=function(e,t){for(var a=[],i="",s=!0,c=0;c<e.length;c++){var n=e[c];if("string"!=typeof n){if(n){if(s=!1,n.fmtString){var p=e.indexOf(n,c+1);-1==p&&(p=e.length),n.fmt=e.slice(c+1,p),c=p}if(n.text){var o=this.getVariableValue(t,n.text,i)+"";n.fmtString&&(o=this.tmStrFormat(o,n,t)),n.formatFunction&&(o=this.tmFormatFunction(o,n,t)),o&&!n.ifEnd?(a.push(o),h(n)):!o&&n.ifEnd&&h(n.ifEnd)}else n.elseEnd?h(n.elseEnd):(null!=n.tabstopId||null!=n.changeCase)&&a.push(n)}}else a.push(n),"\n"==n?(s=!0,i=""):s&&(i=/^\t*/.exec(n)[0],s=/\S/.test(n))}function h(b){var u=e.indexOf(b,c+1);-1!=u&&(c=u)}return a},r.prototype.getDisplayTextForSnippet=function(e,t){return l.call(this,e,t).text},r.prototype.insertSnippetForSelection=function(e,t,a){void 0===a&&(a={});var i=l.call(this,e,t,a),s=e.getSelectionRange(),c=e.session.replace(s,i.text);new f(e).addTabstops(i.tabstops,s.start,c,e.inVirtualSelectionMode&&e.selection.index)},r.prototype.insertSnippet=function(e,t,a){void 0===a&&(a={});var i=this;if(e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,t,a);e.forEachSelection(function(){i.insertSnippetForSelection(e,t,a)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},r.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var a=e.getCursorPosition(),i=e.session.getState(a.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?t="javascript":"css-"==i.substring(0,4)?t="css":"php-"==i.substring(0,4)&&(t="php"))}return t},r.prototype.getActiveScopes=function(e){var t=this.$getScope(e),a=[t],i=this.snippetMap;return i[t]&&i[t].includeScopes&&a.push.apply(a,i[t].includeScopes),a.push("_"),a},r.prototype.expandWithTab=function(e,t){var a=this,i=e.forEachSelection(function(){return a.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},r.prototype.expandSnippetForSelection=function(e,t){var p,a=e.getCursorPosition(),i=e.session.getLine(a.row),s=i.substring(0,a.column),c=i.substr(a.column),n=this.snippetMap;return this.getActiveScopes(e).some(function(o){var h=n[o];return h&&(p=this.findMatchingSnippet(h,s,c)),!!p},this),!!p&&(t&&t.dryRun||(e.session.doc.removeInLine(a.row,a.column-p.replaceBefore.length,a.column+p.replaceAfter.length),this.variables.M__=p.matchBefore,this.variables.T__=p.matchAfter,this.insertSnippetForSelection(e,p.content),this.variables.M__=this.variables.T__=null),!0)},r.prototype.findMatchingSnippet=function(e,t,a){for(var i=e.length;i--;){var s=e[i];if((!s.startRe||s.startRe.test(t))&&(!s.endRe||s.endRe.test(a))&&(s.startRe||s.endRe))return s.matchBefore=s.startRe?s.startRe.exec(t):[""],s.matchAfter=s.endRe?s.endRe.exec(a):[""],s.replaceBefore=s.triggerRe?s.triggerRe.exec(t)[0]:"",s.replaceAfter=s.endTriggerRe?s.endTriggerRe.exec(a)[0]:"",s}},r.prototype.register=function(e,t){var a=this.snippetMap,i=this.snippetNameMap,s=this;function c(o){return o&&!/^\^?\(.*\)\$?$|^\\b$/.test(o)&&(o="(?:"+o+")"),o||""}function n(o,h,b){return o=c(o),h=c(h),b?(o=h+o)&&"$"!=o[o.length-1]&&(o+="$"):(o+=h)&&"^"!=o[0]&&(o="^"+o),new RegExp(o)}function p(o){o.scope||(o.scope=t||"_"),a[t=o.scope]||(a[t]=[],i[t]={});var h=i[t];if(o.name){var b=h[o.name];b&&s.unregister(b),h[o.name]=o}a[t].push(o),o.prefix&&(o.tabTrigger=o.prefix),!o.content&&o.body&&(o.content=Array.isArray(o.body)?o.body.join("\n"):o.body),o.tabTrigger&&!o.trigger&&(!o.guard&&/^\w/.test(o.tabTrigger)&&(o.guard="\\b"),o.trigger=O.escapeRegExp(o.tabTrigger)),(o.trigger||o.guard||o.endTrigger||o.endGuard)&&(o.startRe=n(o.trigger,o.guard,!0),o.triggerRe=new RegExp(o.trigger),o.endRe=n(o.endTrigger,o.endGuard,!0),o.endTriggerRe=new RegExp(o.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(p):Object.keys(e).forEach(function(o){p(e[o])}),this._signal("registerSnippets",{scope:t})},r.prototype.unregister=function(e,t){var a=this.snippetMap,i=this.snippetNameMap;function s(c){var n=i[c.scope||t];if(n&&n[c.name]){delete n[c.name];var p=a[c.scope||t],o=p&&p.indexOf(c);o>=0&&p.splice(o,1)}}e.content?s(e):Array.isArray(e)&&e.forEach(s)},r.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var s,t=[],a={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;s=i.exec(e);){if(s[1])try{a=JSON.parse(s[1]),t.push(a)}catch{}if(s[4])a.content=s[4].replace(/^\t/gm,""),t.push(a),a={};else{var c=s[2],n=s[3];if("regex"==c){var p=/\/((?:[^\/\\]|\\.)*)|$/g;a.guard=p.exec(n)[1],a.trigger=p.exec(n)[1],a.endTrigger=p.exec(n)[1],a.endGuard=p.exec(n)[1]}else"snippet"==c?(a.tabTrigger=n.match(/^\S*/)[0],a.name||(a.name=n)):c&&(a[c]=n)}}return t},r.prototype.getSnippetByName=function(e,t){var i,a=this.snippetNameMap;return this.getActiveScopes(t).some(function(s){var c=a[s];return c&&(i=c[e]),!!i},this),i},r}();z.implement(I.prototype,B);var l=function(r,e,t){void 0===t&&(t={});var a=r.getCursorPosition(),i=r.session.getLine(a.row),s=r.session.getTabString(),c=i.match(/^\s*/)[0];a.column<c.length&&(c=c.slice(0,a.column)),e=e.replace(/\r/g,"");var n=this.tokenizeTmSnippet(e);n=(n=this.resolveVariables(n,r)).map(function(m){return"\n"!=m||t.excludeExtraIndent?"string"==typeof m?m.replace(/\t/g,s):m:m+c});var p=[];n.forEach(function(m,w){if("object"==typeof m){var k=m.tabstopId,x=p[k];if(x||((x=p[k]=[]).index=k,x.value="",x.parents={}),-1===x.indexOf(m)){m.choices&&!x.choices&&(x.choices=m.choices),x.push(m);var H=n.indexOf(m,w+1);if(-1!==H){var U=n.slice(w+1,H);U.some(function(W){return"object"==typeof W})&&!x.value?x.value=U:U.length&&(!x.value||"string"!=typeof x.value)&&(x.value=U.join(""))}}}}),p.forEach(function(m){m.length=0});var o={};function h(m){for(var w=[],k=0;k<m.length;k++){var x=m[k];if("object"==typeof x){if(o[x.tabstopId])continue;x=w[m.lastIndexOf(x,k-1)]||{tabstopId:x.tabstopId}}w[k]=x}return w}for(var b=0;b<n.length;b++){var u=n[b];if("object"==typeof u){var y=u.tabstopId,_=p[y],C=n.indexOf(u,b+1);if(o[y]){o[y]===u&&(delete o[y],Object.keys(o).forEach(function(m){_.parents[m]=!0}));continue}o[y]=u;var N=_.value;"string"!=typeof N?N=h(N):u.fmt&&(N=this.tmStrFormat(N,u,r)),n.splice.apply(n,[b+1,Math.max(0,C-b)].concat(N,u)),-1===_.indexOf(u)&&_.push(u)}}var j=0,F=0,D="";return n.forEach(function(m){if("string"==typeof m){var w=m.split("\n");w.length>1?(F=w[w.length-1].length,j+=w.length-1):F+=m.length,D+=m}else m&&(m.start?m.end={row:j,column:F}:m.start={row:j,column:F})}),{text:D,tabstops:p,tokens:n}},f=function(){function r(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=O.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}return r.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},r.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},r.prototype.onChange=function(e){for(var t="r"==e.action[0],a=this.selectedTabstop||{},i=a.parents||{},s=this.tabstops.slice(),c=0;c<s.length;c++){var n=s[c];if(n.rangeList.$bias=n==a||i[n.index]?0:1,"remove"==e.action&&n!==a){var o=n.parents&&n.parents[a.index],h=n.rangeList.pointIndex(e.start,o);h=h<0?-h-1:h+1;for(var b=n.rangeList.pointIndex(e.end,o),u=n.rangeList.ranges.slice(h,b=b<0?-b-1:b-1),y=0;y<u.length;y++)this.removeRange(u[y])}n.rangeList.$onChange(e)}var _=this.session;!this.$inChange&&t&&1==_.getLength()&&!_.getValue()&&this.detach()},r.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.session,a=t.getTextRange(e.firstNonLinked),i=0;i<e.length;i++){var s=e[i];if(s.linked){var n=v.snippetManager.tmStrFormat(a,s.original,this.editor);t.replace(s,n)}}this.$inChange=!1}},r.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},r.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,a=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var s=this.ranges[i].contains(e.row,e.column),c=a||this.ranges[i].contains(t.row,t.column);if(s&&c)return}this.detach()}},r.prototype.onChangeSession=function(){this.detach()},r.prototype.tabNext=function(e){var t=this.tabstops.length,a=this.index+(e||1);(a=Math.min(Math.max(a,1),t))==t&&(a=0),this.selectTabstop(a),this.updateTabstopMarkers(),0===a&&this.detach()},r.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var a=t.firstNonLinked||t;if(t.choices&&(a.cursor=a.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(a);else{var i=this.editor.multiSelect;i.toSingleRange(a);for(var s=0;s<t.length;s++)t.hasLinkedRanges&&t[s].linked||i.addRange(t[s].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},r.prototype.addTabstops=function(e,t,a){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var s=$.fromPoints(a,a);g(s.start,t),g(s.end,t),e[0]=[s],e[0].index=0}var n=[this.index+1,0],p=this.ranges,o=this.snippetId=(this.snippetId||0)+1;e.forEach(function(h,b){var u=this.$openTabstops[b]||h;u.snippetId=o;for(var y=0;y<h.length;y++){var _=h[y],C=$.fromPoints(_.start,_.end||_.start);d(C.start,t),d(C.end,t),C.original=_,C.tabstop=u,p.push(C),u!=h?u.unshift(C):u[y]=C,_.fmtString||u.firstNonLinked&&i?(C.linked=!0,u.hasLinkedRanges=!0):u.firstNonLinked||(u.firstNonLinked=C)}u.firstNonLinked||(u.hasLinkedRanges=!1),u===h&&(n.push(u),this.$openTabstops[b]=u),this.addTabstopMarkers(u),u.rangeList=u.rangeList||new T,u.rangeList.$bias=0,u.rangeList.addList(u)},this),n.length>2&&(this.tabstops.length&&n.push(n.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,n))},r.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(a){a.markerId||(a.markerId=t.addMarker(a,"ace_snippet-marker","text"))})},r.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(a){t.removeMarker(a.markerId),a.markerId=null})},r.prototype.updateTabstopMarkers=function(){if(this.selectedTabstop){var e=this.selectedTabstop.snippetId;0===this.selectedTabstop.index&&e--,this.tabstops.forEach(function(t){t.snippetId===e?this.addTabstopMarkers(t):this.removeTabstopMarkers(t)},this)}},r.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},r}();f.prototype.keyboardHandler=new L,f.prototype.keyboardHandler.bindKeys({Tab:function(r){v.snippetManager&&v.snippetManager.expandWithTab(r)||(r.tabstopManager.tabNext(1),r.renderer.scrollCursorIntoView())},"Shift-Tab":function(r){r.tabstopManager.tabNext(-1),r.renderer.scrollCursorIntoView()},Esc:function(r){r.tabstopManager.detach()}});var d=function(r,e){0==r.row&&(r.column+=e.column),r.row+=e.row},g=function(r,e){r.row==e.row&&(r.column-=e.column),r.row-=e.row};V.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),v.snippetManager=new I;var M=S("./editor").Editor;(function(){this.insertSnippet=function(r,e){return v.snippetManager.insertSnippet(this,r,e)},this.expandSnippet=function(r){return v.snippetManager.expandWithTab(this,r)}}).call(M.prototype)}),ace.define("ace/ext/emmet",["require","exports","module","ace/keyboard/hash_handler","ace/editor","ace/snippets","ace/range","ace/config","resources","resources","tabStops","resources","utils","actions"],function(S,v,K){"use strict";var T,L,V=S("../keyboard/hash_handler").HashHandler,z=S("../editor").Editor,B=S("../snippets").snippetManager,O=S("../range").Range,$=S("../config"),P=function(){function l(){}return l.prototype.setupContext=function(f){this.ace=f,this.indentation=f.session.getTabString(),T||(T=window.emmet),(T.resources||T.require("resources")).setVariable("indentation",this.indentation),this.$syntax=null,this.$syntax=this.getSyntax()},l.prototype.getSelectionRange=function(){var f=this.ace.getSelectionRange(),d=this.ace.session.doc;return{start:d.positionToIndex(f.start),end:d.positionToIndex(f.end)}},l.prototype.createSelection=function(f,d){var g=this.ace.session.doc;this.ace.selection.setRange({start:g.indexToPosition(f),end:g.indexToPosition(d)})},l.prototype.getCurrentLineRange=function(){var f=this.ace,d=f.getCursorPosition().row,g=f.session.getLine(d).length,M=f.session.doc.positionToIndex({row:d,column:0});return{start:M,end:M+g}},l.prototype.getCaretPos=function(){var f=this.ace.getCursorPosition();return this.ace.session.doc.positionToIndex(f)},l.prototype.setCaretPos=function(f){var d=this.ace.session.doc.indexToPosition(f);this.ace.selection.moveToPosition(d)},l.prototype.getCurrentLine=function(){var f=this.ace.getCursorPosition().row;return this.ace.session.getLine(f)},l.prototype.replaceContent=function(f,d,g,M){null==g&&(g=d??this.getContent().length),null==d&&(d=0);var r=this.ace,e=r.session.doc,t=O.fromPoints(e.indexToPosition(d),e.indexToPosition(g));r.session.remove(t),t.end=t.start,f=this.$updateTabstops(f),B.insertSnippet(r,f)},l.prototype.getContent=function(){return this.ace.getValue()},l.prototype.getSyntax=function(){if(this.$syntax)return this.$syntax;var f=this.ace.session.$modeId.split("/").pop();if("html"==f||"php"==f){var d=this.ace.getCursorPosition(),g=this.ace.session.getState(d.row);"string"!=typeof g&&(g=g[0]),g&&((g=g.split("-")).length>1?f=g[0]:"php"==f&&(f="html"))}return f},l.prototype.getProfileName=function(){var f=T.resources||T.require("resources");switch(this.getSyntax()){case"css":return"css";case"xml":case"xsl":return"xml";case"html":var d=f.getVariable("profile");return d||(d=-1!=this.ace.session.getLines(0,2).join("").search(/<!DOCTYPE[^>]+XHTML/i)?"xhtml":"html"),d;default:var g=this.ace.session.$mode;return g.emmetConfig&&g.emmetConfig.profile||"xhtml"}},l.prototype.prompt=function(f){return prompt(f)},l.prototype.getSelection=function(){return this.ace.session.getTextRange()},l.prototype.getFilePath=function(){return""},l.prototype.$updateTabstops=function(f){var g=0,M=null,r=T.tabStops||T.require("tabStops"),t=(T.resources||T.require("resources")).getVocabulary("user"),a={tabstop:function(s){var c=parseInt(s.group,10),n=0===c;n?c=++g:c+=1e3;var p=s.placeholder;p&&(p=r.processText(p,a));var o="${"+c+(p?":"+p:"")+"}";return n&&(M=[s.start,o]),o},escape:function(s){return"$"==s?"\\$":"\\"==s?"\\\\":s}};return f=r.processText(f,a),t.variables.insert_final_tabstop&&!/\$\{0\}$/.test(f)?f+="${0}":M&&(f=(T.utils?T.utils.common:T.require("utils")).replaceSubstring(f,"${0}",M[0],M[1])),f},l}(),A={expand_abbreviation:{mac:"ctrl+alt+e",win:"alt+e"},match_pair_outward:{mac:"ctrl+d",win:"ctrl+,"},match_pair_inward:{mac:"ctrl+j",win:"ctrl+shift+0"},matching_pair:{mac:"ctrl+alt+j",win:"alt+j"},next_edit_point:"alt+right",prev_edit_point:"alt+left",toggle_comment:{mac:"command+/",win:"ctrl+/"},split_join_tag:{mac:"shift+command+'",win:"shift+ctrl+`"},remove_tag:{mac:"command+'",win:"shift+ctrl+;"},evaluate_math_expression:{mac:"shift+command+y",win:"shift+ctrl+y"},increment_number_by_1:"ctrl+up",decrement_number_by_1:"ctrl+down",increment_number_by_01:"alt+up",decrement_number_by_01:"alt+down",increment_number_by_10:{mac:"alt+command+up",win:"shift+alt+up"},decrement_number_by_10:{mac:"alt+command+down",win:"shift+alt+down"},select_next_item:{mac:"shift+command+.",win:"shift+ctrl+."},select_previous_item:{mac:"shift+command+,",win:"shift+ctrl+,"},reflect_css_value:{mac:"shift+command+r",win:"shift+ctrl+r"},encode_decode_data_url:{mac:"shift+ctrl+d",win:"ctrl+'"},expand_abbreviation_with_tab:"Tab",wrap_with_abbreviation:{mac:"shift+ctrl+a",win:"shift+ctrl+a"}},R=new P;for(var E in v.commands=new V,v.runEmmetCommand=function l(f){if("expand_abbreviation_with_tab"==this.action){if(!f.selection.isEmpty())return!1;var d=f.selection.lead,g=f.session.getTokenAt(d.row,d.column);if(g&&/\btag\b/.test(g.type))return!1}try{R.setupContext(f);var M=T.actions||T.require("actions");if("wrap_with_abbreviation"==this.action)return setTimeout(function(){M.run("wrap_with_abbreviation",R)},0);var r=M.run(this.action,R)}catch(t){if(!T){var e=v.load(l.bind(this,f));return"expand_abbreviation_with_tab"!=this.action&&e}f._signal("changeStatus","string"==typeof t?t:t.message),$.warn(t),r=!1}return r},A)v.commands.addCommand({name:"emmet:"+E,action:E,bindKey:A[E],exec:v.runEmmetCommand,multiSelectAction:"forEach"});v.updateCommands=function(l,f){f?l.keyBinding.addKeyboardHandler(v.commands):l.keyBinding.removeKeyboardHandler(v.commands)},v.isSupportedMode=function(l){return!!l&&(!!l.emmetConfig||/css|less|scss|sass|stylus|html|php|twig|ejs|handlebars/.test(l.$id||l))},v.isAvailable=function(l,f){if(/(evaluate_math_expression|expand_abbreviation)$/.test(f))return!0;var d=l.session.$mode,g=v.isSupportedMode(d);if(g&&d.$modes)try{R.setupContext(l),/js|php/.test(R.getSyntax())&&(g=!1)}catch{}return g};var I=function(l,f){var d=f;if(d){var g=v.isSupportedMode(d.session.$mode);!1===l.enableEmmet&&(g=!1),g&&v.load(),v.updateCommands(d,g)}};v.load=function(l){return"string"!=typeof L?($.warn("script for emmet-core is not loaded"),!1):($.loadModule(L,function(){L=null,l&&l()}),!0)},v.AceEmmetEditor=P,$.defineOptions(z.prototype,"editor",{enableEmmet:{set:function(l){this[l?"on":"removeListener"]("changeMode",I),I({enableEmmet:!!l},this)},value:!0}}),v.setCore=function(l){"string"==typeof l?L=l:T=l}}),ace.require(["ace/ext/emmet"],function(S){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=S)});