ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(l,c,b){"use strict";var k=l("../lib/oop"),p=l("./text_highlight_rules").TextHighlightRules,m=c.reservedKeywords="!|{|}|case|do|done|elif|else|esac|fi|for|if|in|then|until|while|&|;|export|local|read|typeset|unset|elif|select|set|function|declare|readonly",f=c.languageConstructs="[|]|alias|bg|bind|break|builtin|cd|command|compgen|complete|continue|dirs|disown|echo|enable|eval|exec|exit|fc|fg|getopts|hash|help|history|jobs|kill|let|logout|popd|printf|pushd|pwd|return|set|shift|shopt|source|suspend|test|times|trap|type|ulimit|umask|unalias|wait",t=function(){var n=this.createKeywordMapper({keyword:m,"support.function.builtin":f,"invalid.deprecated":"debugger"},"identifier"),r="(?:\\d+)",a="(?:(?:"+r+"?(?:\\.\\d+))|(?:"+r+"\\.))",h="[a-zA-Z_][a-zA-Z0-9_]*";this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(u,v,d){var M="-"==u[2]?"indentedHeredoc":"heredoc",x=u.split(this.splitRegex);return d.push(M,x[4]),[{type:"constant",value:x[1]},{type:"text",value:x[2]},{type:"string",value:x[3]},{type:"support.class",value:x[4]},{type:"string",value:x[5]}]},rules:{heredoc:[{onMatch:function(u,v,d){return u===d[1]?(d.shift(),d.shift(),this.next=d[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^\t+"},{onMatch:function(u,v,d){return u===d[1]?(d.shift(),d.shift(),this.next=d[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(u,v){return"heredoc"===v[0]||"indentedHeredoc"===v[0]?v[0]:u}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:"(?:\\$(?:SHLVL|\\$|\\!|\\?))"},{token:"variable",regex:"(?:"+h+"(?==))"},{include:"variables"},{token:"support.function",regex:"(?:"+h+"\\s*\\(\\))"},{token:"support.function",regex:"(?:&"+r+")"},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:"(?:(?:(?:"+a+"|"+r+"))|"+a+")"},{token:"constant.numeric",regex:"(?:(?:[1-9]\\d*)|(?:0))\\b"},{token:n,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]},this.normalizeRules()};k.inherits(t,p),c.ShHighlightRules=t}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(l,c,b){"use strict";var k=l("../../lib/oop"),p=l("../../range").Range,m=l("./fold_mode").FoldMode,f=c.FoldMode=function(t){t&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+t.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+t.end)))};k.inherits(f,m),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(t,n,i){var s=t.getLine(i);if(this.singleLineBlockCommentRe.test(s)&&!this.startRegionRe.test(s)&&!this.tripleStarBlockCommentRe.test(s))return"";var r=this._getFoldWidgetBase(t,n,i);return!r&&this.startRegionRe.test(s)?"start":r},this.getFoldWidgetRange=function(t,n,i,s){var e,r=t.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(t,r,i);if(e=r.match(this.foldingStartMarker)){var a=e.index;if(e[1])return this.openingBracketBlock(t,e[1],i,a);var o=t.getCommentFoldRange(i,a+e[0].length,1);return o&&!o.isMultiLine()&&(s?o=this.getSectionRange(t,i):"all"!=n&&(o=null)),o}return"markbegin"!==n&&(e=r.match(this.foldingStopMarker))?(a=e.index+e[0].length,e[1]?this.closingBracketBlock(t,e[1],i,a):t.getCommentFoldRange(i,a,-1)):void 0},this.getSectionRange=function(t,n){for(var i=t.getLine(n),s=i.search(/\S/),r=n,a=i.length,o=n+=1,e=t.getLength();++n<e;){var g=(i=t.getLine(n)).search(/\S/);if(-1!==g){if(s>g)break;var h=this.getFoldWidgetRange(t,"all",n);if(h){if(h.start.row<=r)break;if(h.isMultiLine())n=h.end.row;else if(s==g)break}o=n}}return new p(r,a,o,t.getLine(o).length)},this.getCommentRegionBlock=function(t,n,i){for(var s=n.search(/\s*$/),r=t.getLength(),a=i,o=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,e=1;++i<r;){n=t.getLine(i);var g=o.exec(n);if(g&&(g[1]?e--:e++,!e))break}if(i>a)return new p(a,s,i,n.length)}}.call(f.prototype)}),ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle"],function(l,c,b){"use strict";var k=l("../lib/oop"),p=l("./text").Mode,m=l("./sh_highlight_rules").ShHighlightRules,f=l("../range").Range,t=l("./folding/cstyle").FoldMode,n=function(){this.HighlightRules=m,this.foldingRules=new t,this.$behaviour=this.$defaultBehaviour};k.inherits(n,p),function(){this.lineCommentStart="#",this.getNextLineIndent=function(s,r,a){var o=this.$getIndent(r),g=this.getTokenizer().getLineTokens(r,s).tokens;return g.length&&"comment"==g[g.length-1].type||"start"==s&&r.match(/^.*[\{\(\[:]\s*$/)&&(o+=a),o};var i={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(s,r,a){if("\r\n"!==a&&"\r"!==a&&"\n"!==a)return!1;var o=this.getTokenizer().getLineTokens(r.trim(),s).tokens;if(!o)return!1;do{var e=o.pop()}while(e&&("comment"==e.type||"text"==e.type&&e.value.match(/^\s+$/)));return!!e&&"keyword"==e.type&&i[e.value]},this.autoOutdent=function(s,r,a){var o=this.$getIndent(r.getLine(a+=1)),e=r.getTabString();o.slice(-e.length)==e&&r.remove(new f(a,o.length-e.length,a,o.length))},this.$id="ace/mode/sh",this.snippetFileId="ace/snippets/sh"}.call(n.prototype),c.Mode=n}),ace.require(["ace/mode/sh"],function(l){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=l)});