/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan;

import fr.jcgay.maven.plugin.buildplan.SynchronizedFileReporter;
import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractLifecycleMojo
extends AbstractMojo {
    @Component(role=DefaultLifecycles.class)
    DefaultLifecycles defaultLifecycles;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Parameter(property="buildplan.tasks", defaultValue="deploy")
    private String[] tasks;
    @Parameter(property="buildplan.outputFile")
    private File outputFile;
    @Parameter(property="buildplan.appendOutput", defaultValue="false")
    private boolean appendOutput;
    @Parameter(property="buildplan.skip", defaultValue="false")
    private boolean skip = false;

    protected MavenExecutionPlan calculateExecutionPlan() throws MojoFailureException {
        try {
            return this.lifecycleExecutor.calculateExecutionPlan(this.session, this.tasks);
        }
        catch (Exception e) {
            throw new MojoFailureException(String.format("Cannot calculate Maven execution plan, caused by: %s", e.getMessage()), (Throwable)e);
        }
    }

    protected void handleOutput(String output) {
        String outputWithTitle = "Build Plan for " + this.project.getName() + ": " + output;
        if (this.outputFile == null) {
            this.getLog().info((CharSequence)outputWithTitle);
        } else {
            try {
                SynchronizedFileReporter.write(outputWithTitle, this.outputFile, this.appendOutput);
                this.getLog().info((CharSequence)("Wrote build plan output to: " + this.outputFile));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to write to output file: " + this.outputFile), (Throwable)e);
            }
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping build plan execution.");
            return;
        }
        this.executeInternal();
    }

    protected abstract void executeInternal() throws MojoFailureException;
}

