/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import fr.jcgay.maven.plugin.buildplan.NoMojoExecution;
import java.util.Collections;
import java.util.List;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class Groups {

    public static class Options {
        private final DefaultLifecycles defaultLifecycles;
        private String phase;
        private boolean showingAllPhases;
        private boolean showingLifecycles;

        public Options(DefaultLifecycles defaultLifecycles) {
            this.defaultLifecycles = defaultLifecycles;
        }

        public Options forPhase(String phase) {
            this.phase = phase;
            return this;
        }

        public Options showingAllPhases() {
            this.showingAllPhases = true;
            return this;
        }

        public Options showingLifecycles() {
            this.showingLifecycles = true;
            return this;
        }
    }

    public static class ByPhase {
        public static Multimap<String, MojoExecution> of(List<MojoExecution> plan) {
            return ByPhase.of(plan, new Options(ByPhase.defaultLifecycles()));
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, String phaseFilter) {
            return ByPhase.of(executions, new Options(ByPhase.defaultLifecycles()).forPhase(phaseFilter));
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, Options options) {
            LinkedListMultimap result = LinkedListMultimap.create();
            boolean notFiltering = Strings.isNullOrEmpty((String)options.phase);
            for (MojoExecution execution : executions) {
                Lifecycle lifecycle;
                String phase = (String)Objects.firstNonNull((Object)execution.getLifecyclePhase(), (Object)"<no phase>");
                if (options.showingAllPhases && (lifecycle = options.defaultLifecycles.get(phase)) != null) {
                    lifecycle.getPhases().forEach(arg_0 -> ByPhase.lambda$of$0((Multimap)result, arg_0));
                }
                if (!notFiltering && !phase.equalsIgnoreCase(options.phase)) continue;
                result.put((Object)phase, (Object)execution);
            }
            return result;
        }

        private static DefaultLifecycles defaultLifecycles() {
            return new DefaultLifecycles(Collections.emptyMap(), (Logger)new ConsoleLogger());
        }

        private static /* synthetic */ void lambda$of$0(Multimap result, String defaultPhase) {
            result.put((Object)defaultPhase, (Object)NoMojoExecution.INSTANCE);
        }
    }

    public static class ByPlugin {
        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions) {
            return ByPlugin.of(executions, null);
        }

        public static Multimap<String, MojoExecution> of(List<MojoExecution> executions, String artifactIdFilter) {
            LinkedListMultimap result = LinkedListMultimap.create();
            boolean notFiltering = Strings.isNullOrEmpty((String)artifactIdFilter);
            for (MojoExecution execution : executions) {
                if (!notFiltering && !execution.getArtifactId().equalsIgnoreCase(artifactIdFilter)) continue;
                result.put((Object)execution.getArtifactId(), (Object)execution);
            }
            return result;
        }
    }
}

