/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan;

import com.google.common.base.Strings;
import fr.jcgay.maven.plugin.buildplan.AbstractLifecycleMojo;
import fr.jcgay.maven.plugin.buildplan.display.ListTableDescriptor;
import fr.jcgay.maven.plugin.buildplan.display.MojoExecutionDisplay;
import fr.jcgay.maven.plugin.buildplan.display.Output;
import fr.jcgay.maven.plugin.buildplan.display.TableColumn;
import fr.jcgay.maven.plugin.buildplan.display.TableDescriptor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list", threadSafe=true, requiresProject=true)
public class ListMojo
extends AbstractLifecycleMojo {
    @Parameter(property="buildplan.showLifecycles", defaultValue="false")
    private boolean showLifecycles;

    @Override
    public void executeInternal() throws MojoFailureException {
        MavenExecutionPlan plan = this.calculateExecutionPlan();
        ListTableDescriptor descriptor = ListTableDescriptor.of(plan.getMojoExecutions(), this.defaultLifecycles);
        if (!this.showLifecycles) {
            descriptor.hideLifecycle();
        }
        String row = descriptor.rowFormat();
        StringBuilder output = new StringBuilder().append(Output.lineSeparator()).append(this.titleSeparator(descriptor)).append(Output.lineSeparator()).append(this.tableHead(row)).append(Output.lineSeparator()).append(this.titleSeparator(descriptor));
        for (MojoExecution execution : plan.getMojoExecutions()) {
            output.append(Output.lineSeparator()).append(this.tableRow(row, execution));
        }
        this.handleOutput(output.toString());
    }

    private String tableRow(String row, MojoExecution execution) {
        MojoExecutionDisplay display = new MojoExecutionDisplay(execution);
        if (this.showLifecycles) {
            return String.format(row, display.getArtifactId(), display.getPhase(), display.getLifecycle(this.defaultLifecycles), display.getExecutionId(), display.getGoal());
        }
        return String.format(row, display.getArtifactId(), display.getPhase(), display.getExecutionId(), display.getGoal());
    }

    private String tableHead(String row) {
        if (this.showLifecycles) {
            return String.format(row, TableColumn.ARTIFACT_ID.title(), TableColumn.PHASE.title(), TableColumn.LIFECYCLE.title(), TableColumn.EXECUTION_ID.title(), TableColumn.GOAL.title());
        }
        return String.format(row, TableColumn.ARTIFACT_ID.title(), TableColumn.PHASE.title(), TableColumn.EXECUTION_ID.title(), TableColumn.GOAL.title());
    }

    private String titleSeparator(TableDescriptor descriptor) {
        return Strings.repeat((String)"-", (int)descriptor.width());
    }
}

