/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import fr.jcgay.maven.plugin.buildplan.AbstractLifecycleMojo;
import fr.jcgay.maven.plugin.buildplan.Groups;
import fr.jcgay.maven.plugin.buildplan.display.ListPluginTableDescriptor;
import fr.jcgay.maven.plugin.buildplan.display.MojoExecutionDisplay;
import fr.jcgay.maven.plugin.buildplan.display.Output;
import fr.jcgay.maven.plugin.buildplan.display.TableDescriptor;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-plugin", threadSafe=true, requiresProject=true)
public class ListPluginMojo
extends AbstractLifecycleMojo {
    @Parameter(property="buildplan.plugin")
    private String plugin;

    @Override
    public void executeInternal() throws MojoFailureException {
        Multimap<String, MojoExecution> plan = Groups.ByPlugin.of(this.calculateExecutionPlan().getMojoExecutions(), this.plugin);
        if (plan.isEmpty()) {
            this.getLog().warn((CharSequence)("No plugin found with artifactId: " + this.plugin));
        } else {
            StringBuilder output = new StringBuilder();
            ListPluginTableDescriptor descriptor = ListPluginTableDescriptor.of(plan.values(), this.defaultLifecycles);
            for (Map.Entry executions : plan.asMap().entrySet()) {
                output.append(Output.lineSeparator()).append(this.pluginTitleLine(descriptor, (String)executions.getKey()));
                for (MojoExecution execution : (Collection)executions.getValue()) {
                    output.append(Output.lineSeparator()).append(this.line(descriptor.rowFormat(), execution));
                }
            }
            this.handleOutput(output.toString());
        }
    }

    private String line(String rowFormat, MojoExecution execution) {
        MojoExecutionDisplay display = new MojoExecutionDisplay(execution);
        return String.format(rowFormat, display.getPhase(), display.getExecutionId(), display.getGoal());
    }

    private String pluginTitleLine(TableDescriptor descriptor, String key) {
        return key + " " + Strings.repeat((String)"-", (int)(descriptor.width() - key.length()));
    }
}

