/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan.display;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import fr.jcgay.maven.plugin.buildplan.display.TableColumn;
import fr.jcgay.maven.plugin.buildplan.display.TableDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;

public abstract class AbstractTableDescriptor
implements TableDescriptor {
    protected static Map<TableColumn, Integer> findMaxSize(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles, TableColumn ... columns) {
        HashMap<TableColumn, Integer> result = new HashMap<TableColumn, Integer>();
        ArrayListMultimap count = ArrayListMultimap.create();
        for (MojoExecution execution : executions) {
            block8: for (TableColumn column : columns) {
                switch (column) {
                    case ARTIFACT_ID: {
                        count.put((Object)column, (Object)AbstractTableDescriptor.safeLength(execution.getArtifactId()));
                        continue block8;
                    }
                    case EXECUTION_ID: {
                        count.put((Object)column, (Object)AbstractTableDescriptor.safeLength(execution.getExecutionId()));
                        continue block8;
                    }
                    case GOAL: {
                        count.put((Object)column, (Object)AbstractTableDescriptor.safeLength(execution.getGoal()));
                        continue block8;
                    }
                    case PHASE: {
                        count.put((Object)column, (Object)AbstractTableDescriptor.safeLength(AbstractTableDescriptor.phase(execution)));
                        continue block8;
                    }
                    case LIFECYCLE: {
                        Lifecycle lifecycle = defaultLifecycles.get(AbstractTableDescriptor.phase(execution));
                        count.put((Object)column, (Object)(lifecycle == null ? 0 : AbstractTableDescriptor.safeLength(lifecycle.getId())));
                    }
                }
            }
        }
        for (TableColumn column : TableColumn.values()) {
            count.put((Object)column, (Object)column.title().length());
        }
        for (TableColumn key : count.keySet()) {
            result.put(key, (Integer)Collections.max(count.get((Object)key)));
        }
        return result;
    }

    public static String phase(MojoExecution execution) {
        MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
        if (mojoDescriptor != null && mojoDescriptor.getPhase() != null) {
            return mojoDescriptor.getPhase();
        }
        return execution.getLifecyclePhase();
    }

    private static int safeLength(String string) {
        return Strings.nullToEmpty((String)string).length();
    }
}

