/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan.display;

import fr.jcgay.maven.plugin.buildplan.display.AbstractTableDescriptor;
import fr.jcgay.maven.plugin.buildplan.display.TableColumn;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.plugin.MojoExecution;

public class ListPhaseTableDescriptor
extends AbstractTableDescriptor {
    private static final int SEPARATOR_SIZE = "    + ".length() + 2 * " | ".length();
    private int pluginSize;
    private int executionIdSize;
    private int goalSize;

    public static ListPhaseTableDescriptor of(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles) {
        Map<TableColumn, Integer> maxSize = ListPhaseTableDescriptor.findMaxSize(executions, defaultLifecycles, TableColumn.ARTIFACT_ID, TableColumn.EXECUTION_ID, TableColumn.GOAL);
        return new ListPhaseTableDescriptor().setPluginSize(maxSize.get((Object)TableColumn.ARTIFACT_ID)).setGoalSize(maxSize.get((Object)TableColumn.GOAL)).setExecutionIdSize(maxSize.get((Object)TableColumn.EXECUTION_ID));
    }

    @Override
    public String rowFormat() {
        return "    + " + "%-" + this.getPluginSize() + FORMAT_STRING + " | " + "%-" + this.getExecutionIdSize() + FORMAT_STRING + " | " + "%-" + this.getGoalSize() + FORMAT_STRING;
    }

    @Override
    public int width() {
        return this.getExecutionIdSize() + this.getGoalSize() + this.getPluginSize() + SEPARATOR_SIZE;
    }

    public int getPluginSize() {
        return this.pluginSize;
    }

    public int getExecutionIdSize() {
        return this.executionIdSize;
    }

    public int getGoalSize() {
        return this.goalSize;
    }

    public ListPhaseTableDescriptor setPluginSize(int pluginSize) {
        this.pluginSize = pluginSize;
        return this;
    }

    public ListPhaseTableDescriptor setExecutionIdSize(int executionIdSize) {
        this.executionIdSize = executionIdSize;
        return this;
    }

    public ListPhaseTableDescriptor setGoalSize(int goalSize) {
        this.goalSize = goalSize;
        return this;
    }
}

