/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.plugin.buildplan.display;

import com.google.common.base.Objects;
import fr.jcgay.maven.plugin.buildplan.display.AbstractTableDescriptor;
import fr.jcgay.maven.plugin.buildplan.display.TableColumn;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.plugin.MojoExecution;

public class ListTableDescriptor
extends AbstractTableDescriptor {
    static final int SEPARATOR_SIZE = 4 * " | ".length();
    private int pluginSize;
    private int phaseSize;
    private int lifecycleSize;
    private int executionIdSize;
    private int goalSize;

    public static ListTableDescriptor of(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles) {
        Map<TableColumn, Integer> maxSize = ListTableDescriptor.findMaxSize(executions, defaultLifecycles, TableColumn.values());
        return new ListTableDescriptor().setPluginSize(maxSize.get((Object)TableColumn.ARTIFACT_ID)).setPhaseSize(maxSize.get((Object)TableColumn.PHASE)).setLifecycleSize(maxSize.get((Object)TableColumn.LIFECYCLE)).setGoalSize(maxSize.get((Object)TableColumn.GOAL)).setExecutionIdSize(maxSize.get((Object)TableColumn.EXECUTION_ID));
    }

    @Override
    public String rowFormat() {
        StringBuilder builder = new StringBuilder();
        builder.append("%-").append(this.getPluginSize()).append(FORMAT_STRING).append(" | ").append("%-").append(this.getPhaseSize()).append(FORMAT_STRING).append(" | ");
        if (this.lifecycleSize > 0) {
            builder.append("%-").append(this.getLifecycleSize()).append(FORMAT_STRING).append(" | ");
        }
        builder.append("%-").append(this.getExecutionIdSize()).append(FORMAT_STRING).append(" | ").append("%-").append(this.getGoalSize()).append(FORMAT_STRING);
        return builder.toString();
    }

    @Override
    public int width() {
        return this.getPluginSize() + this.getPhaseSize() + this.getLifecycleSize() + this.getExecutionIdSize() + this.getGoalSize() + SEPARATOR_SIZE;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Plugin column size", (Object)this.getPluginSize()).add("Phase column size", (Object)this.getPhaseSize()).add("Lifecycle column size", (Object)this.getLifecycleSize()).add("Execution ID column size", (Object)this.getExecutionIdSize()).add("Goal column size", (Object)this.getGoalSize()).add("width", (Object)this.width()).toString();
    }

    public int getPluginSize() {
        return this.pluginSize;
    }

    public ListTableDescriptor setPluginSize(int pluginSize) {
        this.pluginSize = pluginSize;
        return this;
    }

    public int getPhaseSize() {
        return this.phaseSize;
    }

    public ListTableDescriptor setPhaseSize(int phaseSize) {
        this.phaseSize = phaseSize;
        return this;
    }

    public int getLifecycleSize() {
        return this.lifecycleSize;
    }

    public ListTableDescriptor setLifecycleSize(int lifecycleSize) {
        this.lifecycleSize = lifecycleSize;
        return this;
    }

    public int getExecutionIdSize() {
        return this.executionIdSize;
    }

    public ListTableDescriptor setExecutionIdSize(int executionIdSize) {
        this.executionIdSize = executionIdSize;
        return this;
    }

    public int getGoalSize() {
        return this.goalSize;
    }

    public ListTableDescriptor setGoalSize(int goalSize) {
        this.goalSize = goalSize;
        return this;
    }

    public void hideLifecycle() {
        this.lifecycleSize = -1 * " | ".length();
    }
}

