/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IFieldsMetadataClassSerializer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldsMetadataClassSerializer
implements IFieldsMetadataClassSerializer {
    private final String id;
    private final String description;
    private final List<String> excludedPackages;

    public AbstractFieldsMetadataClassSerializer(String id, String description) {
        this.id = id;
        this.description = description;
        this.excludedPackages = new ArrayList<String>();
        this.excludedPackages.add("java.");
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz) throws XDocReportException {
        this.load(fieldsMetadata, key, clazz, false);
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, boolean listType) throws XDocReportException {
        try {
            this.process(fieldsMetadata, key, clazz, listType);
        }
        catch (Exception e) {
            throw new XDocReportException((Throwable)e);
        }
    }

    private void process(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, boolean listType) throws IntrospectionException {
        String fieldName = null;
        BeanInfo infos = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] desc = infos.getPropertyDescriptors();
        for (int i = 0; i < desc.length; ++i) {
            Method method = desc[i].getReadMethod();
            if (!this.isGetterMethod(method)) continue;
            Class<?> returnTypeClass = method.getReturnType();
            if (Iterable.class.isAssignableFrom(returnTypeClass)) {
                ParameterizedType parameterizedType;
                Type[] types;
                Type collectionType = method.getGenericReturnType();
                if (collectionType == null || !(collectionType instanceof ParameterizedType) || (types = (parameterizedType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
                Class itemClazz = (Class)types[0];
                fieldName = this.getFieldName(key, desc[i].getName());
                this.process(fieldsMetadata, fieldName, itemClazz, listType);
                continue;
            }
            fieldName = this.getFieldName(key, desc[i].getName());
            if (this.isClassToExclude(returnTypeClass)) {
                fieldsMetadata.addField(fieldName, listType, null, null, null);
                continue;
            }
            this.process(fieldsMetadata, fieldName, clazz, listType);
        }
    }

    private boolean isClassToExclude(Class clazz) {
        if (clazz != null && clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            for (String excludePackageName : this.excludedPackages) {
                if (!packageName.startsWith(excludePackageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGetterMethod(Method method) {
        if (method == null) {
            return false;
        }
        String name = method.getName();
        return !name.equals("getClass") && (name.startsWith("get") || name.startsWith("is"));
    }

    protected abstract String getFieldName(String var1, String var2);
}

