/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;

public class FieldMetadata {
    private final FieldsMetadata fieldsMetadata;
    private final String fieldName;
    private String imageName;
    private boolean listType;
    private boolean imageType;
    private String syntaxKind;
    private String description;
    private boolean syntaxWithDirective;

    public FieldMetadata(FieldsMetadata fieldsMetadata, String fieldName, boolean listType, String imageName, String syntaxKind, boolean syntaxWithDirective) {
        this.fieldsMetadata = fieldsMetadata;
        this.fieldName = fieldName;
        this.setListType(listType);
        this.setImageName(imageName);
        this.setSyntaxKind(syntaxKind);
        this.setSyntaxWithDirective(syntaxWithDirective);
        fieldsMetadata.fields.add(this);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean isListType() {
        return this.listType;
    }

    public void setListType(boolean listType) {
        this.listType = listType;
        if (listType) {
            this.fieldsMetadata.fieldsAsList.put(this.getFieldName(), this);
        } else {
            this.fieldsMetadata.fieldsAsList.remove(this.getFieldName());
        }
    }

    public boolean isImageType() {
        return this.imageType;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
        this.imageType = StringUtils.isNotEmpty((String)imageName);
        if (this.imageType) {
            this.fieldsMetadata.fieldsAsImage.put(this.getImageName(), this);
        } else {
            this.fieldsMetadata.fieldsAsImage.remove(this.getImageName());
        }
    }

    public String getSyntaxKind() {
        return this.syntaxKind;
    }

    public boolean isSyntaxWithDirective() {
        return this.syntaxWithDirective;
    }

    public void setSyntaxKind(String syntaxKind) {
        this.syntaxKind = syntaxKind;
        if (StringUtils.isNotEmpty((String)syntaxKind)) {
            this.fieldsMetadata.fieldsAsTextStyling.put(this.getFieldName(), this);
        } else {
            this.fieldsMetadata.fieldsAsTextStyling.remove(this.getFieldName());
        }
    }

    public void setSyntaxWithDirective(boolean syntaxWithDirective) {
        this.syntaxWithDirective = syntaxWithDirective;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

