/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.xhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.xwpf.converter.core.AbstractXWPFConverter;
import org.apache.poi.xwpf.converter.core.IXWPFConverter;
import org.apache.poi.xwpf.converter.core.XWPFConverterException;
import org.apache.poi.xwpf.converter.xhtml.SimpleContentHandler;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.converter.xhtml.internal.XHTMLMapper;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.xml.sax.ContentHandler;

public class XHTMLConverter
extends AbstractXWPFConverter<XHTMLOptions> {
    private static final IXWPFConverter<XHTMLOptions> INSTANCE = new XHTMLConverter();

    public static IXWPFConverter<XHTMLOptions> getInstance() {
        return INSTANCE;
    }

    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, XHTMLOptions options) throws XWPFConverterException, IOException {
        options = options != null ? options : XHTMLOptions.getDefault();
        SimpleContentHandler contentHandler = out != null ? new SimpleContentHandler(out, options.getIndent()) : new SimpleContentHandler(writer, options.getIndent());
        this.convert(document, contentHandler, options);
    }

    public void convert(XWPFDocument document, ContentHandler contentHandler, XHTMLOptions options) throws XWPFConverterException, IOException {
        try {
            options = options != null ? options : XHTMLOptions.getDefault();
            XHTMLMapper mapper = new XHTMLMapper(document, contentHandler, options);
            mapper.start();
        }
        catch (Exception e) {
            throw new XWPFConverterException((Throwable)e);
        }
    }
}

