/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import il.co.topq.difido.model.execution.MachineNode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Execution {
    private List<MachineNode> machines;

    public List<MachineNode> getMachines() {
        return this.machines;
    }

    public void setMachines(List<MachineNode> machines) {
        this.machines = machines;
    }

    public synchronized void addMachine(MachineNode machine) {
        if (this.machines == null) {
            this.machines = new CopyOnWriteArrayList<MachineNode>();
        }
        this.machines.add(machine);
    }

    @JsonIgnore
    public MachineNode getMachineByName(String machineName) {
        if (null == machineName) {
            return null;
        }
        if (null == this.machines) {
            return null;
        }
        if (this.machines.isEmpty()) {
            return null;
        }
        for (MachineNode machine : this.machines) {
            if (!machine.getName().trim().equals(machineName.trim())) continue;
            return machine;
        }
        return null;
    }

    @JsonIgnore
    public MachineNode getLastMachine() {
        if (null == this.machines) {
            return null;
        }
        return this.machines.get(this.machines.size() - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Execution").append("\n");
        if (null != this.machines) {
            sb.append("Machines: ").append(Arrays.toString(this.machines.toArray())).append("\n");
        }
        return sb.toString();
    }
}

