/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import il.co.topq.difido.model.execution.Node;
import il.co.topq.difido.model.execution.NodeWithChildren;
import il.co.topq.difido.model.execution.ScenarioNode;
import il.co.topq.difido.model.execution.TestNode;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"plannedTests"})
public class MachineNode
extends NodeWithChildren<ScenarioNode> {
    @JsonProperty(value="plannedTests")
    private int plannedTests;
    @JsonIgnore
    private List<ScenarioNode> allScenarios;

    public MachineNode() {
    }

    public MachineNode(String name) {
        super(name);
    }

    @Override
    @JsonIgnore
    public void addChild(ScenarioNode scenario) {
        super.addChild(scenario);
        this.addSubScenario(scenario);
    }

    @JsonIgnore
    public void addSubScenario(ScenarioNode scenario) {
        if (null == this.allScenarios) {
            this.allScenarios = new ArrayList<ScenarioNode>();
        }
        this.allScenarios.add(scenario);
    }

    @JsonIgnore
    public List<ScenarioNode> getAllScenarios() {
        return this.allScenarios;
    }

    @JsonIgnore
    public TestNode findTestNodeById(String uid) {
        List allScenarios = this.getChildren(true);
        if (allScenarios == null) {
            return null;
        }
        for (Node scenario : allScenarios) {
            TestNode testNode;
            if (scenario == null || !(scenario instanceof ScenarioNode) || (testNode = ((ScenarioNode)scenario).findTestByUid(uid)) == null) continue;
            return testNode;
        }
        return null;
    }

    public int getPlannedTests() {
        return this.plannedTests;
    }

    public void setPlannedTests(int plannedTests) {
        this.plannedTests = plannedTests;
    }
}

