/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import il.co.topq.difido.model.execution.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NodeWithChildren<T extends Node>
extends Node {
    private List<T> children;

    public NodeWithChildren() {
    }

    public NodeWithChildren(String name) {
        super(name);
    }

    @JsonIgnore
    public void addChild(T node) {
        if (null == this.children) {
            this.children = new ArrayList<T>();
        }
        ((Node)node).setParent(this);
        this.children.add(node);
    }

    public List<T> getChildren() {
        return this.children;
    }

    @JsonIgnore
    public List<T> getChildren(boolean recursively) {
        if (!recursively) {
            return this.children;
        }
        ArrayList<Node> allChildren = new ArrayList<Node>();
        if (null == this.children) {
            return allChildren;
        }
        for (Node child : this.children) {
            allChildren.add(child);
            if (!(child instanceof NodeWithChildren)) continue;
            allChildren.addAll(((NodeWithChildren)child).getChildren(true));
        }
        return allChildren;
    }

    public void setChildren(List<T> children) {
        this.children = children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName()).append("\n");
        if (null != this.getChildren()) {
            sb.append("Children").append(Arrays.toString(this.getChildren().toArray())).append("\n");
        }
        return sb.toString();
    }
}

