/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import il.co.topq.difido.model.execution.MachineNode;
import il.co.topq.difido.model.execution.Node;
import il.co.topq.difido.model.execution.NodeWithChildren;
import il.co.topq.difido.model.execution.TestNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder(value={"scenarioProperties"})
public class ScenarioNode
extends NodeWithChildren<Node> {
    @JsonProperty(value="scenarioProperties")
    private Map<String, String> scenarioProperties;

    public ScenarioNode() {
    }

    public ScenarioNode(String name) {
        super(name);
    }

    @JsonIgnore
    public static ScenarioNode newInstance(ScenarioNode aScenarioNode) {
        ScenarioNode scenarioNodeCopy = new ScenarioNode(aScenarioNode.getName());
        scenarioNodeCopy.setChildren(aScenarioNode.getChildren());
        scenarioNodeCopy.setParent(aScenarioNode.getParent());
        scenarioNodeCopy.setStatus(aScenarioNode.getStatus());
        scenarioNodeCopy.setScenarioProperties(new HashMap<String, String>(aScenarioNode.getScenarioProperties()));
        return scenarioNodeCopy;
    }

    @JsonIgnore
    public void addScenarioProperty(String key, String property) {
        if (null == this.scenarioProperties) {
            this.scenarioProperties = new HashMap<String, String>();
        }
        this.scenarioProperties.put(key, property);
        if (this.getParent() instanceof ScenarioNode) {
            ((ScenarioNode)this.getParent()).addScenarioProperty(key, property);
        }
    }

    @Override
    @JsonIgnore
    public void addChild(Node node) {
        MachineNode machine;
        super.addChild(node);
        if (node instanceof ScenarioNode && (machine = this.findMachine()) != null) {
            machine.addSubScenario((ScenarioNode)node);
        }
    }

    private MachineNode findMachine() {
        NodeWithChildren node = this;
        while (!(node.getParent() instanceof MachineNode)) {
            if (null != (node = node.getParent())) continue;
            return null;
        }
        return (MachineNode)node.getParent();
    }

    public TestNode findTestByUid(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("UID can't be null or empty");
        }
        List children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (Node node : children) {
            TestNode testNode;
            if (!(node instanceof TestNode) || (testNode = (TestNode)node).getUid() == null || !testNode.getUid().equals(uid.trim())) continue;
            return testNode;
        }
        return null;
    }

    public Map<String, String> getScenarioProperties() {
        return this.scenarioProperties;
    }

    private void setScenarioProperties(Map<String, String> scenarioProperties) {
        this.scenarioProperties = scenarioProperties;
    }
}

