/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import il.co.topq.difido.model.Enums;
import il.co.topq.difido.model.execution.Node;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"index", "uid", "description", "duration", "date", "timestamp", "className", "parameters", "properties"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TestNode
extends Node {
    @JsonProperty(value="index")
    private int index;
    @JsonProperty(value="uid")
    private String uid;
    @JsonProperty(value="description")
    private String description = "";
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="date")
    private String date;
    @JsonProperty(value="timestamp")
    private String timestamp;
    @JsonProperty(value="className")
    private String className;
    @JsonProperty(value="hideInHtml")
    private boolean hideInHtml;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    public TestNode() {
        this.setStatus(Enums.Status.in_progress);
    }

    public TestNode(String name, String uid) {
        this(0, name, uid);
    }

    public TestNode(TestNode testNode) {
        super(testNode.getName());
        this.setParent(testNode.getParent());
        this.setStatus(testNode.getStatus());
        this.index = testNode.index;
        this.uid = testNode.uid;
        this.description = testNode.description;
        this.duration = testNode.duration;
        this.date = testNode.date;
        this.timestamp = testNode.timestamp;
        this.className = testNode.className;
        if (testNode.properties != null) {
            this.properties = new HashMap<String, String>(testNode.properties);
        }
        if (testNode.parameters != null) {
            this.parameters = new HashMap<String, String>(testNode.parameters);
        }
    }

    public TestNode(int index, String name, String uid) {
        super(name);
        if (index < 0) {
            throw new IllegalArgumentException("index can't be smaller then 0");
        }
        this.index = index;
        this.setStatus(Enums.Status.in_progress);
        this.uid = uid;
    }

    @JsonIgnore
    public static TestNode newInstance(TestNode aTestNode) {
        TestNode testNodeCopy = new TestNode(aTestNode.getIndex(), aTestNode.getName(), aTestNode.getUid());
        testNodeCopy.setDuration(aTestNode.getDuration());
        testNodeCopy.setParent(aTestNode.getParent());
        testNodeCopy.setStatus(aTestNode.getStatus());
        testNodeCopy.setTimestamp(aTestNode.getTimestamp());
        return testNodeCopy;
    }

    @JsonIgnore
    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    @JsonIgnore
    public void addParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, value);
    }

    @JsonIgnore
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        return other.hashCode() == this.hashCode();
    }

    @Override
    @JsonIgnore
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.index;
        if (this.uid != null) {
            result = 31 * result + this.uid.hashCode();
        }
        if (this.description != null) {
            result = 31 * result + this.description.hashCode();
        }
        result = 31 * result + new Long(this.duration).intValue();
        if (this.timestamp != null) {
            result = 31 * result + this.timestamp.hashCode();
        }
        if (this.date != null) {
            result = 31 * result + this.date.hashCode();
        }
        if (this.className != null) {
            result = 31 * result + this.className.hashCode();
        }
        if (this.parameters != null) {
            result = 31 * result + this.parameters.hashCode();
        }
        if (this.properties != null) {
            result = 31 * result + this.properties.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Index: ").append(this.index).append(",Uid: ").append(this.uid).append(",Class name: ").append(this.className).append(", Name: ").append(this.getName()).append(", StatusL ").append(this.getStatus().name());
        return sb.toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isHideInHtml() {
        return this.hideInHtml;
    }

    public void setHideInHtml(boolean hideInHtml) {
        this.hideInHtml = hideInHtml;
    }
}

