/*
 * Decompiled with CFR 0.152.
 */
package il.co.topq.difido.model.test;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import il.co.topq.difido.model.Enums;
import il.co.topq.difido.model.test.ReportElement;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"uid", "reportElements"})
public class TestDetails {
    @JsonIgnore
    private List<ReportElement> levelElementsBuffer;
    @JsonProperty(value="uid")
    private String uid;
    @JsonProperty(value="reportElements")
    private List<ReportElement> reportElements;

    public TestDetails(String uid) {
        this.uid = uid;
    }

    public TestDetails() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Uid: ").append(this.uid).append("\n");
        return sb.toString();
    }

    @JsonIgnore
    public void addReportElement(ReportElement element) {
        if (null == this.reportElements) {
            this.reportElements = new ArrayList<ReportElement>();
        }
        if (element.getStatus() == null) {
            element.setStatus(Enums.Status.success);
        }
        element.setParent(this);
        this.reportElements.add(element);
        this.updateLevelElementsBuffer(element);
        this.updateLevelElementsStatuses(element);
    }

    @JsonIgnore
    private void updateLevelElementsStatuses(ReportElement element) {
        if (null == this.levelElementsBuffer) {
            return;
        }
        if (element == null || element.getType() == null) {
            return;
        }
        if (element.getStatus() == Enums.Status.success) {
            return;
        }
        for (ReportElement startElement : this.levelElementsBuffer) {
            if (element.getStatus().ordinal() <= startElement.getStatus().ordinal()) continue;
            startElement.setStatus(element.getStatus());
        }
    }

    @JsonIgnore
    private void updateLevelElementsBuffer(ReportElement element) {
        if (element == null || element.getType() == null) {
            return;
        }
        if (element.getType() == Enums.ElementType.startLevel) {
            if (null == this.levelElementsBuffer) {
                this.levelElementsBuffer = new ArrayList<ReportElement>();
            }
            this.levelElementsBuffer.add(element);
        } else if (element.getType() == Enums.ElementType.stopLevel) {
            if (this.levelElementsBuffer == null || this.levelElementsBuffer.size() == 0) {
                return;
            }
            this.levelElementsBuffer.remove(this.levelElementsBuffer.size() - 1);
        }
    }

    public List<ReportElement> getReportElements() {
        return this.reportElements;
    }

    public void setReportElements(List<ReportElement> reportElements) {
        this.reportElements = reportElements;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

