/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberTagStatement;
import cucumber.runtime.model.ExampleStep;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CucumberScenarioOutline
extends CucumberTagStatement {
    private final List<CucumberExamples> cucumberExamplesList = new ArrayList<CucumberExamples>();
    private final CucumberBackground cucumberBackground;

    public CucumberScenarioOutline(CucumberFeature cucumberFeature, CucumberBackground cucumberBackground, ScenarioOutline scenarioOutline) {
        super(cucumberFeature, (TagStatement)scenarioOutline);
        this.cucumberBackground = cucumberBackground;
    }

    public void examples(Examples examples) {
        this.cucumberExamplesList.add(new CucumberExamples(this, examples));
    }

    public List<CucumberExamples> getCucumberExamplesList() {
        return this.cucumberExamplesList;
    }

    @Override
    public void run(Formatter formatter, Reporter reporter, Runtime runtime) {
        this.format(formatter);
        for (CucumberExamples cucumberExamples : this.cucumberExamplesList) {
            cucumberExamples.format(formatter);
            List<CucumberScenario> exampleScenarios = cucumberExamples.createExampleScenarios();
            for (CucumberScenario exampleScenario : exampleScenarios) {
                exampleScenario.run(formatter, reporter, runtime);
            }
        }
    }

    CucumberScenario createExampleScenario(ExamplesTableRow header, ExamplesTableRow example, List<Tag> examplesTags) {
        String exampleScenarioName = CucumberScenarioOutline.replaceTokens(new HashSet<Integer>(), header.getCells(), example.getCells(), this.getGherkinModel().getName());
        Scenario exampleScenario = new Scenario(example.getComments(), examplesTags, this.getGherkinModel().getKeyword(), exampleScenarioName, "", example.getLine(), example.getId());
        CucumberScenario cucumberScenario = new CucumberScenario(this.cucumberFeature, this.cucumberBackground, exampleScenario, (Row)example);
        for (Step step : this.getSteps()) {
            cucumberScenario.step(CucumberScenarioOutline.createExampleStep(step, header, example));
        }
        return cucumberScenario;
    }

    static ExampleStep createExampleStep(Step step, ExamplesTableRow header, ExamplesTableRow example) {
        HashSet<Integer> matchedColumns = new HashSet<Integer>();
        List headerCells = header.getCells();
        List exampleCells = example.getCells();
        String name = CucumberScenarioOutline.replaceTokens(matchedColumns, headerCells, exampleCells, step.getName());
        return new ExampleStep(step.getComments(), step.getKeyword(), name, step.getLine(), CucumberScenarioOutline.rowsWithTokensReplaced(step.getRows(), headerCells, exampleCells, matchedColumns), CucumberScenarioOutline.docStringWithTokensReplaced(step.getDocString(), headerCells, exampleCells, matchedColumns), matchedColumns);
    }

    private static List<DataTableRow> rowsWithTokensReplaced(List<DataTableRow> rows, List<String> headerCells, List<String> exampleCells, Set<Integer> matchedColumns) {
        if (rows != null) {
            ArrayList<DataTableRow> newRows = new ArrayList<DataTableRow>(rows.size());
            for (Row row : rows) {
                ArrayList<String> newCells = new ArrayList<String>(row.getCells().size());
                for (String cell : row.getCells()) {
                    newCells.add(CucumberScenarioOutline.replaceTokens(matchedColumns, headerCells, exampleCells, cell));
                }
                newRows.add(new DataTableRow(row.getComments(), newCells, row.getLine()));
            }
            return newRows;
        }
        return null;
    }

    private static DocString docStringWithTokensReplaced(DocString docString, List<String> headerCells, List<String> exampleCells, Set<Integer> matchedColumns) {
        if (docString != null) {
            String docStringValue = CucumberScenarioOutline.replaceTokens(matchedColumns, headerCells, exampleCells, docString.getValue());
            return new DocString(docString.getContentType(), docStringValue, Integer.valueOf(docString.getLine()));
        }
        return null;
    }

    private static String replaceTokens(Set<Integer> matchedColumns, List<String> headerCells, List<String> exampleCells, String text) {
        for (int col = 0; col < headerCells.size(); ++col) {
            String headerCell = headerCells.get(col);
            String value = exampleCells.get(col);
            String token = "<" + headerCell + ">";
            if (!text.contains(token)) continue;
            if ((text = text.replace(token, value)).isEmpty()) {
                throw new CucumberException("Step generated from scenario outline '" + token + "' is empty");
            }
            matchedColumns.add(col);
        }
        return text;
    }
}

