/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.Converter;
import cucumber.deps.com.thoughtworks.xstream.converters.MarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.UnmarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.runtime.xstream.ConverterWithEnumFormat;
import cucumber.runtime.xstream.SingleValueConverterWrapperExt;
import java.util.Locale;

public class DynamicEnumConverter
implements Converter {
    private final Locale locale;

    public DynamicEnumConverter(Locale locale) {
        this.locale = locale;
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.wrappedConvertor(o.getClass()).marshal(o, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class enumClass = context.getRequiredType();
        return this.wrappedConvertor(enumClass).unmarshal(reader, context);
    }

    private Converter wrappedConvertor(Class enumClass) {
        return new SingleValueConverterWrapperExt(new ConverterWithEnumFormat(this.locale, enumClass));
    }

    public boolean canConvert(Class type) {
        return type.isEnum();
    }
}

