/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class SanityChecker
implements TestListener {
    private static final String INDENT = "  ";
    public static final String INSANITY = "INSANITY";
    private List<Test> tests = new ArrayList<Test>();
    private final StringWriter out = new StringWriter();

    public static void run(Class<?> testClass) {
        JUnit4TestAdapter testAdapter = new JUnit4TestAdapter(testClass);
        TestResult result = new TestResult();
        SanityChecker listener = new SanityChecker();
        result.addListener((TestListener)listener);
        testAdapter.run(result);
        String output = listener.getOutput();
        if (output.contains(INSANITY)) {
            throw new RuntimeException("Something went wrong\n" + output);
        }
    }

    public void addError(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
    }

    public void startTest(Test started) {
        this.spaces();
        this.out.append("START " + started.toString()).append("\n");
        this.tests.add(started);
    }

    public void endTest(Test ended) {
        try {
            Test lastStarted = this.tests.remove(this.tests.size() - 1);
            this.spaces();
            this.out.append("END   " + ended.toString()).append("\n");
            if (!lastStarted.toString().equals(ended.toString())) {
                this.out.append(INSANITY).append("\n");
                String errorMessage = String.format("Started : %s\nEnded   : %s\n", lastStarted, ended);
                this.out.append(errorMessage).append("\n");
            }
        }
        catch (Exception e) {
            this.out.append(INSANITY).append("\n");
            e.printStackTrace(new PrintWriter(this.out));
        }
    }

    private void spaces() {
        for (int i = 0; i < this.tests.size(); ++i) {
            this.out.append(INDENT);
        }
    }

    public String getOutput() {
        return this.out.toString();
    }
}

