/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.MetricStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.HashSet;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class Jaccard
extends ShingleBased
implements MetricStringDistance,
NormalizedStringDistance,
NormalizedStringSimilarity {
    public Jaccard(int k) {
        super(k);
    }

    public Jaccard() {
    }

    public final double similarity(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        Map<String, Integer> profile1 = this.getProfile(s1);
        Map<String, Integer> profile2 = this.getProfile(s2);
        HashSet<String> union = new HashSet<String>();
        union.addAll(profile1.keySet());
        union.addAll(profile2.keySet());
        int inter = 0;
        for (String key : union) {
            if (!profile1.containsKey(key) || !profile2.containsKey(key)) continue;
            ++inter;
        }
        return 1.0 * (double)inter / (double)union.size();
    }

    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }
}

