/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.core;

import info.simplecloud.core.annotations.Attribute;
import info.simplecloud.core.annotations.Extension;
import info.simplecloud.core.coding.ReflectionHelper;
import info.simplecloud.core.coding.decode.IResourceDecoder;
import info.simplecloud.core.coding.decode.JsonDecoder;
import info.simplecloud.core.coding.decode.XmlDecoder;
import info.simplecloud.core.coding.encode.IUserEncoder;
import info.simplecloud.core.coding.encode.JsonEncoder;
import info.simplecloud.core.coding.encode.XmlEncoder;
import info.simplecloud.core.exceptions.InvalidUser;
import info.simplecloud.core.exceptions.PatchingFailed;
import info.simplecloud.core.exceptions.UnknownAttribute;
import info.simplecloud.core.exceptions.UnknownEncoding;
import info.simplecloud.core.exceptions.UnknownExtension;
import info.simplecloud.core.handlers.ComplexHandler;
import info.simplecloud.core.handlers.MultiValueHandler;
import info.simplecloud.core.handlers.StringHandler;
import info.simplecloud.core.types.ComplexType;
import info.simplecloud.core.types.Meta;
import info.simplecloud.core.types.MultiValuedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Resource
extends ComplexType {
    public static final String ENCODING_JSON = "json";
    public static final String ENCODING_XML = "xml";
    private static Map<String, IUserEncoder> encoders = new HashMap<String, IUserEncoder>();
    private static Map<String, IResourceDecoder> decoders = new HashMap<String, IResourceDecoder>();
    private static String[] mandatoryAttributes;
    private List<Object> extensions = new ArrayList<Object>();
    private String id;
    private String externalId;
    private Meta meta;

    static {
        encoders.put(ENCODING_XML, new XmlEncoder());
        encoders.put(ENCODING_JSON, new JsonEncoder());
        decoders.put(ENCODING_XML, new XmlDecoder());
        decoders.put(ENCODING_JSON, new JsonDecoder());
        mandatoryAttributes = new String[]{"id", "schemas", "meta"};
    }

    protected Resource(String resource, String encoding, List<Class<?>> extensionTypes) throws UnknownEncoding, InvalidUser {
        this.addExtensions(extensionTypes);
        IResourceDecoder decoder = decoders.get(encoding.toLowerCase());
        if (decoder == null) {
            throw new UnknownEncoding(encoding);
        }
        decoder.decode(resource, this);
    }

    protected Resource(String id, List<Class<?>> extensionTypes) {
        this.addExtensions(extensionTypes);
        this.setId(id);
    }

    public static List<String> addMandatoryAttributes(List<String> attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            String[] stringArray = mandatoryAttributes;
            int n = mandatoryAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                String mandatory = stringArray[n2];
                if (!attributes.contains(mandatory)) {
                    attributes.add(mandatory);
                }
                ++n2;
            }
        }
        return attributes;
    }

    public String getResource(String encoding, List<String> attributes) throws UnknownEncoding {
        IUserEncoder encoder = encoders.get(encoding.toLowerCase());
        if (encoder == null) {
            throw new UnknownEncoding(encoding);
        }
        Resource.addMandatoryAttributes(attributes);
        return encoder.encode(this, attributes);
    }

    public String getResourcePatch(String encoding, List<String> attributes) throws UnknownEncoding {
        IUserEncoder encoder = encoders.get(encoding.toLowerCase());
        if (encoder == null) {
            throw new UnknownEncoding(encoding);
        }
        return encoder.encode(this, attributes);
    }

    public static List<Resource> getResources(String users, String encoding, List<Resource> resources, Class<?> type) throws UnknownEncoding, InvalidUser {
        IResourceDecoder decoder = decoders.get(encoding.toLowerCase());
        if (decoder == null) {
            throw new UnknownEncoding(encoding);
        }
        decoder.decode(users, resources, type);
        return resources;
    }

    public abstract void patch(String var1, String var2) throws UnknownEncoding, InvalidUser, UnknownAttribute;

    protected void patch(Resource patch) throws UnknownEncoding, InvalidUser, UnknownAttribute {
        List<MultiValuedType<String>> attributesToDelete;
        Meta meta = patch.getMeta();
        if (meta != null && (attributesToDelete = meta.getAttributes()) != null) {
            for (MultiValuedType<String> id : attributesToDelete) {
                super.removeAttribute(id.getValue());
            }
        }
        patch.setMeta(null);
        for (Object extension : this.extensions) {
            if (extension == this) continue;
            Method[] methodArray = extension.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(Attribute.class)) {
                    try {
                        Object patchObj = patch.getExtension(extension.getClass());
                        Method patchMethod = patchObj.getClass().getMethod(method.getName(), method.getParameterTypes());
                        Object patchData = patchMethod.invoke(patchObj, new Object[0]);
                        String setter = "s" + method.getName().substring(1);
                        ReflectionHelper.getMethod(setter, extension.getClass()).invoke(extension, patchData);
                    }
                    catch (Exception e) {
                        throw new PatchingFailed("Failed to patch user, retriving and setting value, method:" + method.getName() + " , class:" + extension.getClass().getName(), e);
                    }
                }
                ++n2;
            }
        }
        new ComplexHandler().merge(patch, this);
    }

    public <T> T getExtension(Class<?> type) throws UnknownExtension {
        int i = 0;
        while (i < this.extensions.size()) {
            if (this.extensions.get(i).getClass() == type) {
                return (T)this.extensions.get(i);
            }
            ++i;
        }
        throw new UnknownExtension("Could not find object for type '" + type.getName() + "'");
    }

    public List<Object> getExtensions() {
        return this.extensions;
    }

    private void addExtensions(List<Class<?>> extensionTypes) {
        for (Class<?> clazz : extensionTypes) {
            try {
                this.extensions.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create extension instance from '" + clazz.getName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to create extension instance from '" + clazz.getName() + "'", e);
            }
        }
    }

    @Override
    public <T> T getAttribute(String name) throws UnknownAttribute {
        if (name == null) {
            throw new IllegalArgumentException("The name argument cannot be null");
        }
        for (Object extension : this.extensions) {
            String schema;
            Extension extensionAttribute = extension.getClass().getAnnotation(Extension.class);
            if (extensionAttribute == null || (schema = extensionAttribute.schema()) == null || !name.startsWith(schema)) continue;
            String methodName = name.substring(schema.length() + 1);
            if (methodName.contains(".")) {
                String localName = methodName.substring(0, methodName.indexOf("."));
                String nextName = methodName.substring(methodName.indexOf(".") + 1, methodName.length());
                Method method = this.findAttributeMethodOnExtension(localName, extension);
                ComplexType next = (ComplexType)this.invokeMethod(method, localName, extension);
                if (next == null) {
                    return null;
                }
                return next.getAttribute(nextName);
            }
            Method method = this.findAttributeMethodOnExtension(methodName, extension);
            return (T)this.invokeMethod(method, name, extension);
        }
        return super.getAttribute(name);
    }

    private Method findAttributeMethodOnExtension(String name, Object extension) throws UnknownAttribute {
        Method[] methodArray = extension.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class) && (attribute = method.getAnnotation(Attribute.class)).name().equals(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ComplexType setAttribute(String name, Object attribute) throws UnknownAttribute {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        for (Object extension : this.extensions) {
            String schema;
            Extension extensionAttribute = extension.getClass().getAnnotation(Extension.class);
            if (extensionAttribute == null || (schema = extensionAttribute.schema()) == null || !name.startsWith(schema)) continue;
            String methodName = name.substring(schema.length() + 1);
            if (methodName.contains(".")) {
                String localName = methodName.substring(0, methodName.indexOf("."));
                String nextName = methodName.substring(methodName.indexOf(".") + 1, methodName.length());
                Method method = this.findAttributeMethodOnExtension(localName, extension);
                ComplexType next = (ComplexType)this.invokeMethod(method, localName, extension);
                if (next == null) {
                    next = this.getMetaData(localName, extension).newInstance();
                    String setter = "s" + method.getName().substring(1);
                    Method setMethod = null;
                    try {
                        setMethod = ReflectionHelper.getMethod(setter, extension.getClass());
                        setMethod.invoke(extension, next);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
                    }
                }
                next.setAttribute(nextName, attribute);
                return this;
            }
            Method method = this.findAttributeMethodOnExtension(methodName, extension);
            if (method == null) {
                throw new UnknownAttribute("Has no method for attribute '" + name + "'");
            }
            String setter = "s" + method.getName().substring(1);
            Method setMethod = null;
            try {
                setMethod = ReflectionHelper.getMethod(setter, extension.getClass());
                setMethod.invoke(extension, attribute);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            return this;
        }
        return super.setAttribute(name, attribute);
    }

    @Attribute(name="id", handler=StringHandler.class)
    public String getId() {
        return this.id;
    }

    @Attribute(name="schemas", handler=MultiValueHandler.class, internalHandler=StringHandler.class)
    public List<MultiValuedType<String>> getSchemas() {
        ArrayList<MultiValuedType<String>> schemas = new ArrayList<MultiValuedType<String>>();
        if (!this.getClass().isAnnotationPresent(Extension.class)) {
            throw new RuntimeException("Extension class '" + this.getClass().getName() + "' is missing annotation");
        }
        Extension metaData = this.getClass().getAnnotation(Extension.class);
        schemas.add(new MultiValuedType<String>(metaData.schema(), null, false, false));
        for (Object extension : this.extensions) {
            if (!extension.getClass().isAnnotationPresent(Extension.class)) {
                throw new RuntimeException("Extension class '" + extension.getClass().getName() + "' is missing annotation");
            }
            metaData = extension.getClass().getAnnotation(Extension.class);
            schemas.add(new MultiValuedType<String>(metaData.schema(), null, false, false));
        }
        return schemas;
    }

    @Attribute(name="meta", handler=ComplexHandler.class, type=Meta.class)
    public Meta getMeta() {
        return this.meta;
    }

    @Attribute(name="externalId", handler=StringHandler.class)
    public String getExternalId() {
        return this.externalId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSchemas(List<String> schemas) {
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof Resource)) {
            return false;
        }
        Resource otherResource = (Resource)otherObj;
        if (otherResource.getExtensions().size() != this.getExtensions().size()) {
            return false;
        }
        try {
            Iterator<Object> iterator = this.extensions.iterator();
            block7: while (true) {
                if (!iterator.hasNext()) {
                    return super.equals(otherObj);
                }
                Object myExtension = iterator.next();
                Object otherExtension = otherResource.getExtension(myExtension.getClass());
                Method[] methodArray = myExtension.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block7;
                    Method myMethod = methodArray[n2];
                    if (myMethod.isAnnotationPresent(Attribute.class)) {
                        Object otherData;
                        Method otherMethod = otherExtension.getClass().getMethod(myMethod.getName(), new Class[0]);
                        Object myData = myMethod.invoke(myExtension, new Object[0]);
                        if (myData != (otherData = otherMethod.invoke(otherExtension, new Object[0]))) {
                            if (myData != null) {
                                if (!myData.equals(otherData)) return false;
                            }
                            if (otherData != null && !otherData.equals(myData)) {
                                return false;
                            }
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (UnknownExtension e) {
            return false;
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, extension comparing", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, extension comparing", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, extension comparing", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, extension comparing", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, extension comparing", e);
        }
    }

    private Object invokeMethod(Method method, String name, Object extension) throws UnknownAttribute {
        try {
            if (method == null) {
                throw new UnknownAttribute("Could not find attribute '" + name + "'");
            }
            return method.invoke(extension, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
    }
}

