/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.core.coding.encode;

import info.simplecloud.core.MetaData;
import info.simplecloud.core.Resource;
import info.simplecloud.core.annotations.Attribute;
import info.simplecloud.core.annotations.Complex;
import info.simplecloud.core.annotations.Extension;
import info.simplecloud.core.coding.ReflectionHelper;
import info.simplecloud.core.coding.encode.IEncodeHandler;
import info.simplecloud.core.coding.encode.IUserEncoder;
import info.simplecloud.core.coding.encode.JsonEncoder;
import info.simplecloud.core.exceptions.FactoryNotFoundException;
import info.simplecloud.core.handlers.ComplexHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import x0.scimSchemasCore1.Response;
import x0.scimSchemasCore1.ResponseDocument;

public class XmlEncoder
implements IUserEncoder {
    private static final boolean PRETTY_PRINT = Boolean.parseBoolean(System.getProperty(String.valueOf(JsonEncoder.class.getName()) + ".PRETTY_PRINT", "true"));

    @Override
    public String encode(Resource resource) {
        return this.encode(resource, null);
    }

    @Override
    public String encode(Resource resource, List<String> includeAttributes) {
        try {
            x0.scimSchemasCore1.Resource xmlResource = this.internalEncode(resource, includeAttributes);
            Complex complex = resource.getClass().getAnnotation(Complex.class);
            Class<?> factory = ReflectionHelper.getFactory(complex.xmlDoc());
            XmlObject doc = (XmlObject)factory.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
            String name = complex.xmlType().getName();
            String setterName = "set";
            setterName = String.valueOf(setterName) + name.substring(name.lastIndexOf(46) + 1);
            doc.getClass().getMethod(setterName, complex.xmlType()).invoke((Object)doc, xmlResource);
            return PRETTY_PRINT ? doc.toString() : doc.xmlText();
        }
        catch (FactoryNotFoundException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, xml encode failed", e);
        }
    }

    @Override
    public String encode(List<Resource> resources) {
        return this.encode(resources, null);
    }

    @Override
    public String encode(List<Resource> resources, List<String> includeAttributes) {
        Response resp = Response.Factory.newInstance();
        Response.Resources xmlResources = resp.addNewResources();
        resp.setTotalResults(resources.size());
        x0.scimSchemasCore1.Resource[] xmlResourceArray = new x0.scimSchemasCore1.Resource[resources.size()];
        int i = 0;
        while (i < resources.size()) {
            includeAttributes = Resource.addMandatoryAttributes(includeAttributes);
            xmlResourceArray[i] = this.internalEncode(resources.get(i), includeAttributes);
            ++i;
        }
        xmlResources.setResourceArray(xmlResourceArray);
        ResponseDocument doc = ResponseDocument.Factory.newInstance();
        doc.setResponse(resp);
        return PRETTY_PRINT ? doc.toString() : doc.xmlText();
    }

    private Object createXmlObject(Resource resource) {
        try {
            if (!resource.getClass().isAnnotationPresent(Complex.class)) {
                throw new RuntimeException("Missing annotation complex on, '" + resource.getClass().getName() + "'");
            }
            Complex complexMetadata = resource.getClass().getAnnotation(Complex.class);
            Class<?> factory = ReflectionHelper.getFactory(complexMetadata.xmlType());
            Method parse = factory.getMethod("newInstance", new Class[0]);
            return parse.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (FactoryNotFoundException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
    }

    private x0.scimSchemasCore1.Resource internalEncode(Resource resource, List<String> attributesList) {
        try {
            Object xmlObject = this.createXmlObject(resource);
            x0.scimSchemasCore1.Resource xmlResource = (x0.scimSchemasCore1.Resource)new ComplexHandler().encodeXml(resource, attributesList, null, xmlObject);
            List<Object> extensions = resource.getExtensions();
            for (Object extension : extensions) {
                if (!extension.getClass().isAnnotationPresent(Extension.class)) {
                    throw new RuntimeException("The extension '" + extension.getClass().getName() + "' has no namespace, try to add Extension annotation to class");
                }
                Extension extensionMetaData = extension.getClass().getAnnotation(Extension.class);
                Method[] methodArray = extension.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object data;
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(Attribute.class) && (data = method.invoke(extension, new Object[0])) != null) {
                        MetaData metaData = new MetaData(method.getAnnotation(Attribute.class));
                        String attributeName = String.valueOf(extensionMetaData.schema()) + "." + metaData.getName();
                        if (attributesList == null || attributesList.contains(attributeName)) {
                            Class<?> factory = ReflectionHelper.getFactory(metaData.getXmlDoc());
                            XmlObject doc = (XmlObject)factory.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
                            Object innerXml = null;
                            try {
                                String adder = "addNew";
                                adder = String.valueOf(adder) + metaData.getName().substring(0, 1).toUpperCase();
                                adder = String.valueOf(adder) + metaData.getName().substring(1);
                                innerXml = doc.getClass().getMethod(adder, new Class[0]).invoke((Object)doc, new Object[0]);
                            }
                            catch (NoSuchMethodException adder) {
                                // empty catch block
                            }
                            IEncodeHandler encoder = metaData.getEncoder();
                            Object result = encoder.encodeXml(data, attributesList, metaData.getInternalMetaData(), innerXml);
                            String setter = "set";
                            setter = String.valueOf(setter) + metaData.getName().substring(0, 1).toUpperCase();
                            setter = String.valueOf(setter) + metaData.getName().substring(1);
                            ReflectionHelper.getMethod(setter, doc.getClass()).invoke((Object)doc, result);
                            XmlCursor docCursor = doc.newCursor();
                            docCursor.toFirstChild();
                            XmlCursor cursor = xmlResource.newCursor();
                            cursor.toEndToken();
                            docCursor.moveXml(cursor);
                            cursor.dispose();
                            docCursor.dispose();
                        }
                    }
                    ++n2;
                }
            }
            return xmlResource;
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (FactoryNotFoundException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, encoding xml", e);
        }
    }
}

