/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.core.handlers;

import info.simplecloud.core.MetaData;
import info.simplecloud.core.coding.ReflectionHelper;
import info.simplecloud.core.coding.decode.IDecodeHandler;
import info.simplecloud.core.coding.encode.IEncodeHandler;
import info.simplecloud.core.exceptions.InvalidUser;
import info.simplecloud.core.handlers.HandlerHelper;
import info.simplecloud.core.merging.IMerger;
import info.simplecloud.core.types.MultiValuedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiValueHandler
implements IDecodeHandler,
IEncodeHandler,
IMerger {
    @Override
    public Object decode(Object jsonData, Object me, MetaData internalMetaData) throws InvalidUser {
        JSONArray jsonArray = (JSONArray)jsonData;
        ArrayList<MultiValuedType<Object>> result = new ArrayList<MultiValuedType<Object>>();
        int nrPrimary = 0;
        IDecodeHandler decoder = internalMetaData.getDecoder();
        Object value = null;
        int i = 0;
        while (i < jsonArray.length()) {
            Object decodedValue;
            JSONObject internalObj = jsonArray.optJSONObject(i);
            if (internalObj != null) {
                value = internalObj.opt("value");
                decodedValue = decoder.decode(value == null ? internalObj : value, internalMetaData.newInstance(), internalMetaData.getInternalMetaData());
                String type = internalObj.optString("type");
                String display = internalObj.optString("display");
                String operation = internalObj.optString("operation");
                Boolean primary = internalObj.optBoolean("primary");
                nrPrimary += primary != false ? 1 : 0;
                result.add(new MultiValuedType<Object>(decodedValue, type, display, primary, operation));
            } else {
                value = jsonArray.opt(i);
                decodedValue = decoder.decode(value, internalMetaData.newInstance(), internalMetaData.getInternalMetaData());
                result.add(new MultiValuedType<Object>(decodedValue, null, false, false));
            }
            ++i;
        }
        if (nrPrimary > 1) {
            throw new InvalidUser("Only one primary value is allowed");
        }
        return result;
    }

    @Override
    public Object decodeXml(Object value, Object me, MetaData internalMetaData) throws InvalidUser {
        ArrayList<MultiValuedType<Object>> result = new ArrayList<MultiValuedType<Object>>();
        String name = internalMetaData.getName();
        String getterName = "get";
        getterName = String.valueOf(getterName) + name.substring(0, 1).toUpperCase();
        getterName = String.valueOf(getterName) + name.substring(1);
        getterName = String.valueOf(getterName) + "Array";
        try {
            Method getter = value.getClass().getMethod(getterName, new Class[0]);
            Object[] array = (Object[])getter.invoke(value, new Object[0]);
            int nrPrimary = 0;
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IDecodeHandler decoder = internalMetaData.getDecoder();
                Object internalValue = decoder.decodeXml(obj, internalMetaData.newInstance(), internalMetaData.getInternalMetaData());
                String type = (String)this.readXml(obj, "getType");
                String display = (String)this.readXml(obj, "getDisplay");
                Boolean primary = (Boolean)this.readXml(obj, "getPrimary");
                primary = primary == null ? false : primary;
                String operation = (String)this.readXml(obj, "getOperation");
                nrPrimary += primary != false ? 1 : 0;
                result.add(new MultiValuedType<Object>(internalValue, type, display, primary, operation));
                ++n2;
            }
            if (nrPrimary > 1) {
                throw new InvalidUser("Only one primary value is allowed");
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, decoding plural", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, decoding plural", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, decoding plural", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, decoding plural", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, decoding plural", e);
        }
        return result;
    }

    @Override
    public Object encode(Object me, List<String> includeAttributes, MetaData internalMetaData, JSONObject internalJsonObject) {
        List plural = (List)me;
        JSONArray result = new JSONArray();
        for (MultiValuedType singular : plural) {
            JSONObject jsonObject = new JSONObject();
            IEncodeHandler encoder = internalMetaData.getEncoder();
            Object value = encoder.encode(singular.getValue(), includeAttributes, null, jsonObject);
            if (singular.isSimple() && !(value instanceof JSONObject)) {
                result.put(value);
                continue;
            }
            try {
                if (!(value instanceof JSONObject)) {
                    jsonObject.put("value", value);
                }
                jsonObject.put("type", singular.getType());
                jsonObject.put("display", singular.getDisplay());
                if (singular.isPrimary()) {
                    jsonObject.put("primary", singular.isPrimary());
                }
                if (singular.isDelete()) {
                    jsonObject.put("operation", "delete");
                }
                result.put(jsonObject);
            }
            catch (JSONException e) {
                throw new RuntimeException("Internal error, encoding multivalued type", e);
            }
        }
        return result;
    }

    @Override
    public Object encodeXml(Object me, List<String> includeAttributes, MetaData internalMetaData, Object xmlObject) {
        List plural = (List)me;
        try {
            for (MultiValuedType singular : plural) {
                Object value = singular.getValue();
                IEncodeHandler encoder = internalMetaData.getEncoder();
                Object internalXmlObject = HandlerHelper.createInternalXmlObject(xmlObject, internalMetaData.getName());
                encoder.encodeXml(value, includeAttributes, internalMetaData, internalXmlObject);
                this.writeXml(internalXmlObject, singular.getType(), "setType");
                this.writeXml(internalXmlObject, singular.getDisplay(), "setDisplay");
                if (singular.isPrimary()) {
                    this.writeXml(internalXmlObject, singular.isPrimary(), "setPrimary");
                }
                if (!singular.isDelete()) continue;
                this.writeXml(internalXmlObject, "delete", "setOperation");
            }
            return xmlObject;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal error, encoding plural xml", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error, encoding plural xml", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Internal error, encoding plural xml", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Internal error, encoding plural xml", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, encoding plural xml", e);
        }
    }

    @Override
    public Object merge(Object from, Object to) {
        List toList = (List)to;
        List fromList = (List)from;
        for (MultiValuedType singular : fromList) {
            if (singular.isDelete()) {
                toList.remove(singular);
                continue;
            }
            if (singular.isPrimary()) {
                toList.remove(singular);
                this.clearPrimary(toList);
                toList.add(singular);
                continue;
            }
            if (toList.contains(singular)) {
                toList.remove(singular);
                toList.add(singular);
                continue;
            }
            toList.add(singular);
        }
        return to;
    }

    private void clearPrimary(List<MultiValuedType> list) {
        for (MultiValuedType singular : list) {
            singular.setPrimary(false);
        }
    }

    private Object getOptional(JSONObject jsonObject, String name) {
        try {
            return jsonObject.get(name);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private Object readXml(Object obj, String method) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getValueMethod = obj.getClass().getMethod(method, new Class[0]);
        return getValueMethod.invoke(obj, new Object[0]);
    }

    private void writeXml(Object internalXmlObject, Object obj, String methodName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = ReflectionHelper.getMethod(methodName, internalXmlObject.getClass());
        method.invoke(internalXmlObject, obj);
    }
}

