/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.core.types;

import info.simplecloud.core.MetaData;
import info.simplecloud.core.annotations.Attribute;
import info.simplecloud.core.coding.ReflectionHelper;
import info.simplecloud.core.exceptions.UnknownAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class ComplexType {
    public <T> T getAttribute(String name) throws UnknownAttribute {
        if (name.contains(".")) {
            String localName = name.substring(0, name.indexOf("."));
            String nextName = name.substring(name.indexOf(".") + 1, name.length());
            Method method = this.findAttributeMethod(localName);
            ComplexType next = (ComplexType)this.invokeMethod(method, localName);
            if (next == null) {
                return null;
            }
            return next.getAttribute(nextName);
        }
        Method method = this.findAttributeMethod(name);
        return (T)this.invokeMethod(method, name);
    }

    public ComplexType setAttribute(String name, Object attribute) throws UnknownAttribute {
        if (name.contains(".")) {
            String localName = name.substring(0, name.indexOf("."));
            String nextName = name.substring(name.indexOf(".") + 1, name.length());
            Method method = this.findAttributeMethod(localName);
            ComplexType next = (ComplexType)this.invokeMethod(method, localName);
            if (next == null) {
                next = this.getMetaData(localName).newInstance();
                this.setAttribute(localName, next);
            }
            next.setAttribute(nextName, attribute);
        } else {
            Method method = this.findAttributeMethod(name);
            if (method == null) {
                throw new UnknownAttribute("Has no method for attribute '" + name + "'");
            }
            String setter = "s" + method.getName().substring(1);
            Method setMethod = null;
            try {
                setMethod = ReflectionHelper.getMethod(setter, this.getClass());
                setMethod.invoke((Object)this, attribute);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to call setter '" + setter + "' on '" + setMethod.getDeclaringClass().getName() + "' to set attribute '" + name + "'", e);
            }
        }
        return this;
    }

    public void removeAttribute(String id) throws UnknownAttribute {
        this.setAttribute(id, null);
    }

    public boolean equals(Object otherObj) {
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof ComplexType)) {
            return false;
        }
        ComplexType otherComplex = (ComplexType)otherObj;
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = method.getAnnotation(Attribute.class);
                try {
                    Object otherInternal = otherComplex.getAttribute(attribute.name());
                    Object meInternal = method.invoke((Object)this, new Object[0]);
                    if (otherInternal != meInternal && (meInternal != null && !meInternal.equals(otherInternal) || otherInternal != null && !otherInternal.equals(meInternal))) {
                        return false;
                    }
                }
                catch (UnknownAttribute e) {
                    throw new RuntimeException("Internal error", e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Internal error", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Internal error", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Internal error", e);
                }
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class)) {
                try {
                    Object attribute = method.invoke((Object)this, new Object[0]);
                    if (attribute != null) {
                        Attribute metadata = method.getAnnotation(Attribute.class);
                        sb.append(metadata.name()).append(": ");
                        sb.append(attribute.toString()).append(", ");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("toString internal error", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("toString internal error", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("toString internal error", e);
                }
            }
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    private Object invokeMethod(Method method, String name) throws UnknownAttribute {
        try {
            if (method == null) {
                throw new UnknownAttribute("Could not find attribute '" + name + "'");
            }
            return method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to read value for attribute '" + name + "'", e);
        }
    }

    private Method findAttributeMethod(String name) {
        Class<?> currentClass = this.getClass();
        Method[] methodArray = currentClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute annotation;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class) && name.equals((annotation = method.getAnnotation(Attribute.class)).name())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public List<String> getNames() {
        ArrayList<String> result = new ArrayList<String>();
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class)) {
                Attribute metaData = method.getAnnotation(Attribute.class);
                result.add(metaData.name());
            }
            ++n2;
        }
        return result;
    }

    public MetaData getMetaData(String name) throws UnknownAttribute {
        return this.getMetaData(name, this);
    }

    public MetaData getMetaData(String name, Object on) throws UnknownAttribute {
        Method[] methodArray = on.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute metaData;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Attribute.class) && name.equals((metaData = method.getAnnotation(Attribute.class)).name())) {
                return new MetaData(metaData);
            }
            ++n2;
        }
        throw new UnknownAttribute("Could not find metadata for attribute '" + name + "'");
    }

    public boolean hasAttribute(String name) {
        try {
            this.getMetaData(name);
            return true;
        }
        catch (UnknownAttribute e) {
            return false;
        }
    }
}

