/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp;

import io.activej.async.process.AbstractAsyncCloseable;
import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.ChannelConsumer;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChannelConsumer<T>
extends AbstractAsyncCloseable
implements ChannelConsumer<T> {
    protected static final boolean CHECK = Checks.isEnabled(AbstractChannelConsumer.class);

    protected AbstractChannelConsumer() {
        this.setCloseable(null);
    }

    protected AbstractChannelConsumer(@Nullable AsyncCloseable closeable) {
        this.setCloseable(closeable);
    }

    protected abstract Promise<Void> doAccept(@Nullable T var1);

    @Override
    @NotNull
    public final Promise<Void> accept(@Nullable T value) {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        if (this.isClosed()) {
            Recyclers.recycle(value);
            return Promise.ofException((Throwable)this.getException());
        }
        return this.doAccept(value);
    }
}

