/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.api.DecoderFunction;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.Utils;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ByteBufsDecoder<T> {
    @Nullable
    public T tryDecode(ByteBufs var1) throws MalformedDataException;

    default public <V> ByteBufsDecoder<V> andThen(DecoderFunction<? super T, ? extends V> after) {
        return bufs -> {
            T maybeResult = this.tryDecode(bufs);
            if (maybeResult == null) {
                return null;
            }
            return after.decode(maybeResult);
        };
    }

    public static ByteBufsDecoder<byte[]> assertBytes(byte[] data) {
        return bufs -> (byte[])(bufs.consumeBytes((index, b) -> {
            if (b != data[index]) {
                throw new MalformedDataException("Array of bytes differs at index " + index + "[Expected: " + data[index] + ", actual: " + b + ']');
            }
            return index == data.length - 1;
        }) != 0 ? data : null);
    }

    public static ByteBufsDecoder<ByteBuf> ofFixedSize(int length) {
        return bufs -> {
            if (!bufs.hasRemainingBytes(length)) {
                return null;
            }
            return bufs.takeExactSize(length);
        };
    }

    public static ByteBufsDecoder<ByteBuf> ofNullTerminatedBytes() {
        return ByteBufsDecoder.ofNullTerminatedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofNullTerminatedBytes(int maxSize) {
        return Utils.decodeUntilTerminatorByte((byte)0, maxSize);
    }

    public static ByteBufsDecoder<ByteBuf> ofCrTerminatedBytes() {
        return ByteBufsDecoder.ofCrTerminatedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofCrTerminatedBytes(int maxSize) {
        return Utils.decodeUntilTerminatorByte((byte)13, maxSize);
    }

    public static ByteBufsDecoder<ByteBuf> ofCrlfTerminatedBytes() {
        return ByteBufsDecoder.ofCrlfTerminatedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofCrlfTerminatedBytes(final int maxSize) {
        return bufs -> {
            int bytes = bufs.scanBytes(new ByteBufs.ByteScanner(){
                boolean crFound;

                public boolean consume(int index, byte b) throws MalformedDataException {
                    if (this.crFound) {
                        if (b == 10) {
                            return true;
                        }
                        this.crFound = false;
                    }
                    if (index == maxSize - 1) {
                        throw new MalformedDataException("No CRLF is found in " + maxSize + " bytes");
                    }
                    if (b == 13) {
                        this.crFound = true;
                    }
                    return false;
                }
            });
            if (bytes == 0) {
                return null;
            }
            ByteBuf buf = bufs.takeExactSize(bytes);
            buf.moveTail(-2);
            return buf;
        };
    }

    public static ByteBufsDecoder<ByteBuf> ofIntSizePrefixedBytes() {
        return ByteBufsDecoder.ofIntSizePrefixedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofIntSizePrefixedBytes(int maxSize) {
        Utils.IntScanner scanner = new Utils.IntScanner();
        return bufs -> {
            if (bufs.scanBytes((ByteBufs.ByteScanner)scanner) == 0) {
                return null;
            }
            int size = scanner.result;
            if (size < 0) {
                throw new InvalidSizeException("Invalid size of bytes to be read, should be greater than 0");
            }
            if (size > maxSize) {
                throw new InvalidSizeException("Size exceeds max size");
            }
            if (!bufs.hasRemainingBytes(4 + size)) {
                return null;
            }
            bufs.skip(4);
            return bufs.takeExactSize(size);
        };
    }

    public static ByteBufsDecoder<ByteBuf> ofShortSizePrefixedBytes() {
        return ByteBufsDecoder.ofShortSizePrefixedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofShortSizePrefixedBytes(int maxSize) {
        return bufs -> {
            if (!bufs.hasRemainingBytes(2)) {
                return null;
            }
            int size = (bufs.peekByte(0) & 0xFF) << 8 | bufs.peekByte(1) & 0xFF;
            if (size > maxSize) {
                throw new InvalidSizeException("Size exceeds max size");
            }
            if (!bufs.hasRemainingBytes(2 + size)) {
                return null;
            }
            bufs.skip(2);
            return bufs.takeExactSize(size);
        };
    }

    public static ByteBufsDecoder<ByteBuf> ofByteSizePrefixedBytes() {
        return ByteBufsDecoder.ofByteSizePrefixedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofByteSizePrefixedBytes(int maxSize) {
        return bufs -> {
            if (!bufs.hasRemaining()) {
                return null;
            }
            int size = bufs.peekByte() & 0xFF;
            if (size > maxSize) {
                throw new InvalidSizeException("Size exceeds max size");
            }
            if (!bufs.hasRemainingBytes(1 + size)) {
                return null;
            }
            bufs.skip(1);
            return bufs.takeExactSize(size);
        };
    }

    public static ByteBufsDecoder<ByteBuf> ofVarIntSizePrefixedBytes() {
        return ByteBufsDecoder.ofVarIntSizePrefixedBytes(Integer.MAX_VALUE);
    }

    public static ByteBufsDecoder<ByteBuf> ofVarIntSizePrefixedBytes(int maxSize) {
        Utils.VarIntScanner scanner = new Utils.VarIntScanner();
        return bufs -> {
            int bytes = bufs.scanBytes((ByteBufs.ByteScanner)scanner);
            if (bytes == 0) {
                return null;
            }
            int size = scanner.result;
            if (size < 0) {
                throw new InvalidSizeException("Invalid size of bytes to be read, should be greater than 0");
            }
            if (size > maxSize) {
                throw new InvalidSizeException("Size exceeds max size");
            }
            if (!bufs.hasRemainingBytes(bytes + size)) {
                return null;
            }
            bufs.skip(bytes);
            return bufs.takeExactSize(size);
        };
    }
}

