/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.file;

import io.activej.async.file.AsyncFileService;
import io.activej.async.file.ExecutorAsyncFileService;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.csp.AbstractChannelConsumer;
import io.activej.promise.Promise;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelFileWriter
extends AbstractChannelConsumer<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileWriter.class);
    private static final OpenOption[] DEFAULT_OPTIONS = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND};
    private final AsyncFileService fileService;
    private final FileChannel channel;
    private boolean forceOnClose = false;
    private boolean forceMetadata = false;
    private long startingOffset = 0L;
    private boolean started;
    private long position = 0L;

    private ChannelFileWriter(AsyncFileService fileService, FileChannel channel) {
        this.fileService = fileService;
        this.channel = channel;
    }

    public static ChannelFileWriter create(Executor executor, FileChannel channel) {
        return ChannelFileWriter.create((AsyncFileService)new ExecutorAsyncFileService(executor), channel);
    }

    public static ChannelFileWriter create(AsyncFileService fileService, FileChannel channel) {
        return new ChannelFileWriter(fileService, channel);
    }

    public static Promise<ChannelFileWriter> open(Executor executor, Path path) {
        return ChannelFileWriter.open(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<ChannelFileWriter> open(Executor executor, Path path, OpenOption ... openOptions) {
        Checks.checkArgument((boolean)Arrays.asList(openOptions).contains(StandardOpenOption.WRITE), (Object)"'WRITE' option is not present");
        return Promise.ofBlockingCallable((Executor)executor, () -> FileChannel.open(path, openOptions)).map(channel -> ChannelFileWriter.create(executor, channel));
    }

    public static ChannelFileWriter openBlocking(Executor executor, Path path) throws IOException {
        return ChannelFileWriter.openBlocking(executor, path, DEFAULT_OPTIONS);
    }

    public static ChannelFileWriter openBlocking(Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        Checks.checkArgument((boolean)Arrays.asList(openOptions).contains(StandardOpenOption.WRITE), (Object)"'WRITE' option is not present");
        FileChannel channel = FileChannel.open(path, openOptions);
        return ChannelFileWriter.create(executor, channel);
    }

    public ChannelFileWriter withForceOnClose(boolean forceMetadata) {
        this.forceOnClose = true;
        this.forceMetadata = forceMetadata;
        return this;
    }

    public ChannelFileWriter withOffset(long offset) {
        this.startingOffset = offset;
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    protected void onClosed(@NotNull Throwable e) {
        try {
            this.closeFile();
        }
        catch (IOException ex) {
            logger.error("{}: failed to close file", (Object)this, (Object)ex);
        }
    }

    @Override
    protected Promise<Void> doAccept(ByteBuf buf) {
        if (!this.started) {
            this.position = this.startingOffset;
        }
        this.started = true;
        if (buf == null) {
            try {
                this.closeFile();
            }
            catch (IOException e) {
                return Promise.ofException((Throwable)e);
            }
            this.close();
            return Promise.of(null);
        }
        long p = this.position;
        this.position += (long)buf.readRemaining();
        byte[] array = buf.getArray();
        return this.fileService.write(this.channel, p, array, 0, array.length).thenEx(($, e2) -> {
            if (this.isClosed()) {
                return Promise.ofException((Throwable)this.getException());
            }
            if (e2 != null) {
                this.closeEx((Throwable)e2);
            }
            return Promise.of((Object)$, (Throwable)e2);
        }).then(() -> {
            buf.recycle();
            return Promise.complete();
        });
    }

    private void closeFile() throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        if (this.forceOnClose) {
            this.channel.force(this.forceMetadata);
        }
        this.channel.close();
        logger.trace("{}: closed file", (Object)this);
    }

    public String toString() {
        return "ChannelFileWriter{pos=" + this.position + '}';
    }
}

