/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process;

import io.activej.common.Checks;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelOutput;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.eventloop.Eventloop;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChannelTransformer<S extends AbstractChannelTransformer<S, I, O>, I, O>
extends AbstractCommunicatingProcess
implements WithChannelTransformer<S, I, O> {
    protected ChannelSupplier<I> input;
    protected ChannelConsumer<O> output;

    protected final Promise<Void> send(O item) {
        return this.output.accept(item);
    }

    protected final Promise<Void> sendEndOfStream() {
        return this.output.acceptEndOfStream();
    }

    @NotNull
    protected abstract Promise<Void> onItem(I var1);

    protected Promise<Void> onProcessFinish() {
        return this.sendEndOfStream();
    }

    protected Promise<Void> onProcessStart() {
        return Promise.complete();
    }

    @Override
    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    @Override
    protected void doProcess() {
        Promise.complete().then(this::onProcessStart).then(() -> this.input.streamTo(ChannelConsumer.of(this::onItem))).then(this::onProcessFinish).whenResult(this::completeProcess).whenException(this::closeEx);
    }

    @Override
    public ChannelInput<I> getInput() {
        return input -> {
            this.input = this.sanitize(input);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    @Override
    public ChannelOutput<O> getOutput() {
        return output -> {
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    @Override
    protected final void doClose(@NotNull Throwable e) {
        Eventloop.getCurrentEventloop().post(this::onCleanup);
        this.input.closeEx(e);
        this.output.closeEx(e);
    }

    protected void onCleanup() {
    }
}

