/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process;

import io.activej.bytebuf.ByteBuf;
import io.activej.csp.dsl.ChannelTransformer;
import io.activej.csp.process.AbstractChannelTransformer;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

public final class ChannelByteRanger
extends AbstractChannelTransformer<ChannelByteRanger, ByteBuf, ByteBuf> {
    private final long offset;
    private final long endOffset;
    private long position;

    private ChannelByteRanger(long offset, long length) {
        this.offset = offset;
        this.endOffset = length;
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> range(long offset, long length) {
        if (offset == 0L && length == Long.MAX_VALUE) {
            return ChannelTransformer.identity();
        }
        return new ChannelByteRanger(offset, length);
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> drop(long toDrop) {
        return ChannelByteRanger.range(toDrop, Long.MAX_VALUE);
    }

    public static ChannelTransformer<ByteBuf, ByteBuf> limit(long limit) {
        return ChannelByteRanger.range(0L, limit);
    }

    @Override
    @NotNull
    protected Promise<Void> onItem(ByteBuf item) {
        int size = item.readRemaining();
        long oldPos = this.position;
        this.position += (long)size;
        if (oldPos > this.endOffset || this.position <= this.offset) {
            item.recycle();
            return Promise.complete();
        }
        if (oldPos < this.offset) {
            item.moveHead((int)(this.offset - oldPos));
        }
        if (this.position > this.endOffset) {
            item.moveTail((int)(this.endOffset - this.position));
        }
        return this.send(item);
    }
}

