/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.TruncatedDataException;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelInput;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.dsl.WithBinaryChannelInput;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.FrameFormat;
import io.activej.csp.process.frames.MissingEndOfStreamBlockException;
import io.activej.csp.process.frames.TruncatedBlockException;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

public final class ChannelFrameDecoder
extends AbstractCommunicatingProcess
implements WithChannelTransformer<ChannelFrameDecoder, ByteBuf, ByteBuf>,
WithBinaryChannelInput<ChannelFrameDecoder> {
    @NotNull
    private final BlockDecoder decoder;
    private boolean decoderResets;
    private ByteBufs bufs;
    private BinaryChannelSupplier input;
    private ChannelConsumer<ByteBuf> output;

    private ChannelFrameDecoder(@NotNull BlockDecoder decoder) {
        this.decoder = decoder;
    }

    public static ChannelFrameDecoder create(@NotNull FrameFormat format) {
        return ChannelFrameDecoder.create(format.createDecoder());
    }

    public static ChannelFrameDecoder create(@NotNull BlockDecoder decoder) {
        return new ChannelFrameDecoder(decoder);
    }

    public ChannelFrameDecoder withDecoderResets() {
        return this.withDecoderResets(true);
    }

    public ChannelFrameDecoder withDecoderResets(boolean decoderResets) {
        this.decoderResets = decoderResets;
        return this;
    }

    @Override
    public BinaryChannelInput getInput() {
        return input -> {
            this.input = input;
            this.bufs = input.getBufs();
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    @Override
    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    @Override
    protected void doProcess() {
        this.decode().whenComplete((result, e) -> {
            if (e instanceof TruncatedDataException) {
                if (this.bufs.isEmpty()) {
                    if (this.decoder.ignoreMissingEndOfStreamBlock()) {
                        this.output.acceptEndOfStream().whenResult(() -> this.completeProcess());
                    } else {
                        this.closeEx((Throwable)((Object)new MissingEndOfStreamBlockException(e)));
                    }
                } else {
                    this.closeEx((Throwable)((Object)new TruncatedBlockException(e)));
                }
            } else {
                this.sanitize(result, e).whenResult(buf -> {
                    if (buf != BlockDecoder.END_OF_STREAM) {
                        this.output.accept((ByteBuf)buf).whenResult(this::doProcess);
                    } else {
                        this.input.endOfStream().thenEx((x$0, x$1) -> this.sanitize(x$0, (Throwable)x$1)).then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
                    }
                });
            }
        });
    }

    @NotNull
    private Promise<ByteBuf> decode() {
        Promise<Void> moreDataPromise;
        do {
            if (this.bufs.isEmpty()) continue;
            try {
                ByteBuf result = this.decoder.decode(this.bufs);
                if (result != null) {
                    if (this.decoderResets) {
                        this.decoder.reset();
                    }
                    return Promise.of((Object)result);
                }
            }
            catch (MalformedDataException e) {
                this.closeEx(e);
                return Promise.ofException((Throwable)e);
            }
        } while ((moreDataPromise = this.input.needMoreData()).isResult());
        return moreDataPromise.then(this::decode);
    }

    @Override
    protected void doClose(Throwable e) {
        this.input.closeEx(e);
        this.output.closeEx(e);
    }
}

