/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.process.frames;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UnknownFormatException;
import io.activej.csp.binary.ByteBufsDecoder;
import io.activej.csp.process.frames.BlockDecoder;
import io.activej.csp.process.frames.BlockEncoder;
import io.activej.csp.process.frames.FrameFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FrameFormats {
    public static FrameFormat compound(FrameFormat mainFormat, FrameFormat ... otherFormats) {
        return new Compound(mainFormat, Arrays.asList(otherFormats));
    }

    public static FrameFormat identity() {
        return new IdentityFrameFormat();
    }

    public static FrameFormat sizePrefixed() {
        return new SizePrefixedFrameFormat();
    }

    public static FrameFormat withMagicNumber(FrameFormat frameFormat, byte[] magicNumber) {
        Checks.checkArgument((magicNumber.length != 0 ? 1 : 0) != 0, (Object)"Empty magic number");
        return new MagicNumberAdapter(frameFormat, magicNumber);
    }

    private static final class Compound
    implements FrameFormat {
        private final List<FrameFormat> formats = new ArrayList<FrameFormat>();

        Compound(FrameFormat mainFormat, List<FrameFormat> otherFormats) {
            this.formats.add(mainFormat);
            this.formats.addAll(otherFormats);
        }

        @Override
        public BlockEncoder createEncoder() {
            return this.formats.get(0).createEncoder();
        }

        @Override
        public BlockDecoder createDecoder() {
            return new BlockDecoder(){
                BlockDecoder decoder;
                BlockDecoder possibleDecoder;
                Iterator<FrameFormat> possibleDecoders;
                {
                    this.possibleDecoders = formats.iterator();
                }

                @Override
                public void reset() {
                    if (this.decoder != null) {
                        this.decoder.reset();
                    }
                }

                @Override
                public boolean ignoreMissingEndOfStreamBlock() {
                    if (this.decoder != null) {
                        return this.decoder.ignoreMissingEndOfStreamBlock();
                    }
                    return formats.stream().map(FrameFormat::createDecoder).anyMatch(BlockDecoder::ignoreMissingEndOfStreamBlock);
                }

                @Override
                @Nullable
                public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
                    if (this.decoder != null) {
                        return this.decoder.decode(bufs);
                    }
                    return this.tryNextDecoder(bufs);
                }

                private ByteBuf tryNextDecoder(ByteBufs bufs) throws MalformedDataException {
                    while (true) {
                        if (this.possibleDecoder == null) {
                            if (!this.possibleDecoders.hasNext()) {
                                throw new UnknownFormatException();
                            }
                            this.possibleDecoder = this.possibleDecoders.next().createDecoder();
                        }
                        try {
                            int bytesBeforeDecoding = bufs.remainingBytes();
                            ByteBuf buf = this.possibleDecoder.decode(bufs);
                            if (buf != null || bytesBeforeDecoding != bufs.remainingBytes()) {
                                this.decoder = this.possibleDecoder;
                                this.possibleDecoders = null;
                            }
                            return buf;
                        }
                        catch (MalformedDataException malformedDataException) {
                            this.possibleDecoder = null;
                            continue;
                        }
                        break;
                    }
                }
            };
        }
    }

    private static final class IdentityFrameFormat
    implements FrameFormat {
        private IdentityFrameFormat() {
        }

        @Override
        public BlockEncoder createEncoder() {
            return new BlockEncoder(){

                @Override
                public ByteBuf encode(ByteBuf inputBuf) {
                    return inputBuf.slice();
                }

                @Override
                public void reset() {
                }

                @Override
                public ByteBuf encodeEndOfStreamBlock() {
                    return ByteBuf.empty();
                }
            };
        }

        @Override
        public BlockDecoder createDecoder() {
            return new BlockDecoder(){

                @Override
                @Nullable
                public ByteBuf decode(ByteBufs bufs) {
                    return bufs.hasRemaining() ? bufs.takeRemaining() : null;
                }

                @Override
                public void reset() {
                }

                @Override
                public boolean ignoreMissingEndOfStreamBlock() {
                    return true;
                }
            };
        }
    }

    private static final class SizePrefixedFrameFormat
    implements FrameFormat {
        private static final byte[] ZERO_BYTE_ARRAY = new byte[]{0};

        private SizePrefixedFrameFormat() {
        }

        @Override
        public BlockEncoder createEncoder() {
            return new BlockEncoder(){

                @Override
                public ByteBuf encode(ByteBuf inputBuf) {
                    int len = inputBuf.readRemaining();
                    ByteBuf outputBuf = ByteBufPool.allocate((int)(len + 5));
                    outputBuf.writeVarInt(len);
                    outputBuf.put(inputBuf);
                    return outputBuf;
                }

                @Override
                public void reset() {
                }

                @Override
                public ByteBuf encodeEndOfStreamBlock() {
                    return ByteBuf.wrapForReading((byte[])ZERO_BYTE_ARRAY);
                }
            };
        }

        @Override
        public BlockDecoder createDecoder() {
            return new BlockDecoder(){
                private final LengthScanner lengthScanner = new LengthScanner();

                @Override
                @Nullable
                public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
                    int bytes = bufs.scanBytes((ByteBufs.ByteScanner)this.lengthScanner);
                    if (bytes == 0) {
                        return null;
                    }
                    int length = this.lengthScanner.value;
                    if (length == 0) {
                        bufs.skip(bytes);
                        return END_OF_STREAM;
                    }
                    if (!bufs.hasRemainingBytes(bytes + length)) {
                        return null;
                    }
                    bufs.skip(bytes);
                    return bufs.takeExactSize(length);
                }

                @Override
                public void reset() {
                }

                @Override
                public boolean ignoreMissingEndOfStreamBlock() {
                    return false;
                }
            };
        }

        private static final class LengthScanner
        implements ByteBufs.ByteScanner {
            public int value;

            private LengthScanner() {
            }

            public boolean consume(int index, byte b) throws MalformedDataException {
                int n = this.value = index == 0 ? b & 0x7F : this.value | (b & 0x7F) << index * 7;
                if (b >= 0) {
                    if (this.value < 0) {
                        throw new InvalidSizeException("Negative length");
                    }
                    return true;
                }
                if (index == 4) {
                    throw new InvalidSizeException("Could not read var int");
                }
                return false;
            }
        }
    }

    private static final class MagicNumberAdapter
    implements FrameFormat {
        private final FrameFormat peerFormat;
        private final byte[] magicNumber;
        private final ByteBufsDecoder<byte[]> magicNumberValidator;

        private MagicNumberAdapter(FrameFormat peerFormat, byte[] magicNumber) {
            this.peerFormat = peerFormat;
            this.magicNumber = magicNumber;
            this.magicNumberValidator = ByteBufsDecoder.assertBytes(magicNumber);
        }

        @Override
        public BlockEncoder createEncoder() {
            return new BlockEncoder(){
                final BlockEncoder peer;
                boolean writeMagicNumber;
                {
                    this.peer = peerFormat.createEncoder();
                    this.writeMagicNumber = true;
                }

                @Override
                public ByteBuf encode(ByteBuf inputBuf) {
                    ByteBuf peerEncoded = this.peer.encode(inputBuf);
                    if (this.writeMagicNumber) {
                        this.writeMagicNumber = false;
                        return ByteBufPool.append((ByteBuf)ByteBuf.wrapForReading((byte[])magicNumber), (ByteBuf)peerEncoded);
                    }
                    return peerEncoded;
                }

                @Override
                public void reset() {
                    this.writeMagicNumber = true;
                }

                @Override
                public ByteBuf encodeEndOfStreamBlock() {
                    ByteBuf peerEncodedEndOfStream = this.peer.encodeEndOfStreamBlock();
                    if (this.writeMagicNumber) {
                        this.writeMagicNumber = false;
                        return ByteBufPool.append((ByteBuf)ByteBuf.wrapForReading((byte[])magicNumber), (ByteBuf)peerEncodedEndOfStream);
                    }
                    return peerEncodedEndOfStream;
                }
            };
        }

        @Override
        public BlockDecoder createDecoder() {
            return new BlockDecoder(){
                final BlockDecoder peer;
                boolean validateMagicNumber;
                {
                    this.peer = peerFormat.createDecoder();
                    this.validateMagicNumber = true;
                }

                @Override
                public ByteBuf decode(ByteBufs bufs) throws MalformedDataException {
                    if (this.validateMagicNumber) {
                        if (magicNumberValidator.tryDecode(bufs) == null) {
                            return null;
                        }
                        this.validateMagicNumber = false;
                    }
                    return this.peer.decode(bufs);
                }

                @Override
                public void reset() {
                    this.validateMagicNumber = true;
                }

                @Override
                public boolean ignoreMissingEndOfStreamBlock() {
                    return this.peer.ignoreMissingEndOfStreamBlock();
                }
            };
        }
    }
}

